/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc.cache;

import play.api.libs.ws.ahc.cache.CacheableHttpResponseBodyPart;
import play.api.libs.ws.ahc.cache.CacheableHttpResponseStatus;
import play.api.libs.ws.ahc.cache.CacheableResponse;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;

public class CacheableResponseBuilder {
    private final AsyncHttpClientConfig ahcConfig;
    private List<CacheableHttpResponseBodyPart> bodyParts;
    private Option<CacheableHttpResponseStatus> status;
    private Option<HttpHeaders> headers;

    public CacheableResponseBuilder(AsyncHttpClientConfig ahcConfig) {
        this.ahcConfig = ahcConfig;
        this.bodyParts = package$.MODULE$.Nil();
        this.status = None$.MODULE$;
        this.headers = None$.MODULE$;
    }

    public CacheableResponseBuilder accumulate(HttpResponseStatus responseStatus) {
        Uri uri = responseStatus.getUri();
        int statusCode = responseStatus.getStatusCode();
        String statusText = responseStatus.getStatusText();
        String protocolText = responseStatus.getProtocolText();
        CacheableHttpResponseStatus cacheableStatus = new CacheableHttpResponseStatus(uri, statusCode, statusText, protocolText);
        this.status = Some$.MODULE$.apply((Object)cacheableStatus);
        return this;
    }

    public CacheableResponseBuilder accumulate(HttpHeaders responseHeaders) {
        this.headers = Some$.MODULE$.apply((Object)responseHeaders);
        return this;
    }

    public CacheableResponseBuilder accumulate(HttpResponseBodyPart bodyPart) {
        CacheableHttpResponseBodyPart cacheableBodypart = new CacheableHttpResponseBodyPart(bodyPart.getBodyPartBytes(), bodyPart.isLast());
        this.bodyParts = (List)this.bodyParts.$colon$plus((Object)cacheableBodypart);
        return this;
    }

    public void reset() {
        this.headers = None$.MODULE$;
        this.status = None$.MODULE$;
        this.bodyParts = package$.MODULE$.Nil();
    }

    public CacheableResponse build() {
        return new CacheableResponse((CacheableHttpResponseStatus)((Object)this.status.get()), (HttpHeaders)this.headers.get(), CollectionConverters$.MODULE$.SeqHasAsJava(this.bodyParts).asJava(), this.ahcConfig);
    }
}

