/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc.cache;

import org.playframework.cachecontrol.ResponseCachingAction;
import org.playframework.cachecontrol.ResponseCachingActions;
import play.api.libs.ws.ahc.cache.AhcHttpCache;
import play.api.libs.ws.ahc.cache.BackgroundAsyncHandler$;
import play.api.libs.ws.ahc.cache.CacheableResponse;
import play.api.libs.ws.ahc.cache.CacheableResponseBuilder;
import play.api.libs.ws.ahc.cache.Debug;
import play.api.libs.ws.ahc.cache.EffectiveURIKey;
import play.api.libs.ws.ahc.cache.EffectiveURIKey$;
import play.api.libs.ws.ahc.cache.ResponseEntry;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.Request;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

public class BackgroundAsyncHandler<T>
implements AsyncHandler<T>,
Debug {
    private final Request request;
    private final AhcHttpCache cache;
    private final FiniteDuration timeout;
    private final CacheableResponseBuilder builder;
    private final EffectiveURIKey key;

    public BackgroundAsyncHandler(Request request, AhcHttpCache cache, AsyncHttpClientConfig ahcConfig) {
        this.request = request;
        this.cache = cache;
        this.timeout = Duration$.MODULE$.apply(1L, "second");
        this.builder = new CacheableResponseBuilder(ahcConfig);
        this.key = EffectiveURIKey$.MODULE$.apply(request);
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.builder.accumulate(content);
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        this.builder.reset();
        this.builder.accumulate(status);
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        this.builder.accumulate(headers);
        return AsyncHandler.State.CONTINUE;
    }

    public void onThrowable(Throwable t) {
        BackgroundAsyncHandler$.play$api$libs$ws$ahc$cache$BackgroundAsyncHandler$$$logger.error("onThrowable: received on request " + this.request, t);
    }

    public T onCompleted() {
        CacheableResponse response = this.builder.build();
        if (this.cache.isNotModified(response)) {
            this.processNotModifiedResponse(response);
        } else {
            this.processFullResponse(response);
        }
        return (T)response;
    }

    public void processFullResponse(CacheableResponse fullResponse) {
        BackgroundAsyncHandler$.play$api$libs$ws$ahc$cache$BackgroundAsyncHandler$$$logger.debug("processFullResponse: fullResponse = " + this.debug(fullResponse));
        ResponseCachingAction responseCachingAction = this.cache.cachingAction(this.request, fullResponse);
        if (responseCachingAction instanceof ResponseCachingActions.DoNotCacheResponse) {
            String string;
            ResponseCachingActions.DoNotCacheResponse doNotCacheResponse = ResponseCachingActions.DoNotCacheResponse$.MODULE$.unapply((ResponseCachingActions.DoNotCacheResponse)responseCachingAction);
            String reason = string = doNotCacheResponse._1();
            BackgroundAsyncHandler$.play$api$libs$ws$ahc$cache$BackgroundAsyncHandler$$$logger.debug("onCompleted: DO NOT CACHE, because " + reason);
            return;
        }
        if (responseCachingAction instanceof ResponseCachingActions.DoCacheResponse) {
            String string;
            ResponseCachingActions.DoCacheResponse doCacheResponse = ResponseCachingActions.DoCacheResponse$.MODULE$.unapply((ResponseCachingActions.DoCacheResponse)responseCachingAction);
            String reason = string = doCacheResponse._1();
            BackgroundAsyncHandler$.play$api$libs$ws$ahc$cache$BackgroundAsyncHandler$$$logger.debug("isCacheable: DO CACHE, because " + reason);
            this.cache.cacheResponse(this.request, fullResponse);
            return;
        }
        throw new MatchError((Object)responseCachingAction);
    }

    public void processNotModifiedResponse(CacheableResponse notModifiedResponse) {
        BackgroundAsyncHandler$.play$api$libs$ws$ahc$cache$BackgroundAsyncHandler$$$logger.trace("processNotModifiedResponse: notModifiedResponse = " + notModifiedResponse);
        Option result = (Option)Await$.MODULE$.result(this.cache.get(this.key), (Duration)this.timeout);
        BackgroundAsyncHandler$.play$api$libs$ws$ahc$cache$BackgroundAsyncHandler$$$logger.debug("processNotModifiedResponse: result = " + result);
        Option option = result;
        if (option instanceof Some) {
            ResponseEntry entry = (ResponseEntry)((Some)option).value();
            HttpHeaders newHeaders = notModifiedResponse.getHeaders();
            CacheableResponse freshResponse = this.cache.freshenResponse(newHeaders, entry.response());
            this.cache.cacheResponse(this.request, freshResponse);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }
}

