/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import java.net.URI;
import java.util.function.Function;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.reactivestreams.Publisher;
import play.api.libs.ws.ahc.AhcUtilities;
import play.api.libs.ws.ahc.EmptyPublisher$;
import play.api.libs.ws.ahc.StreamedState;
import play.api.libs.ws.ahc.StreamedState$;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.handler.StreamedAsyncHandler;
import scala.Option;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.TreeMap;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;

public class DefaultStreamedAsyncHandler<T>
implements StreamedAsyncHandler<BoxedUnit>,
AhcUtilities {
    private final Function<StreamedState, T> f;
    private final Promise<T> streamStarted;
    private final Promise<Done> streamDone;
    private StreamedState state;

    public DefaultStreamedAsyncHandler(Function<StreamedState, T> f, Promise<T> streamStarted, Promise<Done> streamDone) {
        this.f = f;
        this.streamStarted = streamStarted;
        this.streamDone = streamDone;
        this.state = StreamedState$.MODULE$.apply(StreamedState$.MODULE$.$lessinit$greater$default$1(), StreamedState$.MODULE$.$lessinit$greater$default$2(), StreamedState$.MODULE$.$lessinit$greater$default$3(), StreamedState$.MODULE$.$lessinit$greater$default$4(), StreamedState$.MODULE$.$lessinit$greater$default$5());
    }

    public AsyncHandler.State onStream(Publisher<HttpResponseBodyPart> publisher) {
        Publisher<HttpResponseBodyPart> publisher2 = this.state.publisher();
        EmptyPublisher$ emptyPublisher$ = EmptyPublisher$.MODULE$;
        if (publisher2 == null ? emptyPublisher$ != null : !publisher2.equals((Object)emptyPublisher$)) {
            return AsyncHandler.State.ABORT;
        }
        StreamedState streamedState = this.state;
        this.state = streamedState.copy(streamedState.copy$default$1(), streamedState.copy$default$2(), streamedState.copy$default$3(), streamedState.copy$default$4(), publisher);
        this.streamStarted.success(this.f.apply(this.state));
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus status) {
        Publisher<HttpResponseBodyPart> publisher = this.state.publisher();
        EmptyPublisher$ emptyPublisher$ = EmptyPublisher$.MODULE$;
        if (publisher == null ? emptyPublisher$ != null : !publisher.equals((Object)emptyPublisher$)) {
            return AsyncHandler.State.ABORT;
        }
        StreamedState streamedState = this.state;
        this.state = streamedState.copy(status.getStatusCode(), status.getStatusText(), (Option<URI>)Option$.MODULE$.apply((Object)status.getUri().toJavaNetURI()), streamedState.copy$default$4(), streamedState.copy$default$5());
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders h) {
        Publisher<HttpResponseBodyPart> publisher = this.state.publisher();
        EmptyPublisher$ emptyPublisher$ = EmptyPublisher$.MODULE$;
        if (publisher == null ? emptyPublisher$ != null : !publisher.equals((Object)emptyPublisher$)) {
            return AsyncHandler.State.ABORT;
        }
        StreamedState streamedState = this.state;
        TreeMap treeMap = this.headersToMap(h);
        int n = streamedState.copy$default$1();
        String string = streamedState.copy$default$2();
        Option<URI> option = streamedState.copy$default$3();
        Publisher<HttpResponseBodyPart> publisher2 = streamedState.copy$default$5();
        this.state = streamedState.copy(n, string, option, (Map<String, Seq<String>>)treeMap, publisher2);
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) {
        throw new IllegalStateException("Should not have received bodypart");
    }

    public void onCompleted() {
        StreamedState streamedState = this.state;
        EmptyPublisher$ emptyPublisher$ = EmptyPublisher$.MODULE$;
        int n = streamedState.copy$default$1();
        String string = streamedState.copy$default$2();
        Option<URI> option = streamedState.copy$default$3();
        Map<String, Seq<String>> map = streamedState.copy$default$4();
        this.streamStarted.trySuccess(this.f.apply(streamedState.copy(n, string, option, map, emptyPublisher$)));
        this.streamDone.trySuccess((Object)Done$.MODULE$);
    }

    public void onThrowable(Throwable t) {
        this.streamStarted.tryFailure(t);
        this.streamDone.tryFailure(t);
    }
}

