/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.pekko.util.ByteString;
import play.api.libs.ws.ahc.AhcWSUtils;
import play.libs.ws.BodyReadable;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.WSCookie;
import play.libs.ws.WSCookieBuilder;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.org.asynchttpclient.Response;

public class StandaloneAhcWSResponse
implements StandaloneWSResponse {
    private final Response ahcResponse;

    public StandaloneAhcWSResponse(Response response) {
        this.ahcResponse = response;
    }

    public Object getUnderlying() {
        return this.ahcResponse;
    }

    public int getStatus() {
        return this.ahcResponse.getStatusCode();
    }

    public String getStatusText() {
        return this.ahcResponse.getStatusText();
    }

    public Map<String, List<String>> getHeaders() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        HttpHeaders httpHeaders = this.ahcResponse.getHeaders();
        for (String string : httpHeaders.names()) {
            List list = httpHeaders.getAll(string);
            treeMap.put(string, list);
        }
        return treeMap;
    }

    public List<WSCookie> getCookies() {
        return this.ahcResponse.getCookies().stream().map(this::asCookie).collect(Collectors.toList());
    }

    public WSCookie asCookie(Cookie cookie) {
        return new WSCookieBuilder().setName(cookie.name()).setValue(cookie.value()).setDomain(cookie.domain()).setPath(cookie.path()).setMaxAge(Long.valueOf(cookie.maxAge())).setSecure(cookie.isSecure()).setHttpOnly(cookie.isHttpOnly()).build();
    }

    public Optional<WSCookie> getCookie(String string) {
        for (Cookie cookie : this.ahcResponse.getCookies()) {
            if (!cookie.name().equals(string)) continue;
            return Optional.of(this.asCookie(cookie));
        }
        return Optional.empty();
    }

    public String getBody() {
        return AhcWSUtils.getResponseBody(this.ahcResponse);
    }

    public ByteString getBodyAsBytes() {
        return ByteString.fromArray((byte[])this.ahcResponse.getResponseBodyAsBytes());
    }

    public <T> T getBody(BodyReadable<T> bodyReadable) {
        return (T)bodyReadable.apply((Object)this);
    }

    public String getContentType() {
        String string = this.ahcResponse.getContentType();
        if (string == null) {
            string = "application/octet-stream";
        }
        return string;
    }

    public URI getUri() {
        try {
            return this.ahcResponse.getUri().toJavaNetURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

