/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc.cache;

import java.time.ZonedDateTime;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.ResponseCachingAction;
import org.playframework.cachecontrol.ResponseCachingActions;
import org.playframework.cachecontrol.ResponseServeAction;
import org.playframework.cachecontrol.ResponseServeActions;
import org.playframework.cachecontrol.Seconds;
import play.api.libs.ws.ahc.cache.AhcHttpCache;
import play.api.libs.ws.ahc.cache.AsyncCachingHandler$;
import play.api.libs.ws.ahc.cache.CacheableResponse;
import play.api.libs.ws.ahc.cache.CacheableResponseBuilder;
import play.api.libs.ws.ahc.cache.Debug;
import play.api.libs.ws.ahc.cache.EffectiveURIKey;
import play.api.libs.ws.ahc.cache.EffectiveURIKey$;
import play.api.libs.ws.ahc.cache.ResponseEntry;
import play.api.libs.ws.ahc.cache.TimeoutResponse;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncCompletionHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.Response;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class AsyncCachingHandler<T>
implements AsyncHandler<T>,
TimeoutResponse,
Debug {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AsyncCachingHandler.class.getDeclaredField("timeoutResponse$lzy1"));
    private final Request request;
    private final AsyncCompletionHandler<T> handler;
    private final AhcHttpCache cache;
    private final Option<ResponseServeAction> maybeAction;
    private final AsyncHttpClientConfig ahcConfig;
    private final String DATE;
    private final CacheableResponseBuilder builder;
    private final ZonedDateTime requestTime;
    private final EffectiveURIKey key;
    private final Duration timeout;
    private volatile Object timeoutResponse$lzy1;

    public AsyncCachingHandler(Request request, AsyncCompletionHandler<T> handler, AhcHttpCache cache, Option<ResponseServeAction> maybeAction, AsyncHttpClientConfig ahcConfig) {
        this.request = request;
        this.handler = handler;
        this.cache = cache;
        this.maybeAction = maybeAction;
        this.ahcConfig = ahcConfig;
        this.DATE = "Date";
        this.builder = new CacheableResponseBuilder(ahcConfig);
        this.requestTime = HttpDate$.MODULE$.now();
        this.key = EffectiveURIKey$.MODULE$.apply(request);
        this.timeout = Duration$.MODULE$.apply(1L, "second");
    }

    public CacheableResponseBuilder builder() {
        return this.builder;
    }

    public ZonedDateTime requestTime() {
        return this.requestTime;
    }

    public EffectiveURIKey key() {
        return this.key;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public CacheableResponse timeoutResponse() {
        Object object = this.timeoutResponse$lzy1;
        if (object instanceof CacheableResponse) {
            return (CacheableResponse)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CacheableResponse)this.timeoutResponse$lzyINIT1();
    }

    private Object timeoutResponse$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.timeoutResponse$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CacheableResponse cacheableResponse = null;
                    try {
                        cacheableResponse = this.generateTimeoutResponse(this.request, this.ahcConfig);
                        object2 = cacheableResponse == null ? LazyVals.NullValue$.MODULE$ : cacheableResponse;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.timeoutResponse$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cacheableResponse;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void onThrowable(Throwable t) {
        ResponseServeAction responseServeAction;
        Option<ResponseServeAction> option = this.maybeAction;
        if (option instanceof Some && (responseServeAction = (ResponseServeAction)((Some)option).value()) instanceof ResponseServeActions.ValidateOrTimeout) {
            String string;
            ResponseServeActions.ValidateOrTimeout validateOrTimeout = ResponseServeActions.ValidateOrTimeout$.MODULE$.unapply((ResponseServeActions.ValidateOrTimeout)responseServeAction);
            String reason = string = validateOrTimeout._1();
            AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.debug("onCompleted: returning timeout because " + reason, t);
            this.processTimeoutResponse();
            return;
        }
        Option<ResponseServeAction> other = option;
        AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.debug("onCompleted: action = " + other, t);
        this.processDisconnectedResponse();
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
        this.builder().accumulate(responseStatus);
        return this.handler.onStatusReceived(responseStatus);
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders responseHeaders) {
        if (!responseHeaders.contains(this.DATE)) {
            String currentDate = HttpDate$.MODULE$.format(HttpDate$.MODULE$.now());
            responseHeaders.add(this.DATE, (Object)currentDate);
        }
        this.builder().accumulate(responseHeaders);
        return this.handler.onHeadersReceived(responseHeaders);
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) {
        this.builder().accumulate(bodyPart);
        return this.handler.onBodyPartReceived(bodyPart);
    }

    public T onCompleted() {
        if (AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.isTraceEnabled()) {
            AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.trace("onCompleted: this = " + this);
        }
        CacheableResponse response = this.builder().build();
        if (AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.isDebugEnabled()) {
            AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.debug("onCompleted: response = " + this.debug(response));
        }
        this.cache.invalidateIfUnsafe(this.request, response);
        if (this.cache.isNotModified(response)) {
            return this.processNotModifiedResponse(response);
        }
        if (this.cache.isError(response)) {
            ResponseServeAction responseServeAction;
            Option<ResponseServeAction> option = this.maybeAction;
            if (option instanceof Some && (responseServeAction = (ResponseServeAction)((Some)option).value()) instanceof ResponseServeActions.Validate) {
                ResponseServeActions.Validate validate = ResponseServeActions.Validate$.MODULE$.unapply((ResponseServeActions.Validate)responseServeAction);
                String string = validate._1();
                boolean bl = validate._2();
                String reason = string;
                boolean staleIfError = bl;
                if (staleIfError) {
                    return this.processStaleResponse(response);
                }
            }
            Option<ResponseServeAction> other = option;
            return this.processFullResponse(response);
        }
        return this.processFullResponse(response);
    }

    public void processTimeoutResponse() {
        this.handler.onCompleted((Response)this.timeoutResponse());
    }

    public T processDisconnectedResponse() {
        CacheableResponse cacheableResponse;
        Option result;
        AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.debug("processDisconnectedResponse:");
        Option option = result = (Option)Await$.MODULE$.result(this.cache.get(this.key()), this.timeout());
        if (option instanceof Some) {
            ResponseEntry entry = (ResponseEntry)((Some)option).value();
            Seconds currentAge = this.cache.calculateCurrentAge(this.request, entry, this.requestTime());
            Seconds freshnessLifetime = this.cache.calculateFreshnessLifetime(this.request, entry);
            boolean isFresh = freshnessLifetime.isGreaterThan(currentAge);
            cacheableResponse = this.cache.addRevalidationFailed(this.cache.addDisconnectHeader(this.cache.generateCachedResponse(this.request, entry, currentAge, isFresh)));
        } else if (None$.MODULE$.equals(option)) {
            cacheableResponse = this.timeoutResponse();
        } else {
            throw new MatchError((Object)option);
        }
        CacheableResponse finalResponse = cacheableResponse;
        return (T)this.handler.onCompleted((Response)finalResponse);
    }

    public T processStaleResponse(CacheableResponse response) {
        CacheableResponse cacheableResponse;
        Option result;
        AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.debug("processCachedResponse: response = " + this.debug(response));
        Option option = result = (Option)Await$.MODULE$.result(this.cache.get(this.key()), this.timeout());
        if (option instanceof Some) {
            ResponseEntry entry = (ResponseEntry)((Some)option).value();
            Seconds currentAge = this.cache.calculateCurrentAge(this.request, entry, this.requestTime());
            cacheableResponse = this.cache.addRevalidationFailed(this.cache.generateCachedResponse(this.request, entry, currentAge, false));
        } else if (None$.MODULE$.equals(option)) {
            cacheableResponse = response;
        } else {
            throw new MatchError((Object)option);
        }
        CacheableResponse finalResponse = cacheableResponse;
        return (T)this.handler.onCompleted((Response)finalResponse);
    }

    public T processFullResponse(CacheableResponse fullResponse) {
        AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.debug("processFullResponse: fullResponse = " + this.debug(fullResponse));
        ResponseCachingAction responseCachingAction = this.cache.cachingAction(this.request, fullResponse);
        if (responseCachingAction instanceof ResponseCachingActions.DoNotCacheResponse) {
            String string;
            ResponseCachingActions.DoNotCacheResponse doNotCacheResponse = ResponseCachingActions.DoNotCacheResponse$.MODULE$.unapply((ResponseCachingActions.DoNotCacheResponse)responseCachingAction);
            String reason = string = doNotCacheResponse._1();
            AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.debug("onCompleted: DO NOT CACHE, because " + reason);
        } else if (responseCachingAction instanceof ResponseCachingActions.DoCacheResponse) {
            String string;
            ResponseCachingActions.DoCacheResponse doCacheResponse = ResponseCachingActions.DoCacheResponse$.MODULE$.unapply((ResponseCachingActions.DoCacheResponse)responseCachingAction);
            String reason = string = doCacheResponse._1();
            AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.debug("isCacheable: DO CACHE, because " + reason);
            this.cache.cacheResponse(this.request, fullResponse);
        } else {
            throw new MatchError((Object)responseCachingAction);
        }
        return (T)this.handler.onCompleted((Response)fullResponse);
    }

    public T processNotModifiedResponse(CacheableResponse notModifiedResponse) {
        CacheableResponse cacheableResponse;
        AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.trace("processNotModifiedResponse: notModifiedResponse = " + notModifiedResponse);
        Option result = (Option)Await$.MODULE$.result(this.cache.get(this.key()), this.timeout());
        AsyncCachingHandler$.play$api$libs$ws$ahc$cache$AsyncCachingHandler$$$logger.debug("processNotModifiedResponse: result = " + result);
        Option option = result;
        if (option instanceof Some) {
            ResponseEntry entry = (ResponseEntry)((Some)option).value();
            HttpHeaders newHeaders = notModifiedResponse.getHeaders();
            CacheableResponse freshResponse = this.cache.freshenResponse(newHeaders, entry.response());
            this.cache.cacheResponse(this.request, freshResponse);
            cacheableResponse = freshResponse;
        } else if (None$.MODULE$.equals(option)) {
            cacheableResponse = notModifiedResponse;
        } else {
            throw new MatchError((Object)option);
        }
        CacheableResponse fullResponse = cacheableResponse;
        return (T)this.handler.onCompleted((Response)fullResponse);
    }

    public String toString() {
        return "CacheAsyncHandler(key = " + this.key() + ", requestTime = " + this.requestTime() + ", builder = " + this.builder() + ", asyncHandler = " + this.debug((AsyncHandler)this.handler) + "})";
    }
}

