/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc.cache;

import java.io.Serializable;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import org.playframework.cachecontrol.CacheDefaults;
import org.playframework.cachecontrol.CacheDirectives;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.CacheRequest$;
import org.playframework.cachecontrol.CacheResponse;
import org.playframework.cachecontrol.CurrentAgeCalculator;
import org.playframework.cachecontrol.FreshnessCalculator;
import org.playframework.cachecontrol.HeaderName;
import org.playframework.cachecontrol.HeaderName$;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.OriginResponse;
import org.playframework.cachecontrol.OriginResponse$;
import org.playframework.cachecontrol.ResponseCachingAction;
import org.playframework.cachecontrol.ResponseCachingCalculator;
import org.playframework.cachecontrol.ResponseSelectionAction;
import org.playframework.cachecontrol.ResponseSelectionCalculator;
import org.playframework.cachecontrol.ResponseServeAction;
import org.playframework.cachecontrol.ResponseServingCalculator;
import org.playframework.cachecontrol.SecondaryKeyCalculator;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.Seconds$;
import org.playframework.cachecontrol.StoredResponse;
import org.playframework.cachecontrol.StoredResponse$;
import org.playframework.cachecontrol.StripHeaderCalculator;
import org.playframework.cachecontrol.Warning;
import org.playframework.cachecontrol.Warning$;
import org.playframework.cachecontrol.WarningParser$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.ahc.AhcUtilities;
import play.api.libs.ws.ahc.cache.AhcHttpCache$;
import play.api.libs.ws.ahc.cache.Cache;
import play.api.libs.ws.ahc.cache.CacheableHttpResponseBodyPart;
import play.api.libs.ws.ahc.cache.CacheableHttpResponseStatus;
import play.api.libs.ws.ahc.cache.CacheableResponse;
import play.api.libs.ws.ahc.cache.Debug;
import play.api.libs.ws.ahc.cache.EffectiveURIKey;
import play.api.libs.ws.ahc.cache.EffectiveURIKey$;
import play.api.libs.ws.ahc.cache.ResponseEntry;
import play.api.libs.ws.ahc.cache.ResponseEntry$;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.Response;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class AhcHttpCache
implements CacheDefaults,
AhcUtilities,
Debug {
    private final Cache underlying;
    private final boolean heuristicsEnabled;
    private final ExecutionContext executionContext;
    private final Logger logger;
    private final ResponseCachingCalculator responseCachingCalculator;
    private final ResponseServingCalculator responseServingCalculator;
    private final ResponseSelectionCalculator responseSelectionCalculator;
    private final StripHeaderCalculator stripHeaderCalculator;
    private final SecondaryKeyCalculator secondaryKeyCalculator;
    private final CurrentAgeCalculator currentAgeCalculator;
    private final FreshnessCalculator freshnessCalculator;

    public static boolean $lessinit$greater$default$2() {
        return AhcHttpCache$.MODULE$.$lessinit$greater$default$2();
    }

    public AhcHttpCache(Cache underlying, boolean heuristicsEnabled, ExecutionContext executionContext) {
        this.underlying = underlying;
        this.heuristicsEnabled = heuristicsEnabled;
        this.executionContext = executionContext;
        Predef$.MODULE$.require(underlying != null, AhcHttpCache::$init$$$anonfun$1);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.responseCachingCalculator = new ResponseCachingCalculator((org.playframework.cachecontrol.Cache)this);
        this.responseServingCalculator = new ResponseServingCalculator((org.playframework.cachecontrol.Cache)this);
        this.responseSelectionCalculator = new ResponseSelectionCalculator((org.playframework.cachecontrol.Cache)this);
        this.stripHeaderCalculator = new StripHeaderCalculator((org.playframework.cachecontrol.Cache)this);
        this.secondaryKeyCalculator = new SecondaryKeyCalculator();
        this.currentAgeCalculator = new CurrentAgeCalculator();
        this.freshnessCalculator = new FreshnessCalculator((org.playframework.cachecontrol.Cache)this);
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public boolean isShared() {
        return false;
    }

    public Future<Option<ResponseEntry>> get(EffectiveURIKey key) {
        this.logger.debug("get: key = " + key);
        Predef$.MODULE$.require(key != null, AhcHttpCache::get$$anonfun$1);
        return this.underlying.get(key);
    }

    public Future<BoxedUnit> put(EffectiveURIKey key, ResponseEntry entry) {
        this.logger.debug("put: key = " + key + ", entry = " + entry);
        Predef$.MODULE$.require(entry != null, AhcHttpCache::put$$anonfun$1);
        return this.underlying.put(key, entry);
    }

    public Future<BoxedUnit> remove(EffectiveURIKey key) {
        Predef$.MODULE$.require(key != null, AhcHttpCache::remove$$anonfun$1);
        return this.underlying.remove(key);
    }

    public void invalidateKey(EffectiveURIKey key) {
        this.underlying.get(key).map((Function1)(JProcedure1 & Serializable)maybeEntry -> maybeEntry.foreach((Function1 & Serializable)entry -> {
            Some some = Some$.MODULE$.apply((Object)HttpDate$.MODULE$.fromEpochSeconds(0));
            CacheableResponse cacheableResponse = entry.copy$default$1();
            String string = entry.copy$default$2();
            Map<HeaderName, Seq<String>> map = entry.copy$default$3();
            ResponseEntry expiredEntry = entry.copy(cacheableResponse, string, map, (Option<ZonedDateTime>)some);
            return this.put(key, expiredEntry);
        }), this.executionContext());
    }

    public ResponseCachingAction cachingAction(Request request, CacheableResponse response) {
        HttpHeaders headers = response.headers();
        int statusCode = response.getStatusCode();
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        OriginResponse originResponse = this.generateOriginResponse(request, statusCode, headers);
        ResponseCachingAction action = this.responseCachingCalculator.isCacheable(cacheRequest, originResponse);
        return action;
    }

    public ResponseSelectionAction selectionAction(Request request, Seq<ResponseEntry> entries) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        Seq storedResponses = (Seq)entries.map((Function1 & Serializable)entry -> this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders()));
        return this.responseSelectionCalculator.selectResponse(cacheRequest, storedResponses);
    }

    public ResponseServeAction serveAction(Request request, ResponseEntry entry, Seconds currentAge) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        StoredResponse storedResponse = this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders());
        return this.responseServingCalculator.serveResponse(cacheRequest, storedResponse, currentAge);
    }

    public Option<Seconds> calculateFreshnessFromHeuristic(CacheRequest request, CacheResponse response) {
        if (this.heuristicsEnabled) {
            return response.headers().get((Object)HeaderName$.MODULE$.apply("Last-Modified")).map((Function1 & Serializable)lastModifiedString -> {
                ZonedDateTime lastModified = HttpDate$.MODULE$.parse((String)lastModifiedString.head());
                ZonedDateTime lastRequestedAt = HttpDate$.MODULE$.now();
                Seconds timeSinceLastModified = HttpDate$.MODULE$.diff(lastModified, lastRequestedAt);
                int scaledDownSeconds = (int)(0.1 * (double)timeSinceLastModified.seconds());
                Seconds scaledSeconds = Seconds$.MODULE$.seconds(Int$.MODULE$.int2long(scaledDownSeconds));
                return scaledSeconds;
            });
        }
        return None$.MODULE$;
    }

    public boolean isCacheableExtension(CacheDirectives.CacheDirectiveExtension extension) {
        return false;
    }

    public boolean isNotModified(CacheableResponse response) {
        return response.getStatusCode() == 304;
    }

    public boolean isError(CacheableResponse response) {
        int n = response.getStatusCode();
        switch (n) {
            case 500: 
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        int other = n;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isUnsafeMethod(Request request) {
        String string = request.getMethod();
        switch (string == null ? 0 : string.hashCode()) {
            case -531492226: {
                if ("OPTIONS".equals(string)) return false;
                break;
            }
            case 70454: {
                if ("GET".equals(string)) return false;
                break;
            }
            case 2213344: {
                if ("HEAD".equals(string)) return false;
                break;
            }
            case 80083237: {
                if (!"TRACE".equals(string)) break;
                return false;
            }
        }
        String other = string;
        return true;
    }

    public Seconds calculateCurrentAge(Request request, ResponseEntry entry, ZonedDateTime requestTime) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        StoredResponse storedResponse = this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders());
        Seconds currentAge = this.calculateCurrentAge(cacheRequest, storedResponse, requestTime, HttpDate$.MODULE$.now());
        return currentAge;
    }

    public Seconds calculateFreshnessLifetime(Request request, ResponseEntry entry) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        StoredResponse storedResponse = this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders());
        Seconds freshnessLifetime = this.freshnessCalculator.calculateFreshnessLifetime(cacheRequest, (CacheResponse)storedResponse);
        return freshnessLifetime;
    }

    public void invalidateIfUnsafe(Request request, CacheableResponse response) {
        this.logger.trace("invalidate: request = " + this.debug(request) + ", response = " + this.debug(response));
        if (this.isUnsafeMethod(request) && this.isNonErrorResponse(response)) {
            String requestHost = request.getUri().getHost();
            EffectiveURIKey responseKey = EffectiveURIKey$.MODULE$.apply(request.getMethod(), response.getUri().toJavaNetURI());
            this.invalidateKey(responseKey);
            this.getURI(response, "Content-Location").foreach((Function1)(JProcedure1 & Serializable)contentLocation -> {
                if (requestHost.equalsIgnoreCase(contentLocation.getHost())) {
                    EffectiveURIKey key = EffectiveURIKey$.MODULE$.apply(request.getMethod(), (URI)contentLocation);
                    this.invalidateKey(key);
                    return;
                }
            });
            this.getURI(response, "Location").foreach((Function1)(JProcedure1 & Serializable)location -> {
                if (requestHost.equalsIgnoreCase(location.getHost())) {
                    EffectiveURIKey key = EffectiveURIKey$.MODULE$.apply(request.getMethod(), (URI)location);
                    this.invalidateKey(key);
                    return;
                }
            });
            return;
        }
    }

    public Option<URI> getURI(CacheableResponse response, String headerName) {
        return Option$.MODULE$.apply((Object)response.getHeaders().get(headerName)).map((Function1 & Serializable)value -> {
            URI baseURI = response.getUri().toJavaNetURI();
            return baseURI.resolve((String)value);
        });
    }

    public boolean isNonErrorResponse(CacheableResponse response) {
        int n = response.getStatusCode();
        int success = n;
        if (success >= 200 && success < 300) {
            return true;
        }
        int redirect = n;
        if (redirect >= 300 && redirect < 400) {
            return true;
        }
        int other = n;
        return false;
    }

    public Option<Map<HeaderName, Seq<String>>> calculateSecondaryKeys(Request request, Response response) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        TreeMap headers = (TreeMap)this.headersToMap(response.getHeaders()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)HeaderName$.MODULE$.apply(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return this.secondaryKeyCalculator.calculate(cacheRequest, (Map)headers);
    }

    public Seconds calculateCurrentAge(CacheRequest request, StoredResponse response, ZonedDateTime requestTime, ZonedDateTime responseTime) {
        return this.currentAgeCalculator.calculateCurrentAge(request, response, requestTime, responseTime);
    }

    public Option<ZonedDateTime> calculateTimeToLive(Request request, CacheableHttpResponseStatus status, HttpHeaders headers) {
        return Some$.MODULE$.apply((Object)ZonedDateTime.now().plusHours(24L));
    }

    public void cacheResponse(Request request, CacheableResponse response) {
        this.logger.debug("cacheResponse: response = " + this.debug(response));
        CacheableResponse strippedResponse = this.stripHeaders(request, response);
        this.logger.debug("cacheResponse: strippedResponse = " + this.debug(strippedResponse));
        Map nominated = (Map)this.calculateSecondaryKeys(request, strippedResponse).getOrElse(AhcHttpCache::$anonfun$3);
        Option<ZonedDateTime> ttl = this.calculateTimeToLive(request, strippedResponse.status(), strippedResponse.headers());
        ResponseEntry entry = ResponseEntry$.MODULE$.apply(strippedResponse, request.getMethod(), (Map<HeaderName, Seq<String>>)nominated, ttl);
        this.put(EffectiveURIKey$.MODULE$.apply(request), entry);
    }

    public boolean isUncachedResponse(Object any) {
        Object object = any;
        if (object instanceof CacheableHttpResponseStatus) {
            CacheableHttpResponseStatus chrs = (CacheableHttpResponseStatus)((Object)object);
            return false;
        }
        if (object instanceof HttpHeaders) {
            HttpHeaders headers = (HttpHeaders)object;
            return false;
        }
        if (object instanceof CacheableHttpResponseBodyPart) {
            CacheableHttpResponseBodyPart bodyPart = (CacheableHttpResponseBodyPart)((Object)object);
            return false;
        }
        if (object instanceof CacheableResponse) {
            CacheableResponse response = (CacheableResponse)object;
            return false;
        }
        return true;
    }

    public CacheableResponse freshenResponse(HttpHeaders newHeaders, CacheableResponse response) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("freshenResponse: newHeaders = " + newHeaders + ", storedResponse = " + response);
        }
        HttpHeaders headers = response.headers();
        HttpHeaders headersMap = new DefaultHttpHeaders().add(headers);
        List filteredWarnings = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(headersMap.getAll("Warning")).asScala().filter((Function1 & Serializable)line -> {
            Warning warning = WarningParser$.MODULE$.parse(line);
            return warning.code() < 200;
        })).asJava();
        headersMap.set("Warning", (java.lang.Iterable)filteredWarnings);
        headersMap.set(newHeaders);
        return response.copy(response.copy$default$1(), headersMap, response.copy$default$3(), response.copy$default$4());
    }

    public CacheableResponse generateCachedResponse(Request request, ResponseEntry entry, Seconds currentAge, boolean isFresh) {
        return this.replaceHeaders(entry.response(), (Function1<HttpHeaders, HttpHeaders>)(Function1 & Serializable)headers -> {
            headers.set("Age", (Object)BoxesRunTime.boxToLong((long)currentAge.seconds()).toString());
            if (!isFresh) {
                headers.add("Warning", (Object)Warning$.MODULE$.apply(110, "-", "Response is Stale", (Option)None$.MODULE$).toString());
            }
            return headers;
        });
    }

    public CacheableResponse addRevalidationFailed(CacheableResponse response) {
        return this.replaceHeaders(response, (Function1<HttpHeaders, HttpHeaders>)(Function1 & Serializable)headers -> headers.add("Warning", (Object)Warning$.MODULE$.apply(111, "-", "Revalidation Failed", (Option)None$.MODULE$).toString()));
    }

    public CacheableResponse addDisconnectHeader(CacheableResponse response) {
        return this.replaceHeaders(response, (Function1<HttpHeaders, HttpHeaders>)(Function1 & Serializable)headers -> headers.add("Warning", (Object)Warning$.MODULE$.apply(112, "-", "Disconnected Operation", (Option)None$.MODULE$).toString()));
    }

    public CacheableResponse replaceHeaders(CacheableResponse response, Function1<HttpHeaders, HttpHeaders> block) {
        HttpHeaders newHeadersMap = (HttpHeaders)block.apply((Object)new DefaultHttpHeaders().add(response.getHeaders()));
        return response.copy(response.copy$default$1(), newHeadersMap, response.copy$default$3(), response.copy$default$4());
    }

    public CacheRequest generateCacheRequest(Request request) {
        URI uri = request.getUri().toJavaNetURI();
        TreeMap headers = (TreeMap)this.headersToMap(request.getHeaders()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)HeaderName$.MODULE$.apply(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        String method = request.getMethod();
        return CacheRequest$.MODULE$.apply(uri, method, (Map)headers);
    }

    public StoredResponse generateStoredResponse(CacheableResponse response, String requestMethod, Map<HeaderName, Seq<String>> nominatedHeaders) {
        URI uri = response.getUri().toJavaNetURI();
        int status = response.getStatusCode();
        HttpHeaders responseHeaders = response.getHeaders();
        TreeMap headers = (TreeMap)this.headersToMap(responseHeaders).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)HeaderName$.MODULE$.apply(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return StoredResponse$.MODULE$.apply(uri, status, (Map)headers, requestMethod, nominatedHeaders);
    }

    public OriginResponse generateOriginResponse(Request request, int status, HttpHeaders responseHeaders) {
        URI uri = request.getUri().toJavaNetURI();
        TreeMap headers = (TreeMap)this.headersToMap(responseHeaders).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)HeaderName$.MODULE$.apply(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return OriginResponse$.MODULE$.apply(uri, status, (Map)headers);
    }

    public CacheableResponse stripHeaders(Request request, CacheableResponse httpResponse) {
        CacheableResponse cacheableResponse;
        OriginResponse originResponse = this.generateOriginResponse(request, httpResponse.getStatusCode(), httpResponse.headers());
        Set stripSet = this.stripHeaderCalculator.stripHeaders((CacheResponse)originResponse);
        if (stripSet.nonEmpty()) {
            Collection stripHeaderNames = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)stripSet.map((Function1 & Serializable)_$1 -> _$1.toString())).asJavaCollection();
            this.logger.debug("massageCachedResponse: stripHeaderNames = " + stripHeaderNames);
            HttpHeaders httpHeaders = httpResponse.getHeaders();
            CollectionConverters$.MODULE$.CollectionHasAsScala(stripHeaderNames).asScala().foreach((Function1 & Serializable)x$0 -> httpHeaders.remove(x$0));
            this.logger.debug("massageCachedResponse: strippedHeaders = " + httpResponse.getHeaders());
            HttpHeaders httpHeaders2 = httpResponse.getHeaders();
            CacheableHttpResponseStatus cacheableHttpResponseStatus = httpResponse.copy$default$1();
            List<CacheableHttpResponseBodyPart> list = httpResponse.copy$default$3();
            AsyncHttpClientConfig asyncHttpClientConfig = httpResponse.copy$default$4();
            cacheableResponse = httpResponse.copy(cacheableHttpResponseStatus, httpHeaders2, list, asyncHttpClientConfig);
        } else {
            cacheableResponse = httpResponse;
        }
        CacheableResponse r = cacheableResponse;
        return r;
    }

    public void close() {
        this.underlying.close();
    }

    public String toString() {
        return "AhcHttpCache(" + this.underlying + ")";
    }

    private static final Object $init$$$anonfun$1() {
        return "null underlying!";
    }

    private static final Object get$$anonfun$1() {
        return "key is null";
    }

    private static final Object put$$anonfun$1() {
        return "value is null";
    }

    private static final Object remove$$anonfun$1() {
        return "key is null";
    }

    private static final Map $anonfun$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }
}

