/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import java.io.Serializable;
import java.net.URI;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.reactivestreams.Publisher;
import play.api.libs.ws.StandaloneWSResponse;
import play.api.libs.ws.WSCookie;
import play.api.libs.ws.ahc.AhcWSUtils$;
import play.api.libs.ws.ahc.CaseInsensitiveOrdered$;
import play.api.libs.ws.ahc.CookieBuilder;
import play.api.libs.ws.ahc.StandaloneAhcWSClient;
import play.api.libs.ws.ahc.WSCookieConverter;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.SortedMapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.TreeMap$;
import scala.collection.mutable.TreeMap;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class StreamedResponse
implements StandaloneWSResponse,
WSCookieConverter,
CookieBuilder {
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(StreamedResponse.class.getDeclaredField("bodyAsSource$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(StreamedResponse.class.getDeclaredField("bodyAsBytes$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(StreamedResponse.class.getDeclaredField("body$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(StreamedResponse.class.getDeclaredField("cookies$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StreamedResponse.class.getDeclaredField("headers$lzy1"));
    private StandaloneAhcWSClient client;
    private final int status;
    private final String statusText;
    private final URI uri;
    private final Publisher<HttpResponseBodyPart> publisher;
    private final boolean useLaxCookieEncoder;
    private Map<String, Seq<String>> origHeaders;
    private volatile Object headers$lzy1;
    private volatile Object cookies$lzy1;
    private volatile Object body$lzy1;
    private volatile Object bodyAsBytes$lzy1;
    private volatile Object bodyAsSource$lzy1;

    public StreamedResponse(StandaloneAhcWSClient client, int status, String statusText, URI uri, Publisher<HttpResponseBodyPart> publisher, boolean useLaxCookieEncoder) {
        this.client = client;
        this.status = status;
        this.statusText = statusText;
        this.uri = uri;
        this.publisher = publisher;
        this.useLaxCookieEncoder = useLaxCookieEncoder;
        this.origHeaders = Predef$.MODULE$.Map().empty();
    }

    public int status() {
        return this.status;
    }

    public String statusText() {
        return this.statusText;
    }

    public URI uri() {
        return this.uri;
    }

    @Override
    public boolean useLaxCookieEncoder() {
        return this.useLaxCookieEncoder;
    }

    public StreamedResponse(StandaloneAhcWSClient client, int status, String statusText, URI uri, Map<String, Seq<String>> headers, Publisher<HttpResponseBodyPart> publisher, boolean useLaxCookieEncoder) {
        this(client, status, statusText, uri, publisher, useLaxCookieEncoder);
        this.origHeaders = headers;
    }

    public <T> T underlying() {
        return (T)this.publisher;
    }

    public Map<String, Seq<String>> headers() {
        Object object = this.headers$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.headers$lzyINIT1();
    }

    private Object headers$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.headers$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        TreeMap mutableMap = (TreeMap)scala.collection.mutable.TreeMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Ordering)CaseInsensitiveOrdered$.MODULE$);
                        this.origHeaders.keys().foreach((Function1 & Serializable)name -> mutableMap.updateWith(name, (Function1 & Serializable)x$1 -> {
                            Option option = x$1;
                            if (option instanceof Some) {
                                Seq value = (Seq)((Some)option).value();
                                return Some$.MODULE$.apply(value.$plus$plus((IterableOnce)this.origHeaders.getOrElse(name, StreamedResponse::headers$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$1)));
                            }
                            if (None$.MODULE$.equals(option)) {
                                return Some$.MODULE$.apply(this.origHeaders.getOrElse(name, StreamedResponse::headers$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$2));
                            }
                            throw new MatchError((Object)option);
                        }));
                        map = (Map)((SortedMapOps)TreeMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Ordering)CaseInsensitiveOrdered$.MODULE$)).$plus$plus((IterableOnce)mutableMap);
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.headers$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.headers$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<WSCookie> cookies() {
        Object object = this.cookies$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.cookies$lzyINIT1();
    }

    private Object cookies$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cookies$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Seq seq = null;
                    try {
                        seq = this.buildCookies((Map)this.headers());
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cookies$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<WSCookie> cookie(String name) {
        return this.cookies().find((Function1 & Serializable)_$1 -> {
            String string = _$1.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public String body() {
        Object object = this.body$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.body$lzyINIT1();
    }

    private Object body$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.body$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = this.bodyAsBytes().decodeString(AhcWSUtils$.MODULE$.getCharset(this.contentType()));
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.body$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ByteString bodyAsBytes() {
        Object object = this.bodyAsBytes$lzy1;
        if (object instanceof ByteString) {
            return (ByteString)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ByteString)this.bodyAsBytes$lzyINIT1();
    }

    private Object bodyAsBytes$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.bodyAsBytes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ByteString byteString = null;
                    try {
                        byteString = this.client.blockingToByteString(this.bodyAsSource());
                        object2 = byteString == null ? LazyVals.NullValue$.MODULE$ : byteString;
                        this.client = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.bodyAsBytes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return byteString;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Source<ByteString, ?> bodyAsSource() {
        Object object = this.bodyAsSource$lzy1;
        if (object instanceof Source) {
            return (Source)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Source)this.bodyAsSource$lzyINIT1();
    }

    private Object bodyAsSource$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.bodyAsSource$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Source source = null;
                    try {
                        source = (Source)Source$.MODULE$.fromPublisher(this.publisher).map((Function1 & Serializable)bodyPart -> ByteString$.MODULE$.fromArray(bodyPart.getBodyPartBytes()));
                        object2 = source == null ? LazyVals.NullValue$.MODULE$ : source;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.bodyAsSource$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return source;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final Seq headers$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final Seq headers$lzyINIT1$$anonfun$1$$anonfun$1$$anonfun$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }
}

