/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfig$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

@Singleton
public class AhcWSClientConfigParser
implements Provider<AhcWSClientConfig> {
    private final WSClientConfig wsClientConfig;
    private final Config configuration;

    @Inject
    public AhcWSClientConfigParser(WSClientConfig wsClientConfig, Config configuration, ClassLoader classLoader) {
        this.wsClientConfig = wsClientConfig;
        this.configuration = configuration;
    }

    public AhcWSClientConfig get() {
        return this.parse();
    }

    public AhcWSClientConfig parse() {
        int maximumConnectionsPerHost = this.configuration.getInt("play.ws.ahc.maxConnectionsPerHost");
        int maximumConnectionsTotal = this.configuration.getInt("play.ws.ahc.maxConnectionsTotal");
        Duration maxConnectionLifetime = this.getDuration$1("play.ws.ahc.maxConnectionLifetime", (Duration)Duration$.MODULE$.Inf());
        Duration idleConnectionInPoolTimeout = this.getDuration$1("play.ws.ahc.idleConnectionInPoolTimeout", (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute());
        Duration connectionPoolCleanerPeriod = this.getDuration$1("play.ws.ahc.connectionPoolCleanerPeriod", (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        int maximumNumberOfRedirects = this.configuration.getInt("play.ws.ahc.maxNumberOfRedirects");
        int maxRequestRetry = this.configuration.getInt("play.ws.ahc.maxRequestRetry");
        boolean disableUrlEncoding = this.configuration.getBoolean("play.ws.ahc.disableUrlEncoding");
        boolean keepAlive = this.configuration.getBoolean("play.ws.ahc.keepAlive");
        boolean useLaxCookieEncoder = this.configuration.getBoolean("play.ws.ahc.useLaxCookieEncoder");
        boolean useCookieStore = this.configuration.getBoolean("play.ws.ahc.useCookieStore");
        return AhcWSClientConfig$.MODULE$.apply(this.wsClientConfig, maximumConnectionsPerHost, maximumConnectionsTotal, maxConnectionLifetime, idleConnectionInPoolTimeout, connectionPoolCleanerPeriod, maximumNumberOfRedirects, maxRequestRetry, disableUrlEncoding, keepAlive, useLaxCookieEncoder, useCookieStore);
    }

    private final Duration getDuration$1(String key, Duration duration) {
        Duration duration2;
        try {
            duration2 = Duration$.MODULE$.apply(this.configuration.getString(key));
        }
        catch (ConfigException.Null e) {
            duration2 = duration;
        }
        return duration2;
    }
}

