/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc.cache;

import java.io.IOException;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.function.Predicate;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.ResponseSelectionAction;
import org.playframework.cachecontrol.ResponseSelectionActions;
import org.playframework.cachecontrol.ResponseServeAction;
import org.playframework.cachecontrol.ResponseServeActions;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.StoredResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.ahc.AhcUtilities;
import play.api.libs.ws.ahc.cache.AhcHttpCache;
import play.api.libs.ws.ahc.cache.AsyncCacheableConnection;
import play.api.libs.ws.ahc.cache.AsyncCachingHandler;
import play.api.libs.ws.ahc.cache.BackgroundAsyncHandler;
import play.api.libs.ws.ahc.cache.CacheFuture;
import play.api.libs.ws.ahc.cache.CacheableResponse;
import play.api.libs.ws.ahc.cache.Debug;
import play.api.libs.ws.ahc.cache.EffectiveURIKey;
import play.api.libs.ws.ahc.cache.EffectiveURIKey$;
import play.api.libs.ws.ahc.cache.ResponseEntry;
import play.api.libs.ws.ahc.cache.TimeoutResponse;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncCompletionHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.BoundRequestBuilder;
import play.shaded.ahc.org.asynchttpclient.ClientStats;
import play.shaded.ahc.org.asynchttpclient.ListenableFuture;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.RequestBuilder;
import play.shaded.ahc.org.asynchttpclient.Response;
import play.shaded.ahc.org.asynchttpclient.SignatureCalculator;
import play.shaded.ahc.org.asynchttpclient.handler.StreamedAsyncHandler;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

public class CachingAsyncHttpClient
implements AsyncHttpClient,
TimeoutResponse,
AhcUtilities,
Debug {
    private final AsyncHttpClient underlying;
    private final AhcHttpCache ahcHttpCache;
    private final Logger logger;
    private final FiniteDuration cacheTimeout;

    public CachingAsyncHttpClient(AsyncHttpClient underlying, AhcHttpCache ahcHttpCache) {
        this.underlying = underlying;
        this.ahcHttpCache = ahcHttpCache;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.cacheTimeout = Duration$.MODULE$.apply(1L, "second");
    }

    public void close() {
        this.underlying.close();
    }

    public <T> ListenableFuture<T> executeRequest(Request request, AsyncHandler<T> handler) throws IOException {
        AsyncHandler<T> asyncHandler = handler;
        if (asyncHandler instanceof AsyncCompletionHandler) {
            AsyncCompletionHandler asyncCompletionHandler = (AsyncCompletionHandler)asyncHandler;
            return this.execute(request, asyncCompletionHandler, null, this.ahcHttpCache.executionContext());
        }
        if (asyncHandler instanceof StreamedAsyncHandler) {
            StreamedAsyncHandler streamedHandler = (StreamedAsyncHandler)asyncHandler;
            return this.underlying.executeRequest(request, (AsyncHandler)streamedHandler);
        }
        AsyncHandler<T> other = asyncHandler;
        throw new IllegalStateException("Unknown handler type " + other.getClass().getName());
    }

    public <T> ListenableFuture<T> execute(Request request, AsyncCompletionHandler<T> handler, ListenableFuture<?> future, ExecutionContext ec) throws IOException {
        ResponseSelectionAction responseSelectionAction;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("execute: request = " + this.debug(request) + ", handler = " + this.debug((AsyncHandler)handler) + ", future = " + future);
        }
        EffectiveURIKey key = EffectiveURIKey$.MODULE$.apply(request);
        ZonedDateTime requestTime = HttpDate$.MODULE$.now();
        List entryResults = ((Option)Await$.MODULE$.result(this.ahcHttpCache.get(key), (Duration)this.cacheTimeout)).toList();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("execute " + key + ": results = " + entryResults);
        }
        if ((responseSelectionAction = this.ahcHttpCache.selectionAction(request, (Seq<ResponseEntry>)entryResults)) instanceof ResponseSelectionActions.SelectedResponse) {
            int n;
            ResponseSelectionActions.SelectedResponse selectedResponse = ResponseSelectionActions.SelectedResponse$.MODULE$.unapply((ResponseSelectionActions.SelectedResponse)responseSelectionAction);
            StoredResponse storedResponse = selectedResponse._1();
            int index = n = selectedResponse._2();
            ResponseEntry entry = (ResponseEntry)entryResults.apply(index);
            this.logger.debug("execute " + key + ": selected from cache: " + entry);
            return this.serveResponse(handler, request, entry, requestTime, ec);
        }
        if (responseSelectionAction instanceof ResponseSelectionActions.GatewayTimeout) {
            String string;
            ResponseSelectionActions.GatewayTimeout gatewayTimeout = ResponseSelectionActions.GatewayTimeout$.MODULE$.unapply((ResponseSelectionActions.GatewayTimeout)responseSelectionAction);
            String reason = string = gatewayTimeout._1();
            this.logger.debug("execute " + key + ": " + reason + " -- timing out ");
            return this.serveTimeout(request, (AsyncHandler<T>)handler, ec);
        }
        if (responseSelectionAction instanceof ResponseSelectionActions.ForwardToOrigin) {
            String string;
            ResponseSelectionActions.ForwardToOrigin forwardToOrigin = ResponseSelectionActions.ForwardToOrigin$.MODULE$.unapply((ResponseSelectionActions.ForwardToOrigin)responseSelectionAction);
            String reason = string = forwardToOrigin._1();
            this.logger.debug("execute " + key + ": " + reason + " -- forwarding to origin server");
            return this.underlying.executeRequest(request, this.cacheAsyncHandler(request, handler, this.cacheAsyncHandler$default$3()));
        }
        throw new MatchError((Object)responseSelectionAction);
    }

    public <T> ListenableFuture<T> serveResponse(AsyncCompletionHandler<T> handler, Request request, ResponseEntry entry, ZonedDateTime requestTime, ExecutionContext ec) {
        EffectiveURIKey key = EffectiveURIKey$.MODULE$.apply(request);
        Seconds currentAge = this.ahcHttpCache.calculateCurrentAge(request, entry, requestTime);
        ResponseServeAction responseServeAction = this.ahcHttpCache.serveAction(request, entry, currentAge);
        if (responseServeAction instanceof ResponseServeActions.ServeFresh) {
            String string;
            ResponseServeActions.ServeFresh serveFresh = ResponseServeActions.ServeFresh$.MODULE$.unapply((ResponseServeActions.ServeFresh)responseServeAction);
            String reason = string = serveFresh._1();
            this.logger.debug("serveResponse " + key + ": " + reason + " -- serving fresh response");
            CacheableResponse freshResponse = this.ahcHttpCache.generateCachedResponse(request, entry, currentAge, true);
            return this.executeFromCache((AsyncHandler<T>)handler, request, freshResponse, ec);
        }
        if (responseServeAction instanceof ResponseServeActions.ServeStale) {
            String string;
            ResponseServeActions.ServeStale serveStale = ResponseServeActions.ServeStale$.MODULE$.unapply((ResponseServeActions.ServeStale)responseServeAction);
            String reason = string = serveStale._1();
            this.logger.debug("serveResponse " + key + ": " + reason + " -- serving stale response found for " + key);
            CacheableResponse staleResponse = this.ahcHttpCache.generateCachedResponse(request, entry, currentAge, false);
            return this.executeFromCache((AsyncHandler<T>)handler, request, staleResponse, ec);
        }
        if (responseServeAction instanceof ResponseServeActions.ServeStaleAndValidate) {
            String string;
            ResponseServeActions.ServeStaleAndValidate serveStaleAndValidate = ResponseServeActions.ServeStaleAndValidate$.MODULE$.unapply((ResponseServeActions.ServeStaleAndValidate)responseServeAction);
            String reason = string = serveStaleAndValidate._1();
            this.logger.debug("serveResponse " + key + ": " + reason + " - serving stale response and revalidating for " + key);
            CacheableResponse response = entry.response();
            Request validationRequest = this.buildValidationRequest(request, response);
            this.underlying.executeRequest(validationRequest, this.backgroundAsyncHandler(validationRequest));
            CacheableResponse staleResponse = this.ahcHttpCache.generateCachedResponse(request, entry, currentAge, false);
            return this.executeFromCache((AsyncHandler<T>)handler, request, staleResponse, ec);
        }
        if (responseServeAction instanceof ResponseServeActions.Validate) {
            ResponseServeActions.Validate validate = (ResponseServeActions.Validate)responseServeAction;
            ResponseServeActions.Validate validate2 = ResponseServeActions.Validate$.MODULE$.unapply(validate);
            String string = validate2._1();
            boolean bl = validate2._2();
            String reason = string;
            boolean staleIfError = bl;
            ResponseServeActions.Validate action = validate;
            this.logger.debug("serveResponse " + key + ": " + reason + " -- revalidate with staleIfError = " + staleIfError);
            CacheableResponse response = entry.response();
            Request validationRequest = this.buildValidationRequest(request, response);
            return this.underlying.executeRequest(validationRequest, this.cacheAsyncHandler(validationRequest, handler, (Option<ResponseServeAction>)Some$.MODULE$.apply((Object)action)));
        }
        if (responseServeAction instanceof ResponseServeActions.ValidateOrTimeout) {
            String string;
            ResponseServeActions.ValidateOrTimeout validateOrTimeout = (ResponseServeActions.ValidateOrTimeout)responseServeAction;
            ResponseServeActions.ValidateOrTimeout validateOrTimeout2 = ResponseServeActions.ValidateOrTimeout$.MODULE$.unapply(validateOrTimeout);
            String reason = string = validateOrTimeout2._1();
            ResponseServeActions.ValidateOrTimeout action = validateOrTimeout;
            this.logger.debug("serveResponse: " + reason + " -- must revalidate and timeout on disconnect");
            CacheableResponse response = entry.response();
            Request validationRequest = this.buildValidationRequest(request, response);
            return this.underlying.executeRequest(validationRequest, this.cacheAsyncHandler(request, handler, (Option<ResponseServeAction>)Some$.MODULE$.apply((Object)action)));
        }
        throw new MatchError((Object)responseServeAction);
    }

    public <T> CacheFuture<T> executeFromCache(AsyncHandler<T> handler, Request request, CacheableResponse response, ExecutionContext ec) {
        this.logger.trace("executeFromCache: handler = " + this.debug((AsyncHandler)handler) + ", request = " + this.debug(request) + ", response = " + this.debug(response));
        CacheFuture<T> cacheFuture = new CacheFuture<T>(handler);
        ec.execute(new Runnable(handler, request, response, cacheFuture){
            private final AsyncHandler handler$1;
            private final Request request$1;
            private final CacheableResponse response$1;
            private final CacheFuture cacheFuture$1;
            {
                this.handler$1 = handler$2;
                this.request$1 = request$2;
                this.response$1 = response$3;
                this.cacheFuture$1 = cacheFuture$2;
            }

            public void run() {
                new AsyncCacheableConnection<T>(this.handler$1, this.request$1, this.response$1, this.cacheFuture$1).call();
            }
        });
        return cacheFuture;
    }

    public Request buildValidationRequest(Request request, CacheableResponse response) {
        this.logger.trace("buildValidationRequest: " + this.debug(request) + ", response = " + this.debug(response));
        return this.composeRequest(request, (Function1<RequestBuilder, RequestBuilder>)(Function1 & Serializable)rb -> {
            HttpHeaders headers = response.getHeaders();
            Option$.MODULE$.apply((Object)headers.get("Last-Modified")).map((Function1 & Serializable)lastModifiedDate -> (RequestBuilder)rb.addHeader((CharSequence)"If-Modified-Since", lastModifiedDate));
            Option$.MODULE$.apply((Object)headers.get("ETag")).map((Function1 & Serializable)eTag -> (RequestBuilder)rb.addHeader((CharSequence)"If-None-Match", eTag));
            return rb;
        });
    }

    public Request composeRequest(Request request, Function1<RequestBuilder, RequestBuilder> block) {
        RequestBuilder rb = request.toBuilder();
        RequestBuilder builder = (RequestBuilder)block.apply((Object)rb);
        return builder.build();
    }

    public <T> BackgroundAsyncHandler<T> backgroundAsyncHandler(Request request) {
        return new BackgroundAsyncHandler(request, this.ahcHttpCache, this.underlying.getConfig());
    }

    public <T> CacheFuture<T> serveTimeout(Request request, AsyncHandler<T> handler, ExecutionContext ec) {
        CacheableResponse timeoutResponse = this.generateTimeoutResponse(request, this.underlying.getConfig());
        return this.executeFromCache(handler, request, timeoutResponse, ec);
    }

    public <T> AsyncCachingHandler<T> cacheAsyncHandler(Request request, AsyncCompletionHandler<T> handler, Option<ResponseServeAction> action) {
        return new AsyncCachingHandler<T>(request, handler, this.ahcHttpCache, action, this.underlying.getConfig());
    }

    public <T> Option<ResponseServeAction> cacheAsyncHandler$default$3() {
        return None$.MODULE$;
    }

    public BoundRequestBuilder prepareGet(String s) {
        return this.underlying.prepareGet(s);
    }

    public BoundRequestBuilder preparePost(String s) {
        return this.underlying.preparePost(s);
    }

    public BoundRequestBuilder preparePut(String s) {
        return this.underlying.preparePut(s);
    }

    public BoundRequestBuilder prepareOptions(String s) {
        return this.underlying.prepareOptions(s);
    }

    public AsyncHttpClient setSignatureCalculator(SignatureCalculator signatureCalculator) {
        return this.underlying.setSignatureCalculator(signatureCalculator);
    }

    public BoundRequestBuilder prepareHead(String s) {
        return this.underlying.prepareHead(s);
    }

    public BoundRequestBuilder prepareConnect(String s) {
        return this.underlying.prepareConnect(s);
    }

    public BoundRequestBuilder prepareTrace(String s) {
        return this.underlying.prepareTrace(s);
    }

    public BoundRequestBuilder prepareRequest(Request request) {
        return this.underlying.prepareRequest(request);
    }

    public BoundRequestBuilder prepareRequest(RequestBuilder requestBuilder) {
        return this.underlying.prepareRequest(requestBuilder);
    }

    public BoundRequestBuilder prepareDelete(String s) {
        return this.underlying.prepareDelete(s);
    }

    public BoundRequestBuilder preparePatch(String s) {
        return this.underlying.preparePatch(s);
    }

    public boolean isClosed() {
        return this.underlying.isClosed();
    }

    public <T> ListenableFuture<T> executeRequest(RequestBuilder requestBuilder, AsyncHandler<T> asyncHandler) {
        return this.executeRequest(requestBuilder.build(), asyncHandler);
    }

    public ListenableFuture<Response> executeRequest(Request request) {
        return this.underlying.executeRequest(request);
    }

    public ListenableFuture<Response> executeRequest(RequestBuilder requestBuilder) {
        return this.underlying.executeRequest(requestBuilder);
    }

    public BoundRequestBuilder prepare(String method, String url) {
        return this.underlying.prepare(method, url);
    }

    public ClientStats getClientStats() {
        return this.underlying.getClientStats();
    }

    public void flushChannelPoolPartitions(Predicate<Object> predicate) {
        this.underlying.flushChannelPoolPartitions(predicate);
    }

    public AsyncHttpClientConfig getConfig() {
        return this.underlying.getConfig();
    }
}

