/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import org.reactivestreams.Publisher;
import play.api.libs.ws.BodyWritable;
import play.api.libs.ws.EmptyBody$;
import play.api.libs.ws.InMemoryBody;
import play.api.libs.ws.InMemoryBody$;
import play.api.libs.ws.SourceBody;
import play.api.libs.ws.SourceBody$;
import play.api.libs.ws.StandaloneWSRequest;
import play.api.libs.ws.StandaloneWSResponse;
import play.api.libs.ws.WSAuthScheme;
import play.api.libs.ws.WSBody;
import play.api.libs.ws.WSCookie;
import play.api.libs.ws.WSProxyServer;
import play.api.libs.ws.WSRequestExecutor;
import play.api.libs.ws.WSRequestExecutor$;
import play.api.libs.ws.WSRequestFilter;
import play.api.libs.ws.WSSignatureCalculator;
import play.api.libs.ws.ahc.AhcUtilities;
import play.api.libs.ws.ahc.CaseInsensitiveOrdered$;
import play.api.libs.ws.ahc.FormUrlEncodedParser$;
import play.api.libs.ws.ahc.StandaloneAhcWSClient;
import play.api.libs.ws.ahc.StandaloneAhcWSRequest$;
import play.api.libs.ws.ahc.WSCookieConverter;
import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.Param;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.RequestBuilder;
import play.shaded.ahc.org.asynchttpclient.SignatureCalculator;
import play.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import play.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class StandaloneAhcWSRequest
implements StandaloneWSRequest,
AhcUtilities,
WSCookieConverter,
Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StandaloneAhcWSRequest.class.getDeclaredField("uri$lzy1"));
    private final StandaloneAhcWSClient client;
    private final String url;
    private final String method;
    private final WSBody body;
    private final Map headers;
    private final Map queryString;
    private final scala.collection.immutable.Seq cookies;
    private final Option calc;
    private final Option auth;
    private final Option followRedirects;
    private final Option requestTimeout;
    private final Option virtualHost;
    private final Option proxyServer;
    private final Option disableUrlEncoding;
    private final scala.collection.immutable.Seq filters;
    private final Materializer materializer;
    private volatile Object uri$lzy1;
    private final Function1<StandaloneAhcWSRequest, Future<StandaloneWSResponse>> executor;

    public static StandaloneAhcWSRequest apply(StandaloneAhcWSClient standaloneAhcWSClient, String string, String string2, WSBody wSBody, Map<String, scala.collection.immutable.Seq<String>> map, Map<String, scala.collection.immutable.Seq<String>> map2, scala.collection.immutable.Seq<WSCookie> seq, Option<WSSignatureCalculator> option, Option<Tuple3<String, String, WSAuthScheme>> option2, Option<Object> option3, Option<Duration> option4, Option<String> option5, Option<WSProxyServer> option6, Option<Object> option7, scala.collection.immutable.Seq<WSRequestFilter> seq2, Materializer materializer) {
        return StandaloneAhcWSRequest$.MODULE$.apply(standaloneAhcWSClient, string, string2, wSBody, map, map2, seq, option, option2, option3, option4, option5, option6, option7, seq2, materializer);
    }

    public static StandaloneAhcWSRequest unapply(StandaloneAhcWSRequest standaloneAhcWSRequest) {
        return StandaloneAhcWSRequest$.MODULE$.unapply(standaloneAhcWSRequest);
    }

    public static String $lessinit$greater$default$3() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$3();
    }

    public static WSBody $lessinit$greater$default$4() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$4();
    }

    public static Map<String, scala.collection.immutable.Seq<String>> $lessinit$greater$default$5() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$5();
    }

    public static Map<String, scala.collection.immutable.Seq<String>> $lessinit$greater$default$6() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$6();
    }

    public static scala.collection.immutable.Seq<WSCookie> $lessinit$greater$default$7() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<WSSignatureCalculator> $lessinit$greater$default$8() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Tuple3<String, String, WSAuthScheme>> $lessinit$greater$default$9() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<Object> $lessinit$greater$default$10() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$10();
    }

    public static Option<Duration> $lessinit$greater$default$11() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<String> $lessinit$greater$default$12() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$12();
    }

    public static Option<WSProxyServer> $lessinit$greater$default$13() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$13();
    }

    public static Option<Object> $lessinit$greater$default$14() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$14();
    }

    public static scala.collection.immutable.Seq<WSRequestFilter> $lessinit$greater$default$15() {
        return StandaloneAhcWSRequest$.MODULE$.$lessinit$greater$default$15();
    }

    public StandaloneAhcWSRequest(StandaloneAhcWSClient client, String url, String method, WSBody body, Map<String, scala.collection.immutable.Seq<String>> headers, Map<String, scala.collection.immutable.Seq<String>> queryString, scala.collection.immutable.Seq<WSCookie> cookies, Option<WSSignatureCalculator> calc, Option<Tuple3<String, String, WSAuthScheme>> auth, Option<Object> followRedirects, Option<Duration> requestTimeout, Option<String> virtualHost, Option<WSProxyServer> proxyServer, Option<Object> disableUrlEncoding, scala.collection.immutable.Seq<WSRequestFilter> filters, Materializer materializer) {
        this.client = client;
        this.url = url;
        this.method = method;
        this.body = body;
        this.headers = headers;
        this.queryString = queryString;
        this.cookies = cookies;
        this.calc = calc;
        this.auth = auth;
        this.followRedirects = followRedirects;
        this.requestTimeout = requestTimeout;
        this.virtualHost = virtualHost;
        this.proxyServer = proxyServer;
        this.disableUrlEncoding = disableUrlEncoding;
        this.filters = filters;
        this.materializer = materializer;
        Predef$.MODULE$.require(client != null, StandaloneAhcWSRequest::$init$$$anonfun$1);
        Predef$.MODULE$.require(url != null, StandaloneAhcWSRequest::$init$$$anonfun$2);
        LazyRef lazyRef = new LazyRef();
        this.executor = (Function1 & Serializable)req -> (Future)this.executor$1(lazyRef, client).apply(req);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof StandaloneAhcWSRequest)) return false;
        StandaloneAhcWSRequest standaloneAhcWSRequest = (StandaloneAhcWSRequest)object;
        StandaloneAhcWSClient standaloneAhcWSClient = this.client();
        StandaloneAhcWSClient standaloneAhcWSClient2 = standaloneAhcWSRequest.client();
        if (standaloneAhcWSClient == null) {
            if (standaloneAhcWSClient2 != null) {
                return false;
            }
        } else if (!standaloneAhcWSClient.equals(standaloneAhcWSClient2)) return false;
        String string = this.url();
        String string2 = standaloneAhcWSRequest.url();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.method();
        String string4 = standaloneAhcWSRequest.method();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        WSBody wSBody = this.body();
        WSBody wSBody2 = standaloneAhcWSRequest.body();
        if (wSBody == null) {
            if (wSBody2 != null) {
                return false;
            }
        } else if (!wSBody.equals(wSBody2)) return false;
        Map<String, scala.collection.immutable.Seq<String>> map = this.headers();
        Map<String, scala.collection.immutable.Seq<String>> map2 = standaloneAhcWSRequest.headers();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<String, scala.collection.immutable.Seq<String>> map3 = this.queryString();
        Map<String, scala.collection.immutable.Seq<String>> map4 = standaloneAhcWSRequest.queryString();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        scala.collection.immutable.Seq<WSCookie> seq = this.cookies();
        scala.collection.immutable.Seq<WSCookie> seq2 = standaloneAhcWSRequest.cookies();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<WSSignatureCalculator> option = this.calc();
        Option<WSSignatureCalculator> option2 = standaloneAhcWSRequest.calc();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Tuple3<String, String, WSAuthScheme>> option3 = this.auth();
        Option<Tuple3<String, String, WSAuthScheme>> option4 = standaloneAhcWSRequest.auth();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.followRedirects();
        Option<Object> option6 = standaloneAhcWSRequest.followRedirects();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<Duration> option7 = this.requestTimeout();
        Option<Duration> option8 = standaloneAhcWSRequest.requestTimeout();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        Option<String> option9 = this.virtualHost();
        Option<String> option10 = standaloneAhcWSRequest.virtualHost();
        if (option9 == null) {
            if (option10 != null) {
                return false;
            }
        } else if (!option9.equals(option10)) return false;
        Option<WSProxyServer> option11 = this.proxyServer();
        Option<WSProxyServer> option12 = standaloneAhcWSRequest.proxyServer();
        if (option11 == null) {
            if (option12 != null) {
                return false;
            }
        } else if (!option11.equals(option12)) return false;
        Option<Object> option13 = this.disableUrlEncoding();
        Option<Object> option14 = standaloneAhcWSRequest.disableUrlEncoding();
        if (option13 == null) {
            if (option14 != null) {
                return false;
            }
        } else if (!option13.equals(option14)) return false;
        scala.collection.immutable.Seq<WSRequestFilter> seq3 = this.filters();
        scala.collection.immutable.Seq<WSRequestFilter> seq4 = standaloneAhcWSRequest.filters();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (!standaloneAhcWSRequest.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof StandaloneAhcWSRequest;
    }

    public int productArity() {
        return 15;
    }

    public String productPrefix() {
        return "StandaloneAhcWSRequest";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return this._10();
            }
            case 10: {
                return this._11();
            }
            case 11: {
                return this._12();
            }
            case 12: {
                return this._13();
            }
            case 13: {
                return this._14();
            }
            case 14: {
                return this._15();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "client";
            }
            case 1: {
                return "url";
            }
            case 2: {
                return "method";
            }
            case 3: {
                return "body";
            }
            case 4: {
                return "headers";
            }
            case 5: {
                return "queryString";
            }
            case 6: {
                return "cookies";
            }
            case 7: {
                return "calc";
            }
            case 8: {
                return "auth";
            }
            case 9: {
                return "followRedirects";
            }
            case 10: {
                return "requestTimeout";
            }
            case 11: {
                return "virtualHost";
            }
            case 12: {
                return "proxyServer";
            }
            case 13: {
                return "disableUrlEncoding";
            }
            case 14: {
                return "filters";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public StandaloneAhcWSClient client() {
        return this.client;
    }

    public String url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public WSBody body() {
        return this.body;
    }

    public Map<String, scala.collection.immutable.Seq<String>> headers() {
        return this.headers;
    }

    public Map<String, scala.collection.immutable.Seq<String>> queryString() {
        return this.queryString;
    }

    public scala.collection.immutable.Seq<WSCookie> cookies() {
        return this.cookies;
    }

    public Option<WSSignatureCalculator> calc() {
        return this.calc;
    }

    public Option<Tuple3<String, String, WSAuthScheme>> auth() {
        return this.auth;
    }

    public Option<Object> followRedirects() {
        return this.followRedirects;
    }

    public Option<Duration> requestTimeout() {
        return this.requestTimeout;
    }

    public Option<String> virtualHost() {
        return this.virtualHost;
    }

    public Option<WSProxyServer> proxyServer() {
        return this.proxyServer;
    }

    public Option<Object> disableUrlEncoding() {
        return this.disableUrlEncoding;
    }

    private scala.collection.immutable.Seq<WSRequestFilter> filters() {
        return this.filters;
    }

    public Option<String> contentType() {
        return this.headers().get((Object)"Content-Type").map((Function1 & Serializable)_$1 -> (String)_$1.head());
    }

    public URI uri() {
        Object object = this.uri$lzy1;
        if (object instanceof URI) {
            return (URI)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (URI)this.uri$lzyINIT1();
    }

    private Object uri$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.uri$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    URI uRI = null;
                    try {
                        Object object3;
                        Function1 & Serializable enc = (Function1 & Serializable)p -> URLEncoder.encode(p, "utf-8");
                        if (this.queryString().isEmpty()) {
                            object3 = this.url();
                        } else {
                            String qs = ((IterableOnceOps)this.queryString().withFilter((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    String n = (String)tuple2._1();
                                    scala.collection.immutable.Seq vs = (scala.collection.immutable.Seq)tuple2._2();
                                    return true;
                                }
                                return false;
                            }).flatMap((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    String n = (String)tuple2._1();
                                    scala.collection.immutable.Seq vs = (scala.collection.immutable.Seq)tuple2._2();
                                    return (scala.collection.immutable.Seq)vs.map((Function1 & Serializable)v -> enc.apply((Object)n) + "=" + enc.apply(v));
                                }
                                throw new MatchError((Object)tuple2);
                            })).mkString("&");
                            object3 = this.url() + "?" + qs;
                        }
                        uRI = new URI((String)object3);
                        object2 = uRI == null ? LazyVals.NullValue$.MODULE$ : uRI;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.uri$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uRI;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public StandaloneAhcWSRequest sign(WSSignatureCalculator calc) {
        Some some = Some$.MODULE$.apply((Object)calc);
        StandaloneAhcWSClient standaloneAhcWSClient = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        WSBody wSBody = this.copy$default$4();
        Map<String, scala.collection.immutable.Seq<String>> map = this.copy$default$5();
        Map<String, scala.collection.immutable.Seq<String>> map2 = this.copy$default$6();
        scala.collection.immutable.Seq<WSCookie> seq = this.copy$default$7();
        Option<Tuple3<String, String, WSAuthScheme>> option = this.copy$default$9();
        Option<Object> option2 = this.copy$default$10();
        Option<Duration> option3 = this.copy$default$11();
        Option<String> option4 = this.copy$default$12();
        Option<WSProxyServer> option5 = this.copy$default$13();
        Option<Object> option6 = this.copy$default$14();
        scala.collection.immutable.Seq<WSRequestFilter> seq2 = this.copy$default$15();
        return this.copy(standaloneAhcWSClient, string, string2, wSBody, map, map2, seq, (Option<WSSignatureCalculator>)some, option, option2, option3, option4, option5, option6, seq2, this.materializer);
    }

    public StandaloneAhcWSRequest withAuth(String username, String password, WSAuthScheme scheme) {
        Some some = Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)username, (Object)password, (Object)scheme));
        StandaloneAhcWSClient standaloneAhcWSClient = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        WSBody wSBody = this.copy$default$4();
        Map<String, scala.collection.immutable.Seq<String>> map = this.copy$default$5();
        Map<String, scala.collection.immutable.Seq<String>> map2 = this.copy$default$6();
        scala.collection.immutable.Seq<WSCookie> seq = this.copy$default$7();
        Option<WSSignatureCalculator> option = this.copy$default$8();
        Option<Object> option2 = this.copy$default$10();
        Option<Duration> option3 = this.copy$default$11();
        Option<String> option4 = this.copy$default$12();
        Option<WSProxyServer> option5 = this.copy$default$13();
        Option<Object> option6 = this.copy$default$14();
        scala.collection.immutable.Seq<WSRequestFilter> seq2 = this.copy$default$15();
        return this.copy(standaloneAhcWSClient, string, string2, wSBody, map, map2, seq, option, (Option<Tuple3<String, String, WSAuthScheme>>)some, option2, option3, option4, option5, option6, seq2, this.materializer);
    }

    public StandaloneAhcWSRequest addHttpHeaders(scala.collection.immutable.Seq<Tuple2<String, String>> hdrs) {
        Map<String, scala.collection.immutable.Seq<String>> newHeaders = this.buildHeaders(this.headers(), hdrs);
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), newHeaders, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.materializer);
    }

    public StandaloneAhcWSRequest withHttpHeaders(scala.collection.immutable.Seq<Tuple2<String, String>> hdrs) {
        TreeMap emptyMap = (TreeMap)TreeMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Ordering)CaseInsensitiveOrdered$.MODULE$);
        Map<String, scala.collection.immutable.Seq<String>> newHeaders = this.buildHeaders((Map<String, scala.collection.immutable.Seq<String>>)emptyMap, hdrs);
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), newHeaders, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.materializer);
    }

    private Map<String, scala.collection.immutable.Seq<String>> buildHeaders(Map<String, scala.collection.immutable.Seq<String>> origHeaders, scala.collection.immutable.Seq<Tuple2<String, String>> hdrs) {
        Map map;
        Map newHeaders = (Map)hdrs.foldLeft(origHeaders, (Function2 & Serializable)(m, hdr) -> {
            if (m.contains(hdr._1())) {
                return (Map)m.updated(hdr._1(), ((SeqOps)m.apply(hdr._1())).$colon$plus(hdr._2()));
            }
            String string = (String)Predef$.MODULE$.ArrowAssoc(hdr._1());
            return (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)hdr._2()}))));
        });
        Option<String> option = this.contentType();
        if (option instanceof Some) {
            String ct = (String)((Some)option).value();
            map = (Map)newHeaders.updated((Object)"Content-Type", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ct})));
        } else if (None$.MODULE$.equals(option)) {
            map = newHeaders;
        } else {
            throw new MatchError(option);
        }
        newHeaders = map;
        return newHeaders;
    }

    public StandaloneAhcWSRequest addQueryStringParameters(scala.collection.immutable.Seq<Tuple2<String, String>> parameters) {
        Map<String, scala.collection.immutable.Seq<String>> newQueryString = this.buildQueryParams(this.queryString(), parameters);
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), newQueryString, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.materializer);
    }

    public StandaloneAhcWSRequest withQueryStringParameters(scala.collection.immutable.Seq<Tuple2<String, String>> parameters) {
        Map<String, scala.collection.immutable.Seq<String>> newQueryString = this.buildQueryParams((Map<String, scala.collection.immutable.Seq<String>>)Predef$.MODULE$.Map().empty(), parameters);
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), newQueryString, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.materializer);
    }

    private Map<String, scala.collection.immutable.Seq<String>> buildQueryParams(Map<String, scala.collection.immutable.Seq<String>> orig, scala.collection.immutable.Seq<Tuple2<String, String>> params) {
        return (Map)params.foldLeft(orig, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Map m = (Map)tuple2._1();
                if (tuple22 != null) {
                    String k = (String)tuple22._1();
                    String v = (String)tuple22._2();
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, ((SeqOps)m.getOrElse((Object)k, StandaloneAhcWSRequest::buildQueryParams$$anonfun$1$$anonfun$1)).$plus$colon((Object)v)));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public StandaloneAhcWSRequest withCookies(scala.collection.immutable.Seq<WSCookie> cookies) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), cookies, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.materializer);
    }

    public StandaloneAhcWSRequest withFollowRedirects(boolean follow) {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)follow));
        StandaloneAhcWSClient standaloneAhcWSClient = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        WSBody wSBody = this.copy$default$4();
        Map<String, scala.collection.immutable.Seq<String>> map = this.copy$default$5();
        Map<String, scala.collection.immutable.Seq<String>> map2 = this.copy$default$6();
        scala.collection.immutable.Seq<WSCookie> seq = this.copy$default$7();
        Option<WSSignatureCalculator> option = this.copy$default$8();
        Option<Tuple3<String, String, WSAuthScheme>> option2 = this.copy$default$9();
        Option<Duration> option3 = this.copy$default$11();
        Option<String> option4 = this.copy$default$12();
        Option<WSProxyServer> option5 = this.copy$default$13();
        Option<Object> option6 = this.copy$default$14();
        scala.collection.immutable.Seq<WSRequestFilter> seq2 = this.copy$default$15();
        return this.copy(standaloneAhcWSClient, string, string2, wSBody, map, map2, seq, option, option2, (Option<Object>)some, option3, option4, option5, option6, seq2, this.materializer);
    }

    public StandaloneAhcWSRequest withDisableUrlEncoding(boolean disableUrlEncoding) {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)disableUrlEncoding));
        StandaloneAhcWSClient standaloneAhcWSClient = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        WSBody wSBody = this.copy$default$4();
        Map<String, scala.collection.immutable.Seq<String>> map = this.copy$default$5();
        Map<String, scala.collection.immutable.Seq<String>> map2 = this.copy$default$6();
        scala.collection.immutable.Seq<WSCookie> seq = this.copy$default$7();
        Option<WSSignatureCalculator> option = this.copy$default$8();
        Option<Tuple3<String, String, WSAuthScheme>> option2 = this.copy$default$9();
        Option<Object> option3 = this.copy$default$10();
        Option<Duration> option4 = this.copy$default$11();
        Option<String> option5 = this.copy$default$12();
        Option<WSProxyServer> option6 = this.copy$default$13();
        scala.collection.immutable.Seq<WSRequestFilter> seq2 = this.copy$default$15();
        return this.copy(standaloneAhcWSClient, string, string2, wSBody, map, map2, seq, option, option2, option3, option4, option5, option6, (Option<Object>)some, seq2, this.materializer);
    }

    public StandaloneAhcWSRequest withRequestTimeout(Duration timeout) {
        Duration duration = timeout;
        Duration.Infinite infinite = Duration$.MODULE$.Inf();
        Duration duration2 = duration;
        if (!(infinite != null ? !infinite.equals(duration2) : duration2 != null)) {
            Some some = Some$.MODULE$.apply((Object)timeout);
            StandaloneAhcWSClient standaloneAhcWSClient = this.copy$default$1();
            String string = this.copy$default$2();
            String string2 = this.copy$default$3();
            WSBody wSBody = this.copy$default$4();
            Map<String, scala.collection.immutable.Seq<String>> map = this.copy$default$5();
            Map<String, scala.collection.immutable.Seq<String>> map2 = this.copy$default$6();
            scala.collection.immutable.Seq<WSCookie> seq = this.copy$default$7();
            Option<WSSignatureCalculator> option = this.copy$default$8();
            Option<Tuple3<String, String, WSAuthScheme>> option2 = this.copy$default$9();
            Option<Object> option3 = this.copy$default$10();
            Option<String> option4 = this.copy$default$12();
            Option<WSProxyServer> option5 = this.copy$default$13();
            Option<Object> option6 = this.copy$default$14();
            scala.collection.immutable.Seq<WSRequestFilter> seq2 = this.copy$default$15();
            return this.copy(standaloneAhcWSClient, string, string2, wSBody, map, map2, seq, option, option2, option3, (Option<Duration>)some, option4, option5, option6, seq2, this.materializer);
        }
        Duration d = duration;
        long millis = d.toMillis();
        Predef$.MODULE$.require(millis >= 0L && millis <= Integer.MAX_VALUE, StandaloneAhcWSRequest::withRequestTimeout$$anonfun$1);
        Some some = Some$.MODULE$.apply((Object)timeout);
        StandaloneAhcWSClient standaloneAhcWSClient = this.copy$default$1();
        String string = this.copy$default$2();
        String string3 = this.copy$default$3();
        WSBody wSBody = this.copy$default$4();
        Map<String, scala.collection.immutable.Seq<String>> map = this.copy$default$5();
        Map<String, scala.collection.immutable.Seq<String>> map3 = this.copy$default$6();
        scala.collection.immutable.Seq<WSCookie> seq = this.copy$default$7();
        Option<WSSignatureCalculator> option = this.copy$default$8();
        Option<Tuple3<String, String, WSAuthScheme>> option7 = this.copy$default$9();
        Option<Object> option8 = this.copy$default$10();
        Option<String> option9 = this.copy$default$12();
        Option<WSProxyServer> option10 = this.copy$default$13();
        Option<Object> option11 = this.copy$default$14();
        scala.collection.immutable.Seq<WSRequestFilter> seq3 = this.copy$default$15();
        return this.copy(standaloneAhcWSClient, string, string3, wSBody, map, map3, seq, option, option7, option8, (Option<Duration>)some, option9, option10, option11, seq3, this.materializer);
    }

    public StandaloneAhcWSRequest withRequestFilter(WSRequestFilter filter) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.filters().$colon$plus((Object)filter);
        StandaloneAhcWSClient standaloneAhcWSClient = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        WSBody wSBody = this.copy$default$4();
        Map<String, scala.collection.immutable.Seq<String>> map = this.copy$default$5();
        Map<String, scala.collection.immutable.Seq<String>> map2 = this.copy$default$6();
        scala.collection.immutable.Seq<WSCookie> seq2 = this.copy$default$7();
        Option<WSSignatureCalculator> option = this.copy$default$8();
        Option<Tuple3<String, String, WSAuthScheme>> option2 = this.copy$default$9();
        Option<Object> option3 = this.copy$default$10();
        Option<Duration> option4 = this.copy$default$11();
        Option<String> option5 = this.copy$default$12();
        Option<WSProxyServer> option6 = this.copy$default$13();
        Option<Object> option7 = this.copy$default$14();
        return this.copy(standaloneAhcWSClient, string, string2, wSBody, map, map2, seq2, option, option2, option3, option4, option5, option6, option7, (scala.collection.immutable.Seq<WSRequestFilter>)seq, this.materializer);
    }

    public StandaloneAhcWSRequest withVirtualHost(String vh) {
        Some some = Some$.MODULE$.apply((Object)vh);
        StandaloneAhcWSClient standaloneAhcWSClient = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        WSBody wSBody = this.copy$default$4();
        Map<String, scala.collection.immutable.Seq<String>> map = this.copy$default$5();
        Map<String, scala.collection.immutable.Seq<String>> map2 = this.copy$default$6();
        scala.collection.immutable.Seq<WSCookie> seq = this.copy$default$7();
        Option<WSSignatureCalculator> option = this.copy$default$8();
        Option<Tuple3<String, String, WSAuthScheme>> option2 = this.copy$default$9();
        Option<Object> option3 = this.copy$default$10();
        Option<Duration> option4 = this.copy$default$11();
        Option<WSProxyServer> option5 = this.copy$default$13();
        Option<Object> option6 = this.copy$default$14();
        scala.collection.immutable.Seq<WSRequestFilter> seq2 = this.copy$default$15();
        return this.copy(standaloneAhcWSClient, string, string2, wSBody, map, map2, seq, option, option2, option3, option4, (Option<String>)some, option5, option6, seq2, this.materializer);
    }

    public StandaloneAhcWSRequest withProxyServer(WSProxyServer proxyServer) {
        Some some = Some$.MODULE$.apply((Object)proxyServer);
        StandaloneAhcWSClient standaloneAhcWSClient = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        WSBody wSBody = this.copy$default$4();
        Map<String, scala.collection.immutable.Seq<String>> map = this.copy$default$5();
        Map<String, scala.collection.immutable.Seq<String>> map2 = this.copy$default$6();
        scala.collection.immutable.Seq<WSCookie> seq = this.copy$default$7();
        Option<WSSignatureCalculator> option = this.copy$default$8();
        Option<Tuple3<String, String, WSAuthScheme>> option2 = this.copy$default$9();
        Option<Object> option3 = this.copy$default$10();
        Option<Duration> option4 = this.copy$default$11();
        Option<String> option5 = this.copy$default$12();
        Option<Object> option6 = this.copy$default$14();
        scala.collection.immutable.Seq<WSRequestFilter> seq2 = this.copy$default$15();
        return this.copy(standaloneAhcWSClient, string, string2, wSBody, map, map2, seq, option, option2, option3, option4, option5, (Option<WSProxyServer>)some, option6, seq2, this.materializer);
    }

    public Future<StandaloneWSResponse> get() {
        return this.execute("GET");
    }

    public <T> Future<StandaloneWSResponse> patch(T body, BodyWritable<T> evidence$1) {
        return this.withBody((Object)body, (BodyWritable)evidence$1).execute("PATCH");
    }

    public <T> Future<StandaloneWSResponse> post(T body, BodyWritable<T> evidence$1) {
        return this.withBody((Object)body, (BodyWritable)evidence$1).execute("POST");
    }

    public <T> Future<StandaloneWSResponse> put(T body, BodyWritable<T> evidence$1) {
        return this.withBody((Object)body, (BodyWritable)evidence$1).execute("PUT");
    }

    public <T> StandaloneAhcWSRequest withBody(T body, BodyWritable<T> evidence$1) {
        BodyWritable writable = (BodyWritable)Predef$.MODULE$.implicitly(evidence$1);
        return this.withBodyAndContentType((WSBody)writable.transform().apply(body), writable.contentType());
    }

    private StandaloneAhcWSRequest withBodyAndContentType(WSBody wsBody, String contentType) {
        if (this.headers().contains((Object)"Content-Type")) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), wsBody, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.materializer);
        }
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Content-Type");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)contentType);
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), wsBody, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.materializer).addHttpHeaders((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Future<StandaloneWSResponse> delete() {
        return this.execute("DELETE");
    }

    public Future<StandaloneWSResponse> head() {
        return this.execute("HEAD");
    }

    public Future<StandaloneWSResponse> options() {
        return this.execute("OPTIONS");
    }

    public Future<StandaloneWSResponse> execute(String method) {
        return this.withMethod(method).execute();
    }

    public StandaloneAhcWSRequest withUrl(String url) {
        return this.copy(this.copy$default$1(), url, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.materializer);
    }

    public StandaloneAhcWSRequest withMethod(String method) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), method, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.materializer);
    }

    public Future<StandaloneWSResponse> execute() {
        return (Future)this.executor.apply((Object)this);
    }

    public WSRequestExecutor filterWSRequestExecutor(WSRequestExecutor next) {
        return (WSRequestExecutor)this.filters().foldRight((Object)next, (Function2 & Serializable)(filter, executor) -> (WSRequestExecutor)filter.apply(executor));
    }

    public Future<StandaloneWSResponse> stream() {
        WSRequestExecutor executor = this.filterWSRequestExecutor(WSRequestExecutor$.MODULE$.apply((Function1 & Serializable)request -> this.client().executeStream(((StandaloneAhcWSRequest)request).buildRequest())));
        return (Future)executor.apply((Object)this);
    }

    public Option<String> requestHeader(String name) {
        return this.requestHeaders().get((Object)name).flatMap((Function1 & Serializable)_$2 -> _$2.headOption());
    }

    public Map<String, scala.collection.immutable.Seq<String>> requestHeaders() {
        return this.headersToMap(this.buildRequest().getHeaders());
    }

    public Map<String, scala.collection.immutable.Seq<String>> requestQueryParams() {
        List params = this.buildRequest().getQueryParams();
        return (Map)CollectionConverters$.MODULE$.ListHasAsScala(params).asScala().toSeq().groupBy((Function1 & Serializable)_$3 -> _$3.getName()).map((Function1 & Serializable)kv -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, ((IterableOps)kv._2()).map((Function1 & Serializable)_$4 -> _$4.getValue()));
        });
    }

    public Request buildRequest() {
        Tuple2 tuple2;
        RequestBuilder builder = (RequestBuilder)this.disableUrlEncoding().map((Function1 & Serializable)disableEncodingFlag -> this.$anonfun$6(BoxesRunTime.unboxToBoolean((Object)disableEncodingFlag))).getOrElse(this::$anonfun$7);
        builder.setUrl(this.url());
        this.auth().foreach((Function1 & Serializable)data -> {
            Realm realm = this.auth((String)data._1(), (String)data._2(), this.authScheme((WSAuthScheme)data._3()));
            return (RequestBuilder)builder.setRealm(realm);
        });
        this.queryString().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                scala.collection.immutable.Seq values = (scala.collection.immutable.Seq)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                scala.collection.immutable.Seq values = (scala.collection.immutable.Seq)tuple2._2();
                values.foreach((Function1 & Serializable)value -> (RequestBuilder)builder.addQueryParam(key, value));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.virtualHost().foreach((Function1 & Serializable)x$0 -> (RequestBuilder)builder.setVirtualHost(x$0));
        this.followRedirects().foreach((Function1 & Serializable)x$0 -> StandaloneAhcWSRequest.buildRequest$$anonfun$5(builder, BoxesRunTime.unboxToBoolean((Object)x$0)));
        this.proxyServer().foreach((Function1 & Serializable)p -> (RequestBuilder)builder.setProxyServer(this.createProxy((WSProxyServer)p)));
        this.requestTimeout().foreach((Function1 & Serializable)x$1 -> {
            Duration duration;
            Duration d;
            Duration duration2 = d = (duration = x$1);
            Duration.Infinite infinite = Duration$.MODULE$.Inf();
            if (!(duration2 != null ? !duration2.equals(infinite) : infinite != null)) {
                return (RequestBuilder)builder.setRequestTimeout(-1);
            }
            Duration d2 = duration;
            return (RequestBuilder)builder.setRequestTimeout((int)d2.toMillis());
        });
        WSBody wSBody = this.body();
        if (EmptyBody$.MODULE$.equals(wSBody)) {
            tuple2 = Tuple2$.MODULE$.apply((Object)builder, this.headers());
        } else if (wSBody instanceof InMemoryBody) {
            ByteString byteString;
            InMemoryBody inMemoryBody = InMemoryBody$.MODULE$.unapply((InMemoryBody)wSBody);
            ByteString bytes = byteString = inMemoryBody._1();
            String ct = (String)this.contentType().getOrElse(StandaloneAhcWSRequest::$anonfun$8);
            Map h = this.liftedTree1$1(ct, bytes, builder);
            tuple2 = Tuple2$.MODULE$.apply((Object)builder, (Object)h);
        } else if (wSBody instanceof SourceBody) {
            Source source;
            SourceBody sourceBody = SourceBody$.MODULE$.unapply((SourceBody)wSBody);
            Source source2 = source = sourceBody._1();
            Map filteredHeaders = (Map)this.headers().filterNot((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    scala.collection.immutable.Seq v = (scala.collection.immutable.Seq)tuple2._2();
                    return k.equalsIgnoreCase("Content-Length");
                }
                throw new MatchError((Object)tuple2);
            });
            Option contentLength = this.headers().find((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    return k.equalsIgnoreCase("Content-Length");
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)_$5 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)((IterableOps)_$5._2()).head())));
            tuple2 = Tuple2$.MODULE$.apply((Object)builder.setBody((Publisher)((Source)source2.map((Function1 & Serializable)bs -> Unpooled.wrappedBuffer((ByteBuffer)bs.toByteBuffer()))).runWith((Graph)Sink$.MODULE$.asPublisher(false), this.materializer), BoxesRunTime.unboxToLong((Object)contentLength.getOrElse(StandaloneAhcWSRequest::$anonfun$17))), (Object)filteredHeaders);
        } else {
            throw new MatchError((Object)wSBody);
        }
        Tuple2 tuple22 = tuple2;
        RequestBuilder builderWithBody = (RequestBuilder)tuple22._1();
        Map updatedHeaders = (Map)tuple22._2();
        updatedHeaders.foreach((Function1)(JProcedure1 & Serializable)header -> ((IterableOnceOps)header._2()).foreach((Function1 & Serializable)value -> (RequestBuilder)builder.addHeader((CharSequence)header._1(), value)));
        this.calc().map((Function1 & Serializable)x$1 -> {
            WSSignatureCalculator wSSignatureCalculator = x$1;
            if (wSSignatureCalculator instanceof SignatureCalculator) {
                WSSignatureCalculator signatureCalculator = (WSSignatureCalculator)((SignatureCalculator)wSSignatureCalculator);
                return (RequestBuilder)builderWithBody.setSignatureCalculator((SignatureCalculator)signatureCalculator);
            }
            throw new IllegalStateException("Unknown signature calculator found: use a class that implements SignatureCalculator");
        });
        this.cookies().foreach((Function1 & Serializable)c -> (RequestBuilder)builder.addCookie(this.asCookie((WSCookie)c)));
        return builderWithBody.build();
    }

    public Realm.AuthScheme authScheme(WSAuthScheme scheme) {
        WSAuthScheme wSAuthScheme = scheme;
        if (WSAuthScheme.DIGEST$.MODULE$.equals(wSAuthScheme)) {
            return Realm.AuthScheme.DIGEST;
        }
        if (WSAuthScheme.BASIC$.MODULE$.equals(wSAuthScheme)) {
            return Realm.AuthScheme.BASIC;
        }
        if (WSAuthScheme.NTLM$.MODULE$.equals(wSAuthScheme)) {
            return Realm.AuthScheme.NTLM;
        }
        if (WSAuthScheme.SPNEGO$.MODULE$.equals(wSAuthScheme)) {
            return Realm.AuthScheme.SPNEGO;
        }
        if (WSAuthScheme.KERBEROS$.MODULE$.equals(wSAuthScheme)) {
            return Realm.AuthScheme.KERBEROS;
        }
        throw new RuntimeException("Unknown scheme " + scheme);
    }

    public Realm auth(String username, String password, Realm.AuthScheme scheme) {
        Realm.AuthScheme authScheme = scheme;
        Realm.AuthScheme authScheme2 = Realm.AuthScheme.DIGEST;
        Realm.AuthScheme authScheme3 = authScheme;
        boolean usePreemptiveAuth = authScheme2 != null ? !authScheme2.equals(authScheme3) : authScheme3 != null;
        return new Realm.Builder(username, password).setScheme(scheme).setUsePreemptiveAuth(usePreemptiveAuth).build();
    }

    public Realm.AuthScheme auth$default$3() {
        return Realm.AuthScheme.BASIC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProxyServer createProxy(WSProxyServer wsProxyServer) {
        ProxyServer.Builder proxyBuilder;
        block7: {
            Realm.AuthScheme authScheme;
            Realm.Builder realmBuilder;
            block8: {
                proxyBuilder = new ProxyServer.Builder(wsProxyServer.host(), wsProxyServer.port());
                if (!wsProxyServer.principal().isDefined()) break block7;
                realmBuilder = new Realm.Builder((String)wsProxyServer.principal().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)wsProxyServer.password().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                String string = ((String)wsProxyServer.protocol().getOrElse(StandaloneAhcWSRequest::$anonfun$18)).toLowerCase(Locale.ENGLISH);
                switch (string == null ? 0 : string.hashCode()) {
                    case -895803204: {
                        if (!"spnego".equals(string)) throw scala.sys.package$.MODULE$.error("Unrecognized protocol!");
                        authScheme = Realm.AuthScheme.SPNEGO;
                        break block8;
                    }
                    case 3213448: {
                        if ("http".equals(string)) break;
                        throw scala.sys.package$.MODULE$.error("Unrecognized protocol!");
                    }
                    case 3391943: {
                        if (!"ntlm".equals(string)) throw scala.sys.package$.MODULE$.error("Unrecognized protocol!");
                        authScheme = Realm.AuthScheme.NTLM;
                        break block8;
                    }
                    case 99617003: {
                        if ("https".equals(string)) break;
                        throw scala.sys.package$.MODULE$.error("Unrecognized protocol!");
                    }
                    case 303053659: {
                        if (!"kerberos".equals(string)) throw scala.sys.package$.MODULE$.error("Unrecognized protocol!");
                        authScheme = Realm.AuthScheme.KERBEROS;
                        break block8;
                    }
                }
                authScheme = Realm.AuthScheme.BASIC;
                break block8;
                throw scala.sys.package$.MODULE$.error("Unrecognized protocol!");
            }
            Realm.AuthScheme scheme = authScheme;
            realmBuilder.setScheme(scheme);
            wsProxyServer.encoding().foreach((Function1 & Serializable)enc -> realmBuilder.setCharset(Charset.forName(enc)));
            wsProxyServer.ntlmDomain().foreach((Function1 & Serializable)x$0 -> realmBuilder.setNtlmDomain(x$0));
            proxyBuilder.setRealm(realmBuilder);
        }
        wsProxyServer.nonProxyHosts().foreach((Function1 & Serializable)nonProxyHosts -> proxyBuilder.setNonProxyHosts(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)nonProxyHosts).asJava()));
        return proxyBuilder.build();
    }

    public String requestUrl() {
        return this.buildRequest().getUrl();
    }

    public StandaloneAhcWSRequest copy(StandaloneAhcWSClient client, String url, String method, WSBody body, Map<String, scala.collection.immutable.Seq<String>> headers, Map<String, scala.collection.immutable.Seq<String>> queryString, scala.collection.immutable.Seq<WSCookie> cookies, Option<WSSignatureCalculator> calc, Option<Tuple3<String, String, WSAuthScheme>> auth, Option<Object> followRedirects, Option<Duration> requestTimeout, Option<String> virtualHost, Option<WSProxyServer> proxyServer, Option<Object> disableUrlEncoding, scala.collection.immutable.Seq<WSRequestFilter> filters, Materializer materializer) {
        return new StandaloneAhcWSRequest(client, url, method, body, headers, queryString, cookies, calc, auth, followRedirects, requestTimeout, virtualHost, proxyServer, disableUrlEncoding, filters, materializer);
    }

    public StandaloneAhcWSClient copy$default$1() {
        return this.client();
    }

    public String copy$default$2() {
        return this.url();
    }

    public String copy$default$3() {
        return this.method();
    }

    public WSBody copy$default$4() {
        return this.body();
    }

    public Map<String, scala.collection.immutable.Seq<String>> copy$default$5() {
        return this.headers();
    }

    public Map<String, scala.collection.immutable.Seq<String>> copy$default$6() {
        return this.queryString();
    }

    public scala.collection.immutable.Seq<WSCookie> copy$default$7() {
        return this.cookies();
    }

    public Option<WSSignatureCalculator> copy$default$8() {
        return this.calc();
    }

    public Option<Tuple3<String, String, WSAuthScheme>> copy$default$9() {
        return this.auth();
    }

    public Option<Object> copy$default$10() {
        return this.followRedirects();
    }

    public Option<Duration> copy$default$11() {
        return this.requestTimeout();
    }

    public Option<String> copy$default$12() {
        return this.virtualHost();
    }

    public Option<WSProxyServer> copy$default$13() {
        return this.proxyServer();
    }

    public Option<Object> copy$default$14() {
        return this.disableUrlEncoding();
    }

    public scala.collection.immutable.Seq<WSRequestFilter> copy$default$15() {
        return this.filters();
    }

    public StandaloneAhcWSClient _1() {
        return this.client();
    }

    public String _2() {
        return this.url();
    }

    public String _3() {
        return this.method();
    }

    public WSBody _4() {
        return this.body();
    }

    public Map<String, scala.collection.immutable.Seq<String>> _5() {
        return this.headers();
    }

    public Map<String, scala.collection.immutable.Seq<String>> _6() {
        return this.queryString();
    }

    public scala.collection.immutable.Seq<WSCookie> _7() {
        return this.cookies();
    }

    public Option<WSSignatureCalculator> _8() {
        return this.calc();
    }

    public Option<Tuple3<String, String, WSAuthScheme>> _9() {
        return this.auth();
    }

    public Option<Object> _10() {
        return this.followRedirects();
    }

    public Option<Duration> _11() {
        return this.requestTimeout();
    }

    public Option<String> _12() {
        return this.virtualHost();
    }

    public Option<WSProxyServer> _13() {
        return this.proxyServer();
    }

    public Option<Object> _14() {
        return this.disableUrlEncoding();
    }

    public scala.collection.immutable.Seq<WSRequestFilter> _15() {
        return this.filters();
    }

    private static final Object $init$$$anonfun$1() {
        return "A StandaloneAhcWSClient is required, but it is null";
    }

    private static final Object $init$$$anonfun$2() {
        return "A url is required, but it is null";
    }

    private final WSRequestExecutor executor$lzyINIT1$1(LazyRef executor$lzy1$1, StandaloneAhcWSClient client$10) {
        WSRequestExecutor wSRequestExecutor;
        LazyRef lazyRef = executor$lzy1$1;
        synchronized (lazyRef) {
            wSRequestExecutor = (WSRequestExecutor)(executor$lzy1$1.initialized() ? executor$lzy1$1.value() : executor$lzy1$1.initialize((Object)this.filterWSRequestExecutor(WSRequestExecutor$.MODULE$.apply((Function1 & Serializable)x$1 -> {
                StandaloneWSRequest standaloneWSRequest = x$1;
                if (standaloneWSRequest instanceof StandaloneAhcWSRequest) {
                    StandaloneAhcWSRequest ahcReq = (StandaloneAhcWSRequest)standaloneWSRequest;
                    return client$10.execute(ahcReq.buildRequest());
                }
                StandaloneWSRequest invalid = standaloneWSRequest;
                return Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Invalid request: " + invalid));
            }))));
        }
        return wSRequestExecutor;
    }

    private final WSRequestExecutor executor$1(LazyRef executor$lzy1$2, StandaloneAhcWSClient client$12) {
        return (WSRequestExecutor)(executor$lzy1$2.initialized() ? executor$lzy1$2.value() : this.executor$lzyINIT1$1(executor$lzy1$2, client$12));
    }

    private static final scala.collection.immutable.Seq buildQueryParams$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final Object withRequestTimeout$$anonfun$1() {
        return "Request timeout must be between 0 and " + Integer.MAX_VALUE + " milliseconds";
    }

    private final /* synthetic */ RequestBuilder $anonfun$6(boolean disableEncodingFlag) {
        return new RequestBuilder(this.method(), disableEncodingFlag);
    }

    private final RequestBuilder $anonfun$7() {
        return new RequestBuilder(this.method(), ((AsyncHttpClient)this.client().underlying()).getConfig().isDisableUrlEncodingForBoundRequests());
    }

    private static final /* synthetic */ RequestBuilder buildRequest$$anonfun$5(RequestBuilder builder$5, boolean x$0) {
        return (RequestBuilder)builder$5.setFollowRedirect(x$0);
    }

    private static final String $anonfun$8() {
        return "text/plain";
    }

    private static final Charset $anonfun$10() {
        return StandardCharsets.UTF_8;
    }

    private final Map liftedTree1$1(String ct$1, ByteString bytes$1, RequestBuilder builder$8) {
        Map map;
        try {
            if (ct$1.contains("application/x-www-form-urlencoded") && this.calc().isDefined()) {
                Map filteredHeaders = (Map)this.headers().filterNot((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        scala.collection.immutable.Seq v = (scala.collection.immutable.Seq)tuple2._2();
                        return k.equalsIgnoreCase("Content-Length");
                    }
                    throw new MatchError((Object)tuple2);
                });
                Option charsetOption = Option$.MODULE$.apply((Object)HttpUtils.extractContentTypeCharsetAttribute((String)ct$1));
                String charset = ((Charset)charsetOption.getOrElse(StandaloneAhcWSRequest::$anonfun$10)).name();
                String stringBody = bytes$1.decodeString(charset);
                scala.collection.immutable.Seq params = (scala.collection.immutable.Seq)FormUrlEncodedParser$.MODULE$.parse(stringBody, FormUrlEncodedParser$.MODULE$.parse$default$2()).toSeq().withFilter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        scala.collection.immutable.Seq values = (scala.collection.immutable.Seq)tuple2._2();
                        return true;
                    }
                    return false;
                }).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        scala.collection.immutable.Seq values = (scala.collection.immutable.Seq)tuple2._2();
                        return (scala.collection.immutable.Seq)values.map((Function1 & Serializable)value -> new Param(key, value));
                    }
                    throw new MatchError((Object)tuple2);
                });
                builder$8.setFormParams(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)params).asJava());
                map = filteredHeaders;
            } else {
                builder$8.setBody((byte[])bytes$1.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                map = this.headers();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private static final long $anonfun$17() {
        return -1L;
    }

    private static final String $anonfun$18() {
        return "http";
    }
}

