/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import play.libs.ws.WSCookie;
import play.libs.ws.WSCookieBuilder;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

interface CookieBuilder {
    default public List<WSCookie> buildCookies(Map<String, List<String>> map) {
        List<String> list = map.get(HttpHeaderNames.SET_COOKIE2);
        if (!MiscUtils.isNonEmpty(list)) {
            list = map.get(HttpHeaderNames.SET_COOKIE);
        }
        if (MiscUtils.isNonEmpty(list)) {
            ArrayList<WSCookie> arrayList = new ArrayList<WSCookie>(list.size());
            for (String string : list) {
                Cookie cookie = this.isUseLaxCookieEncoder() ? ClientCookieDecoder.LAX.decode(string) : ClientCookieDecoder.STRICT.decode(string);
                if (cookie == null) continue;
                WSCookie wSCookie = new WSCookieBuilder().setName(cookie.name()).setValue(cookie.value()).setDomain(cookie.domain()).setPath(cookie.path()).setMaxAge(Long.valueOf(cookie.maxAge())).setSecure(cookie.isSecure()).setHttpOnly(cookie.isHttpOnly()).build();
                arrayList.add(wSCookie);
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    public boolean isUseLaxCookieEncoder();
}

