/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc.cache;

import com.typesafe.play.cachecontrol.CacheDefaults;
import com.typesafe.play.cachecontrol.CacheDirectives;
import com.typesafe.play.cachecontrol.CacheRequest;
import com.typesafe.play.cachecontrol.CacheResponse;
import com.typesafe.play.cachecontrol.CurrentAgeCalculator;
import com.typesafe.play.cachecontrol.FreshnessCalculator;
import com.typesafe.play.cachecontrol.HeaderName;
import com.typesafe.play.cachecontrol.HttpDate$;
import com.typesafe.play.cachecontrol.OriginResponse;
import com.typesafe.play.cachecontrol.ResponseCachingAction;
import com.typesafe.play.cachecontrol.ResponseCachingCalculator;
import com.typesafe.play.cachecontrol.ResponseSelectionAction;
import com.typesafe.play.cachecontrol.ResponseSelectionCalculator;
import com.typesafe.play.cachecontrol.ResponseServeAction;
import com.typesafe.play.cachecontrol.ResponseServingCalculator;
import com.typesafe.play.cachecontrol.SecondaryKeyCalculator;
import com.typesafe.play.cachecontrol.Seconds;
import com.typesafe.play.cachecontrol.Seconds$;
import com.typesafe.play.cachecontrol.StoredResponse;
import com.typesafe.play.cachecontrol.StripHeaderCalculator;
import com.typesafe.play.cachecontrol.Warning;
import com.typesafe.play.cachecontrol.WarningParser$;
import java.io.Serializable;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.ahc.AhcUtilities;
import play.api.libs.ws.ahc.cache.AhcHttpCache$;
import play.api.libs.ws.ahc.cache.Cache;
import play.api.libs.ws.ahc.cache.CacheableHttpResponseBodyPart;
import play.api.libs.ws.ahc.cache.CacheableHttpResponseStatus;
import play.api.libs.ws.ahc.cache.CacheableResponse;
import play.api.libs.ws.ahc.cache.Debug;
import play.api.libs.ws.ahc.cache.EffectiveURIKey;
import play.api.libs.ws.ahc.cache.EffectiveURIKey$;
import play.api.libs.ws.ahc.cache.ResponseEntry;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.Response;
import play.shaded.ahc.org.asynchttpclient.filter.FilterContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r5f\u0001\u0002\u001f>\u0001)C\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A\u0001\u000e\u0001BC\u0002\u0013\r\u0011\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003k\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001dA\bA1A\u0005\neDq!!\u0002\u0001A\u0003%!\u0010C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011\u0011\u0003\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016!A\u0011Q\u0004\u0001!\u0002\u0013\t9\u0002C\u0005\u0002 \u0001\u0011\r\u0011\"\u0003\u0002\"!A\u0011\u0011\u0006\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002.!A\u0011Q\u0007\u0001!\u0002\u0013\ty\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002:!A\u0011\u0011\t\u0001!\u0002\u0013\tY\u0004C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u0011Q\n\u0001!\u0002\u0013\t9\u0005C\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002R!A\u0011\u0011\f\u0001!\u0002\u0013\t\u0019\u0006C\u0004\u0002\\\u0001!\t%!\u0018\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!!3\u0001\t\u0003\tY\rC\u0004\u0002r\u0002!\t!a=\t\u000f\t%\u0001\u0001\"\u0011\u0003\f!9!q\u0004\u0001\u0005B\t\u0005\u0002b\u0002B\u001b\u0001\u0011\u0005!q\u0007\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007BqAa\u0012\u0001\t\u0003\u0011I\u0005C\u0004\u0003d\u0001!\tA!\u001a\t\u000f\t-\u0004\u0001\"\u0001\u0003n!9!1\u000f\u0001\u0005\u0012\tU\u0004b\u0002BN\u0001\u0011E!Q\u0014\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u00119\u0005\u0001C\t\u0005\u007fCqA!5\u0001\t#\u0011\u0019\u000eC\u0004\u0004\u0004\u0001!\ta!\u0002\t\u000f\r-\u0001\u0001\"\u0001\u0004\u000e!91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u0012\u0001\u0011\u00051Q\u0005\u0005\b\u0007c\u0001A\u0011AB\u001a\u0011\u001d\u00199\u0004\u0001C\u0001\u0007sAqa!\u0010\u0001\t\u0003\u0019y\u0004C\u0004\u0004P\u0001!\tb!\u0015\t\u000f\rU\u0003\u0001\"\u0005\u0004X!911\r\u0001\u0005\u0012\r\u0015\u0004bBB>\u0001\u0011E1Q\u0010\u0005\b\u0007\u000b\u0003A\u0011ABD\u0011\u001d\u0019I\t\u0001C!\u0007\u0017;\u0011b!$>\u0003\u0003E\taa$\u0007\u0011qj\u0014\u0011!E\u0001\u0007#Ca!]\u001d\u0005\u0002\rM\u0005\"CBKsE\u0005I\u0011ABL\u00051\t\u0005n\u0019%uiB\u001c\u0015m\u00195f\u0015\tqt(A\u0003dC\u000eDWM\u0003\u0002A\u0003\u0006\u0019\u0011\r[2\u000b\u0005\t\u001b\u0015AA<t\u0015\t!U)\u0001\u0003mS\n\u001c(B\u0001$H\u0003\r\t\u0007/\u001b\u0006\u0002\u0011\u0006!\u0001\u000f\\1z\u0007\u0001\u0019B\u0001A&R9B\u0011AjT\u0007\u0002\u001b*\ta*A\u0003tG\u0006d\u0017-\u0003\u0002Q\u001b\n1\u0011I\\=SK\u001a\u0004\"A\u0015.\u000e\u0003MS!\u0001V+\u0002\u0019\r\f7\r[3d_:$(o\u001c7\u000b\u0005!3&BA,Y\u0003!!\u0018\u0010]3tC\u001a,'\"A-\u0002\u0007\r|W.\u0003\u0002\\'\ni1)Y2iK\u0012+g-Y;miN\u0004\"!\u00180\u000e\u0003uJ!aX\u001f\u0003\u000b\u0011+'-^4\u0002\u0015UtG-\u001a:ms&tw\r\u0005\u0002^E&\u00111-\u0010\u0002\u0006\u0007\u0006\u001c\u0007.Z\u0001\u0012Q\u0016,(/[:uS\u000e\u001cXI\\1cY\u0016$\u0007C\u0001'g\u0013\t9WJA\u0004C_>dW-\u00198\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055l\u0015AC2p]\u000e,(O]3oi&\u0011q\u000e\u001c\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003\u0019a\u0014N\\5u}Q\u00191O^<\u0015\u0005Q,\bCA/\u0001\u0011\u0015AW\u0001q\u0001k\u0011\u0015\u0001W\u00011\u0001b\u0011\u001d!W\u0001%AA\u0002\u0015\fa\u0001\\8hO\u0016\u0014X#\u0001>\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0003tY\u001a$$NC\u0001\u0000\u0003\ry'oZ\u0005\u0004\u0003\u0007a(A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u00023I,7\u000f]8og\u0016\u001c\u0015m\u00195j]\u001e\u001c\u0015\r\\2vY\u0006$xN]\u000b\u0003\u0003\u0017\u00012AUA\u0007\u0013\r\tya\u0015\u0002\u001a%\u0016\u001c\bo\u001c8tK\u000e\u000b7\r[5oO\u000e\u000bGnY;mCR|'/\u0001\u000esKN\u0004xN\\:f\u0007\u0006\u001c\u0007.\u001b8h\u0007\u0006d7-\u001e7bi>\u0014\b%A\rsKN\u0004xN\\:f'\u0016\u0014h/\u001b8h\u0007\u0006d7-\u001e7bi>\u0014XCAA\f!\r\u0011\u0016\u0011D\u0005\u0004\u00037\u0019&!\u0007*fgB|gn]3TKJ4\u0018N\\4DC2\u001cW\u000f\\1u_J\f!D]3ta>t7/Z*feZLgnZ\"bY\u000e,H.\u0019;pe\u0002\n1D]3ta>t7/Z*fY\u0016\u001cG/[8o\u0007\u0006d7-\u001e7bi>\u0014XCAA\u0012!\r\u0011\u0016QE\u0005\u0004\u0003O\u0019&a\u0007*fgB|gn]3TK2,7\r^5p]\u000e\u000bGnY;mCR|'/\u0001\u000fsKN\u0004xN\\:f'\u0016dWm\u0019;j_:\u001c\u0015\r\\2vY\u0006$xN\u001d\u0011\u0002+M$(/\u001b9IK\u0006$WM]\"bY\u000e,H.\u0019;peV\u0011\u0011q\u0006\t\u0004%\u0006E\u0012bAA\u001a'\n)2\u000b\u001e:ja\"+\u0017\rZ3s\u0007\u0006d7-\u001e7bi>\u0014\u0018AF:ue&\u0004\b*Z1eKJ\u001c\u0015\r\\2vY\u0006$xN\u001d\u0011\u0002-M,7m\u001c8eCJL8*Z=DC2\u001cW\u000f\\1u_J,\"!a\u000f\u0011\u0007I\u000bi$C\u0002\u0002@M\u0013acU3d_:$\u0017M]=LKf\u001c\u0015\r\\2vY\u0006$xN]\u0001\u0018g\u0016\u001cwN\u001c3bef\\U-_\"bY\u000e,H.\u0019;pe\u0002\nAcY;se\u0016tG/Q4f\u0007\u0006d7-\u001e7bi>\u0014XCAA$!\r\u0011\u0016\u0011J\u0005\u0004\u0003\u0017\u001a&\u0001F\"veJ,g\u000e^!hK\u000e\u000bGnY;mCR|'/A\u000bdkJ\u0014XM\u001c;BO\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\u0011\u0002'\u0019\u0014Xm\u001d5oKN\u001c8)\u00197dk2\fGo\u001c:\u0016\u0005\u0005M\u0003c\u0001*\u0002V%\u0019\u0011qK*\u0003'\u0019\u0013Xm\u001d5oKN\u001c8)\u00197dk2\fGo\u001c:\u0002)\u0019\u0014Xm\u001d5oKN\u001c8)\u00197dk2\fGo\u001c:!\u0003!I7o\u00155be\u0016$W#A3\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002d\u0005U\u0004#B6\u0002f\u0005%\u0014bAA4Y\n1a)\u001e;ve\u0016\u0004R\u0001TA6\u0003_J1!!\u001cN\u0005\u0019y\u0005\u000f^5p]B\u0019Q,!\u001d\n\u0007\u0005MTHA\u0007SKN\u0004xN\\:f\u000b:$(/\u001f\u0005\b\u0003o:\u0002\u0019AA=\u0003\rYW-\u001f\t\u0004;\u0006m\u0014bAA?{\tyQI\u001a4fGRLg/Z+S\u0013.+\u00170A\u0002qkR$b!a!\u0002\f\u00065\u0005#B6\u0002f\u0005\u0015\u0005c\u0001'\u0002\b&\u0019\u0011\u0011R'\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003oB\u0002\u0019AA=\u0011\u001d\ty\t\u0007a\u0001\u0003_\nQ!\u001a8uef\faA]3n_Z,G\u0003BAB\u0003+Cq!a\u001e\u001a\u0001\u0004\tI(A\u0007j]Z\fG.\u001b3bi\u0016\\U-\u001f\u000b\u0005\u0003\u000b\u000bY\nC\u0004\u0002xi\u0001\r!!\u001f\u0002\u001b\r\f7\r[5oO\u0006\u001bG/[8o)\u0019\t\t+a*\u0002@B\u0019!+a)\n\u0007\u0005\u00156KA\u000bSKN\u0004xN\\:f\u0007\u0006\u001c\u0007.\u001b8h\u0003\u000e$\u0018n\u001c8\t\u000f\u0005%6\u00041\u0001\u0002,\u00069!/Z9vKN$\b\u0003BAW\u0003wk!!a,\u000b\t\u0005E\u00161W\u0001\u0010CNLhn\u00195uiB\u001cG.[3oi*\u0019q0!.\u000b\u0007\u0001\u000b9LC\u0002\u0002:\u001e\u000baa\u001d5bI\u0016$\u0017\u0002BA_\u0003_\u0013qAU3rk\u0016\u001cH\u000fC\u0004\u0002Bn\u0001\r!a1\u0002\u0011I,7\u000f]8og\u0016\u00042!XAc\u0013\r\t9-\u0010\u0002\u0012\u0007\u0006\u001c\u0007.Z1cY\u0016\u0014Vm\u001d9p]N,\u0017aD:fY\u0016\u001cG/[8o\u0003\u000e$\u0018n\u001c8\u0015\r\u00055\u00171[Ak!\r\u0011\u0016qZ\u0005\u0004\u0003#\u001c&a\u0006*fgB|gn]3TK2,7\r^5p]\u0006\u001bG/[8o\u0011\u001d\tI\u000b\ba\u0001\u0003WCq!a6\u001d\u0001\u0004\tI.A\u0004f]R\u0014\u0018.Z:\u0011\r\u0005m\u00171^A8\u001d\u0011\ti.a:\u000f\t\u0005}\u0017Q]\u0007\u0003\u0003CT1!a9J\u0003\u0019a$o\\8u}%\ta*C\u0002\u0002j6\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002n\u0006=(aA*fc*\u0019\u0011\u0011^'\u0002\u0017M,'O^3BGRLwN\u001c\u000b\t\u0003k\fY0!@\u0002\u0000B\u0019!+a>\n\u0007\u0005e8KA\nSKN\u0004xN\\:f'\u0016\u0014h/Z!di&|g\u000eC\u0004\u0002*v\u0001\r!a+\t\u000f\u0005=U\u00041\u0001\u0002p!9!\u0011A\u000fA\u0002\t\r\u0011AC2veJ,g\u000e^!hKB\u0019!K!\u0002\n\u0007\t\u001d1KA\u0004TK\u000e|g\u000eZ:\u0002?\r\fGnY;mCR,gI]3tQ:,7o\u001d$s_6DU-\u001e:jgRL7\r\u0006\u0004\u0003\u000e\t=!q\u0003\t\u0006\u0019\u0006-$1\u0001\u0005\b\u0003Ss\u0002\u0019\u0001B\t!\r\u0011&1C\u0005\u0004\u0005+\u0019&\u0001D\"bG\",'+Z9vKN$\bbBAa=\u0001\u0007!\u0011\u0004\t\u0004%\nm\u0011b\u0001B\u000f'\ni1)Y2iKJ+7\u000f]8og\u0016\fA#[:DC\u000eDW-\u00192mK\u0016CH/\u001a8tS>tGcA3\u0003$!9!QE\u0010A\u0002\t\u001d\u0012!C3yi\u0016t7/[8o!\u0011\u0011ICa\f\u000f\u0007I\u0013Y#C\u0002\u0003.M\u000bqbQ1dQ\u0016$\u0015N]3di&4Xm]\u0005\u0005\u0005c\u0011\u0019DA\fDC\u000eDW\rR5sK\u000e$\u0018N^3FqR,gn]5p]*\u0019!QF*\u0002\u001b%\u001chj\u001c;N_\u0012Lg-[3e)\r)'\u0011\b\u0005\b\u0003\u0003\u0004\u0003\u0019AAb\u0003\u001dI7/\u0012:s_J$2!\u001aB \u0011\u001d\t\t-\ta\u0001\u0003\u0007\fa\"[:V]N\fg-Z'fi\"|G\rF\u0002f\u0005\u000bBq!!+#\u0001\u0004\tY+A\ndC2\u001cW\u000f\\1uK\u000e+(O]3oi\u0006;W\r\u0006\u0005\u0003\u0004\t-#Q\nB(\u0011\u001d\tIk\ta\u0001\u0003WCq!a$$\u0001\u0004\ty\u0007C\u0004\u0003R\r\u0002\rAa\u0015\u0002\u0017I,\u0017/^3tiRKW.\u001a\t\u0005\u0005+\u0012y&\u0004\u0002\u0003X)!!\u0011\fB.\u0003\u0011!\u0018.\\3\u000b\u0005\tu\u0013\u0001\u00026bm\u0006LAA!\u0019\u0003X\ti!l\u001c8fI\u0012\u000bG/\u001a+j[\u0016\f!dY1mGVd\u0017\r^3Ge\u0016\u001c\bN\\3tg2Kg-\u001a;j[\u0016$bAa\u0001\u0003h\t%\u0004bBAUI\u0001\u0007\u00111\u0016\u0005\b\u0003\u001f#\u0003\u0019AA8\u0003IIgN^1mS\u0012\fG/Z%g+:\u001c\u0018MZ3\u0015\r\u0005\u0015%q\u000eB9\u0011\u001d\tI+\na\u0001\u0003WCq!!1&\u0001\u0004\t\u0019-\u0001\u0004hKR,&+\u0013\u000b\u0007\u0005o\u0012)Ia\"\u0011\u000b1\u000bYG!\u001f\u0011\t\tm$\u0011Q\u0007\u0003\u0005{RAAa \u0003\\\u0005\u0019a.\u001a;\n\t\t\r%Q\u0010\u0002\u0004+JK\u0005bBAaM\u0001\u0007\u00111\u0019\u0005\b\u0005\u00133\u0003\u0019\u0001BF\u0003)AW-\u00193fe:\u000bW.\u001a\t\u0005\u0005\u001b\u0013)J\u0004\u0003\u0003\u0010\nE\u0005cAAp\u001b&\u0019!1S'\u0002\rA\u0013X\rZ3g\u0013\u0011\u00119J!'\u0003\rM#(/\u001b8h\u0015\r\u0011\u0019*T\u0001\u0013SNtuN\\#se>\u0014(+Z:q_:\u001cX\rF\u0002f\u0005?Cq!!1(\u0001\u0004\t\u0019-\u0001\fdC2\u001cW\u000f\\1uKN+7m\u001c8eCJL8*Z=t)\u0019\u0011)K!.\u00038B)A*a\u001b\u0003(BA!Q\u0012BU\u0005[\u0013\u0019,\u0003\u0003\u0003,\ne%aA'baB\u0019!Ka,\n\u0007\tE6K\u0001\u0006IK\u0006$WM\u001d(b[\u0016\u0004b!a7\u0002l\n-\u0005bBAUQ\u0001\u0007\u00111\u0016\u0005\b\u0003\u0003D\u0003\u0019\u0001B]!\u0011\tiKa/\n\t\tu\u0016q\u0016\u0002\t%\u0016\u001c\bo\u001c8tKRQ!1\u0001Ba\u0005\u0007\u0014YM!4\t\u000f\u0005%\u0016\u00061\u0001\u0003\u0012!9\u0011\u0011Y\u0015A\u0002\t\u0015\u0007c\u0001*\u0003H&\u0019!\u0011Z*\u0003\u001dM#xN]3e%\u0016\u001c\bo\u001c8tK\"9!\u0011K\u0015A\u0002\tM\u0003b\u0002BhS\u0001\u0007!1K\u0001\re\u0016\u001c\bo\u001c8tKRKW.Z\u0001\u0014G\u0006d7-\u001e7bi\u0016$\u0016.\\3U_2Kg/\u001a\u000b\t\u0005+\u00149N!7\u0003dB)A*a\u001b\u0003T!9\u0011\u0011\u0016\u0016A\u0002\u0005-\u0006b\u0002BnU\u0001\u0007!Q\\\u0001\u0007gR\fG/^:\u0011\u0007u\u0013y.C\u0002\u0003bv\u00121dQ1dQ\u0016\f'\r\\3IiR\u0004(+Z:q_:\u001cXm\u0015;biV\u001c\bb\u0002BsU\u0001\u0007!q]\u0001\bQ\u0016\fG-\u001a:t!\u0011\u0011IOa@\u000e\u0005\t-(\u0002\u0002Bw\u0005_\fA\u0001\u001b;ua*!!\u0011\u001fBz\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\u0011)Pa>\u0002\u000f!\fg\u000e\u001a7fe*!!\u0011 B~\u0003\u0015qW\r\u001e;z\u0015\u0011\u0011i0!.\u0002\u0005%|\u0017\u0002BB\u0001\u0005W\u00141\u0002\u0013;ua\"+\u0017\rZ3sg\u0006i1-Y2iKJ+7\u000f]8og\u0016$b!!\"\u0004\b\r%\u0001bBAUW\u0001\u0007\u00111\u0016\u0005\b\u0003\u0003\\\u0003\u0019AAb\u0003II7/\u00168dC\u000eDW\r\u001a*fgB|gn]3\u0015\u0007\u0015\u001cy\u0001C\u0004\u0004\u00121\u0002\raa\u0005\u0002\u0007\u0005t\u0017\u0010E\u0002M\u0007+I1aa\u0006N\u0005\r\te._\u0001\u0010MJ,7\u000f[3o%\u0016\u001c\bo\u001c8tKR1\u00111YB\u000f\u0007CAqaa\b.\u0001\u0004\u00119/\u0001\u0006oK^DU-\u00193feNDq!!1.\u0001\u0004\t\u0019-\u0001\fhK:,'/\u0019;f\u0007\u0006\u001c\u0007.\u001a3SKN\u0004xN\\:f))\t\u0019ma\n\u0004*\r-2Q\u0006\u0005\b\u0003Ss\u0003\u0019AAV\u0011\u001d\tyI\fa\u0001\u0003_BqA!\u0001/\u0001\u0004\u0011\u0019\u0001\u0003\u0004\u000409\u0002\r!Z\u0001\bSN4%/Z:i\u0003U\tG\r\u001a*fm\u0006d\u0017\u000eZ1uS>tg)Y5mK\u0012$B!a1\u00046!9\u0011\u0011Y\u0018A\u0002\u0005\r\u0017aE1eI\u0012K7oY8o]\u0016\u001cG\u000fS3bI\u0016\u0014H\u0003BAb\u0007wAq!!11\u0001\u0004\t\u0019-\u0001\bsKBd\u0017mY3IK\u0006$WM]:\u0015\t\r\u00053Q\n\u000b\u0005\u0003\u0007\u001c\u0019\u0005C\u0004\u0004FE\u0002\raa\u0012\u0002\u000b\tdwnY6\u0011\u000f1\u001bIEa:\u0003h&\u001911J'\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBAac\u0001\u0007\u00111Y\u0001\u0015O\u0016tWM]1uK\u000e\u000b7\r[3SKF,Xm\u001d;\u0015\t\tE11\u000b\u0005\b\u0003S\u0013\u0004\u0019AAV\u0003Y9WM\\3sCR,7\u000b^8sK\u0012\u0014Vm\u001d9p]N,G\u0003\u0003Bc\u00073\u001aYfa\u0018\t\u000f\u0005\u00057\u00071\u0001\u0002D\"91QL\u001aA\u0002\t-\u0015!\u0004:fcV,7\u000f^'fi\"|G\rC\u0004\u0004bM\u0002\rAa*\u0002!9|W.\u001b8bi\u0016$\u0007*Z1eKJ\u001c\u0018AF4f]\u0016\u0014\u0018\r^3Pe&<\u0017N\u001c*fgB|gn]3\u0015\u0011\r\u001d4QNB8\u0007o\u00022AUB5\u0013\r\u0019Yg\u0015\u0002\u000f\u001fJLw-\u001b8SKN\u0004xN\\:f\u0011\u001d\tI\u000b\u000ea\u0001\u0003WCqAa75\u0001\u0004\u0019\t\bE\u0002M\u0007gJ1a!\u001eN\u0005\rIe\u000e\u001e\u0005\b\u0007s\"\u0004\u0019\u0001Bt\u0003=\u0011Xm\u001d9p]N,\u0007*Z1eKJ\u001c\u0018\u0001D:ue&\u0004\b*Z1eKJ\u001cHCBAb\u0007\u007f\u001a\t\tC\u0004\u0002*V\u0002\r!a+\t\u000f\r\rU\u00071\u0001\u0002D\u0006a\u0001\u000e\u001e;q%\u0016\u001c\bo\u001c8tK\u0006)1\r\\8tKR\u0011\u0011QQ\u0001\ti>\u001cFO]5oOR\u0011!1R\u0001\r\u0003\"\u001c\u0007\n\u001e;q\u0007\u0006\u001c\u0007.\u001a\t\u0003;f\u001a\"!O&\u0015\u0005\r=\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\u001a*\u001aQma',\u0005\ru\u0005\u0003BBP\u0007Sk!a!)\u000b\t\r\r6QU\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa*N\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007W\u001b\tKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class AhcHttpCache
implements CacheDefaults,
Debug {
    private final Cache underlying;
    private final boolean heuristicsEnabled;
    private final ExecutionContext executionContext;
    private final Logger logger;
    private final ResponseCachingCalculator responseCachingCalculator;
    private final ResponseServingCalculator responseServingCalculator;
    private final ResponseSelectionCalculator responseSelectionCalculator;
    private final StripHeaderCalculator stripHeaderCalculator;
    private final SecondaryKeyCalculator secondaryKeyCalculator;
    private final CurrentAgeCalculator currentAgeCalculator;
    private final FreshnessCalculator freshnessCalculator;

    public static boolean $lessinit$greater$default$2() {
        return AhcHttpCache$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String debug(AsyncHttpClientConfig cfg) {
        return Debug.debug$((Debug)this, cfg);
    }

    @Override
    public String debug(Request request) {
        return Debug.debug$((Debug)this, request);
    }

    @Override
    public String debug(Response response) {
        return Debug.debug$((Debug)this, response);
    }

    @Override
    public String debug(HttpResponseStatus responseStatus) {
        return Debug.debug$((Debug)this, responseStatus);
    }

    @Override
    public String debug(HttpHeaders responseHeaders) {
        return Debug.debug$((Debug)this, responseHeaders);
    }

    @Override
    public String debug(List<HttpResponseBodyPart> bodyParts) {
        return Debug.debug$((Debug)this, bodyParts);
    }

    @Override
    public <T> String debug(AsyncHandler<T> handler) {
        return Debug.debug$((Debug)this, handler);
    }

    @Override
    public <T> String debug(FilterContext<T> ctx) {
        return Debug.debug$((Debug)this, ctx);
    }

    @Override
    public String debug(HttpResponseBodyPart bodyPart) {
        return Debug.debug$((Debug)this, bodyPart);
    }

    @Override
    public TreeMap<String, Seq<String>> headersToMap(HttpHeaders headers) {
        return AhcUtilities.headersToMap$(this, headers);
    }

    public boolean isUnderstoodStatusCode(int statusCode) {
        return CacheDefaults.isUnderstoodStatusCode$((CacheDefaults)this, (int)statusCode);
    }

    public boolean isCacheableMethod(String requestMethod) {
        return CacheDefaults.isCacheableMethod$((CacheDefaults)this, (String)requestMethod);
    }

    public boolean isDefaultCacheable(int statusCode) {
        return CacheDefaults.isDefaultCacheable$((CacheDefaults)this, (int)statusCode);
    }

    public boolean containsMatchingHeaders(Map<HeaderName, Seq<String>> presentedHeaders, Map<HeaderName, Seq<String>> nominatedHeaders) {
        return CacheDefaults.containsMatchingHeaders$((CacheDefaults)this, presentedHeaders, nominatedHeaders);
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private Logger logger() {
        return this.logger;
    }

    private ResponseCachingCalculator responseCachingCalculator() {
        return this.responseCachingCalculator;
    }

    private ResponseServingCalculator responseServingCalculator() {
        return this.responseServingCalculator;
    }

    private ResponseSelectionCalculator responseSelectionCalculator() {
        return this.responseSelectionCalculator;
    }

    private StripHeaderCalculator stripHeaderCalculator() {
        return this.stripHeaderCalculator;
    }

    private SecondaryKeyCalculator secondaryKeyCalculator() {
        return this.secondaryKeyCalculator;
    }

    private CurrentAgeCalculator currentAgeCalculator() {
        return this.currentAgeCalculator;
    }

    private FreshnessCalculator freshnessCalculator() {
        return this.freshnessCalculator;
    }

    public boolean isShared() {
        return false;
    }

    public Future<Option<ResponseEntry>> get(EffectiveURIKey key) {
        this.logger().debug("get: key = " + key);
        Predef$.MODULE$.require(key != null, (Function0 & Serializable)() -> "key is null");
        return this.underlying.get(key);
    }

    public Future<BoxedUnit> put(EffectiveURIKey key, ResponseEntry entry) {
        this.logger().debug("put: key = " + key + ", entry = " + entry);
        Predef$.MODULE$.require(entry != null, (Function0 & Serializable)() -> "value is null");
        return this.underlying.put(key, entry);
    }

    public Future<BoxedUnit> remove(EffectiveURIKey key) {
        Predef$.MODULE$.require(key != null, (Function0 & Serializable)() -> "key is null");
        return this.underlying.remove(key);
    }

    public void invalidateKey(EffectiveURIKey key) {
        this.underlying.get(key).map((Function1 & Serializable)maybeEntry -> {
            maybeEntry.foreach((Function1 & Serializable)entry -> {
                Some x$1 = new Some((Object)HttpDate$.MODULE$.fromEpochSeconds(0));
                CacheableResponse x$2 = entry.copy$default$1();
                String x$3 = entry.copy$default$2();
                Map<HeaderName, Seq<String>> x$4 = entry.copy$default$3();
                ResponseEntry expiredEntry = entry.copy(x$2, x$3, x$4, (Option<ZonedDateTime>)x$1);
                return $this.put(key$1, expiredEntry);
            });
            return BoxedUnit.UNIT;
        }, this.executionContext());
    }

    public ResponseCachingAction cachingAction(Request request, CacheableResponse response) {
        HttpHeaders headers = response.headers();
        int statusCode = response.getStatusCode();
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        OriginResponse originResponse = this.generateOriginResponse(request, statusCode, headers);
        ResponseCachingAction action = this.responseCachingCalculator().isCacheable(cacheRequest, originResponse);
        return action;
    }

    public ResponseSelectionAction selectionAction(Request request, Seq<ResponseEntry> entries) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        Seq storedResponses = (Seq)entries.map((Function1 & Serializable)entry -> this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders()));
        return this.responseSelectionCalculator().selectResponse(cacheRequest, storedResponses);
    }

    public ResponseServeAction serveAction(Request request, ResponseEntry entry, Seconds currentAge) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        StoredResponse storedResponse = this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders());
        return this.responseServingCalculator().serveResponse(cacheRequest, storedResponse, currentAge);
    }

    public Option<Seconds> calculateFreshnessFromHeuristic(CacheRequest request, CacheResponse response) {
        if (this.heuristicsEnabled) {
            return response.headers().get((Object)new HeaderName("Last-Modified")).map((Function1 & Serializable)lastModifiedString -> {
                ZonedDateTime lastModified = HttpDate$.MODULE$.parse((String)lastModifiedString.head());
                ZonedDateTime lastRequestedAt = HttpDate$.MODULE$.now();
                Seconds timeSinceLastModified = HttpDate$.MODULE$.diff(lastModified, lastRequestedAt);
                int scaledDownSeconds = (int)(0.1 * (double)timeSinceLastModified.seconds());
                Seconds scaledSeconds = Seconds$.MODULE$.seconds((long)scaledDownSeconds);
                return scaledSeconds;
            });
        }
        return None$.MODULE$;
    }

    public boolean isCacheableExtension(CacheDirectives.CacheDirectiveExtension extension) {
        return false;
    }

    public boolean isNotModified(CacheableResponse response) {
        return response.getStatusCode() == 304;
    }

    public boolean isError(CacheableResponse response) {
        int n = response.getStatusCode();
        switch (n) {
            case 500: 
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    public boolean isUnsafeMethod(Request request) {
        block10: {
            String string = request.getMethod();
            switch (string == null ? 0 : string.hashCode()) {
                case -531492226: {
                    if ("OPTIONS".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 70454: {
                    if ("GET".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 2213344: {
                    if ("HEAD".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 80083237: {
                    if ("TRACE".equals(string)) {
                        break;
                    }
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            return false;
        }
        return true;
    }

    public Seconds calculateCurrentAge(Request request, ResponseEntry entry, ZonedDateTime requestTime) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        StoredResponse storedResponse = this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders());
        Seconds currentAge = this.calculateCurrentAge(cacheRequest, storedResponse, requestTime, HttpDate$.MODULE$.now());
        return currentAge;
    }

    public Seconds calculateFreshnessLifetime(Request request, ResponseEntry entry) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        StoredResponse storedResponse = this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders());
        Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(cacheRequest, (CacheResponse)storedResponse);
        return freshnessLifetime;
    }

    public void invalidateIfUnsafe(Request request, CacheableResponse response) {
        this.logger().trace("invalidate: request = " + this.debug(request) + ", response = " + this.debug(response));
        if (this.isUnsafeMethod(request) && this.isNonErrorResponse(response)) {
            String requestHost = request.getUri().getHost();
            EffectiveURIKey responseKey = new EffectiveURIKey(request.getMethod(), response.getUri().toJavaNetURI());
            this.invalidateKey(responseKey);
            this.getURI(response, "Content-Location").foreach((Function1 & Serializable)contentLocation -> {
                AhcHttpCache.$anonfun$invalidateIfUnsafe$1(this, requestHost, request, contentLocation);
                return BoxedUnit.UNIT;
            });
            this.getURI(response, "Location").foreach((Function1 & Serializable)location -> {
                AhcHttpCache.$anonfun$invalidateIfUnsafe$2(this, requestHost, request, location);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Option<URI> getURI(CacheableResponse response, String headerName) {
        return Option$.MODULE$.apply((Object)response.getHeaders().get(headerName)).map((Function1 & Serializable)value -> {
            URI baseURI = response.getUri().toJavaNetURI();
            return baseURI.resolve((String)value);
        });
    }

    public boolean isNonErrorResponse(CacheableResponse response) {
        int n = response.getStatusCode();
        switch (n) {
            default: 
        }
        if (n >= 200 && n < 300) {
            return true;
        }
        return n >= 300 && n < 400;
    }

    public Option<Map<HeaderName, Seq<String>>> calculateSecondaryKeys(Request request, Response response) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        TreeMap headers = (TreeMap)this.headersToMap(response.getHeaders()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return new Tuple2((Object)new HeaderName(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return this.secondaryKeyCalculator().calculate(cacheRequest, (Map)headers);
    }

    public Seconds calculateCurrentAge(CacheRequest request, StoredResponse response, ZonedDateTime requestTime, ZonedDateTime responseTime) {
        return this.currentAgeCalculator().calculateCurrentAge(request, response, requestTime, responseTime);
    }

    public Option<ZonedDateTime> calculateTimeToLive(Request request, CacheableHttpResponseStatus status, HttpHeaders headers) {
        return new Some((Object)ZonedDateTime.now().plusHours(24L));
    }

    public void cacheResponse(Request request, CacheableResponse response) {
        this.logger().debug("cacheResponse: response = " + this.debug(response));
        CacheableResponse strippedResponse = this.stripHeaders(request, response);
        this.logger().debug("cacheResponse: strippedResponse = " + this.debug(strippedResponse));
        Map nominated = (Map)this.calculateSecondaryKeys(request, strippedResponse).getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        Option<ZonedDateTime> ttl = this.calculateTimeToLive(request, strippedResponse.status(), strippedResponse.headers());
        ResponseEntry entry = new ResponseEntry(strippedResponse, request.getMethod(), (Map<HeaderName, Seq<String>>)nominated, ttl);
        this.put(EffectiveURIKey$.MODULE$.apply(request), entry);
    }

    public boolean isUncachedResponse(Object any) {
        Object object = any;
        if (object instanceof CacheableHttpResponseStatus) {
            return false;
        }
        if (object instanceof HttpHeaders) {
            return false;
        }
        if (object instanceof CacheableHttpResponseBodyPart) {
            return false;
        }
        return !(object instanceof CacheableResponse);
    }

    public CacheableResponse freshenResponse(HttpHeaders newHeaders, CacheableResponse response) {
        if (this.logger().isTraceEnabled()) {
            this.logger().trace("freshenResponse: newHeaders = " + newHeaders + ", storedResponse = " + response);
        }
        HttpHeaders headers = response.headers();
        HttpHeaders headersMap = new DefaultHttpHeaders().add(headers);
        List filteredWarnings = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(headersMap.getAll("Warning")).asScala().filter((Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)AhcHttpCache.$anonfun$freshenResponse$1(line)))).asJava();
        headersMap.set("Warning", (java.lang.Iterable)filteredWarnings);
        headersMap.set(newHeaders);
        HttpHeaders x$1 = headersMap;
        CacheableHttpResponseStatus x$2 = response.copy$default$1();
        List<CacheableHttpResponseBodyPart> x$3 = response.copy$default$3();
        AsyncHttpClientConfig x$4 = response.copy$default$4();
        return response.copy(x$2, x$1, x$3, x$4);
    }

    public CacheableResponse generateCachedResponse(Request request, ResponseEntry entry, Seconds currentAge, boolean isFresh) {
        return this.replaceHeaders(entry.response(), (Function1<HttpHeaders, HttpHeaders>)(Function1 & Serializable)headers -> {
            headers.set("Age", (Object)Long.toString(currentAge.seconds()));
            Object object = !isFresh ? headers.add("Warning", (Object)new Warning(110, "-", "Response is Stale", (Option)None$.MODULE$).toString()) : BoxedUnit.UNIT;
            return headers;
        });
    }

    public CacheableResponse addRevalidationFailed(CacheableResponse response) {
        return this.replaceHeaders(response, (Function1<HttpHeaders, HttpHeaders>)(Function1 & Serializable)headers -> headers.add("Warning", (Object)new Warning(111, "-", "Revalidation Failed", (Option)None$.MODULE$).toString()));
    }

    public CacheableResponse addDisconnectHeader(CacheableResponse response) {
        return this.replaceHeaders(response, (Function1<HttpHeaders, HttpHeaders>)(Function1 & Serializable)headers -> headers.add("Warning", (Object)new Warning(112, "-", "Disconnected Operation", (Option)None$.MODULE$).toString()));
    }

    public CacheableResponse replaceHeaders(CacheableResponse response, Function1<HttpHeaders, HttpHeaders> block) {
        HttpHeaders newHeadersMap;
        HttpHeaders x$1 = newHeadersMap = (HttpHeaders)block.apply((Object)new DefaultHttpHeaders().add(response.getHeaders()));
        CacheableHttpResponseStatus x$2 = response.copy$default$1();
        List<CacheableHttpResponseBodyPart> x$3 = response.copy$default$3();
        AsyncHttpClientConfig x$4 = response.copy$default$4();
        return response.copy(x$2, x$1, x$3, x$4);
    }

    public CacheRequest generateCacheRequest(Request request) {
        URI uri = request.getUri().toJavaNetURI();
        TreeMap headers = (TreeMap)this.headersToMap(request.getHeaders()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return new Tuple2((Object)new HeaderName(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        String method = request.getMethod();
        return new CacheRequest(uri, method, (Map)headers);
    }

    public StoredResponse generateStoredResponse(CacheableResponse response, String requestMethod, Map<HeaderName, Seq<String>> nominatedHeaders) {
        URI uri = response.getUri().toJavaNetURI();
        int status = response.getStatusCode();
        HttpHeaders responseHeaders = response.getHeaders();
        TreeMap headers = (TreeMap)this.headersToMap(responseHeaders).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return new Tuple2((Object)new HeaderName(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return new StoredResponse(uri, status, (Map)headers, requestMethod, nominatedHeaders);
    }

    public OriginResponse generateOriginResponse(Request request, int status, HttpHeaders responseHeaders) {
        URI uri = request.getUri().toJavaNetURI();
        TreeMap headers = (TreeMap)this.headersToMap(responseHeaders).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return new Tuple2((Object)new HeaderName(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return new OriginResponse(uri, status, (Map)headers);
    }

    public CacheableResponse stripHeaders(Request request, CacheableResponse httpResponse) {
        CacheableResponse cacheableResponse;
        OriginResponse originResponse = this.generateOriginResponse(request, httpResponse.getStatusCode(), httpResponse.headers());
        Set stripSet = this.stripHeaderCalculator().stripHeaders((CacheResponse)originResponse);
        if (stripSet.nonEmpty()) {
            Collection stripHeaderNames = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)stripSet.map((Function1 & Serializable)x$1 -> x$1.toString())).asJavaCollection();
            this.logger().debug("massageCachedResponse: stripHeaderNames = " + stripHeaderNames);
            HttpHeaders httpHeaders = httpResponse.getHeaders();
            CollectionConverters$.MODULE$.CollectionHasAsScala(stripHeaderNames).asScala().foreach((Function1 & Serializable)x$1 -> httpHeaders.remove(x$1));
            this.logger().debug("massageCachedResponse: strippedHeaders = " + httpResponse.getHeaders());
            HttpHeaders x$12 = httpResponse.getHeaders();
            CacheableHttpResponseStatus x$2 = httpResponse.copy$default$1();
            List<CacheableHttpResponseBodyPart> x$3 = httpResponse.copy$default$3();
            AsyncHttpClientConfig x$4 = httpResponse.copy$default$4();
            cacheableResponse = httpResponse.copy(x$2, x$12, x$3, x$4);
        } else {
            cacheableResponse = httpResponse;
        }
        CacheableResponse r = cacheableResponse;
        return r;
    }

    public void close() {
        this.underlying.close();
    }

    public String toString() {
        return "AhcHttpCache(" + this.underlying + ")";
    }

    public static final /* synthetic */ void $anonfun$invalidateIfUnsafe$1(AhcHttpCache $this, String requestHost$1, Request request$1, URI contentLocation) {
        if (requestHost$1.equalsIgnoreCase(contentLocation.getHost())) {
            EffectiveURIKey key = new EffectiveURIKey(request$1.getMethod(), contentLocation);
            $this.invalidateKey(key);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$invalidateIfUnsafe$2(AhcHttpCache $this, String requestHost$1, Request request$1, URI location) {
        if (requestHost$1.equalsIgnoreCase(location.getHost())) {
            EffectiveURIKey key = new EffectiveURIKey(request$1.getMethod(), location);
            $this.invalidateKey(key);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$freshenResponse$1(String line) {
        Warning warning = WarningParser$.MODULE$.parse(line);
        return warning.code() < 200;
    }

    public AhcHttpCache(Cache underlying, boolean heuristicsEnabled, ExecutionContext executionContext) {
        this.underlying = underlying;
        this.heuristicsEnabled = heuristicsEnabled;
        this.executionContext = executionContext;
        CacheDefaults.$init$((CacheDefaults)this);
        AhcUtilities.$init$(this);
        Debug.$init$(this);
        Predef$.MODULE$.require(underlying != null, (Function0 & Serializable)() -> "null underlying!");
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.responseCachingCalculator = new ResponseCachingCalculator((com.typesafe.play.cachecontrol.Cache)this);
        this.responseServingCalculator = new ResponseServingCalculator((com.typesafe.play.cachecontrol.Cache)this);
        this.responseSelectionCalculator = new ResponseSelectionCalculator((com.typesafe.play.cachecontrol.Cache)this);
        this.stripHeaderCalculator = new StripHeaderCalculator((com.typesafe.play.cachecontrol.Cache)this);
        this.secondaryKeyCalculator = new SecondaryKeyCalculator();
        this.currentAgeCalculator = new CurrentAgeCalculator();
        this.freshnessCalculator = new FreshnessCalculator((com.typesafe.play.cachecontrol.Cache)this);
    }
}

