/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import org.playframework.cachecontrol.Cache;
import org.playframework.cachecontrol.CacheDirectives;
import org.playframework.cachecontrol.CacheDirectives$;
import org.playframework.cachecontrol.CacheDirectives$MustRevalidate$;
import org.playframework.cachecontrol.CacheDirectives$ProxyRevalidate$;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.FreshnessCalculator;
import org.playframework.cachecontrol.HeaderName;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.ResponseServeAction;
import org.playframework.cachecontrol.ResponseServeActions;
import org.playframework.cachecontrol.ResponseServeActions$ServeFresh$;
import org.playframework.cachecontrol.ResponseServeActions$ServeStale$;
import org.playframework.cachecontrol.ResponseServeActions$ServeStaleAndValidate$;
import org.playframework.cachecontrol.ResponseServeActions$Validate$;
import org.playframework.cachecontrol.ResponseServeActions$ValidateOrTimeout$;
import org.playframework.cachecontrol.ResponseServingCalculator$;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.StoredResponse;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;

public class ResponseServingCalculator {
    private final Cache cache;
    private final FreshnessCalculator freshnessCalculator;

    public ResponseServingCalculator(Cache cache) {
        this.cache = cache;
        this.freshnessCalculator = new FreshnessCalculator(cache);
    }

    public ResponseServeAction serveResponse(CacheRequest request, StoredResponse response, Seconds currentAge) {
        ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("serveResponse: response found for '" + request.method() + " " + request.uri() + "', age = " + currentAge.seconds());
        CacheRequest req = request;
        StoredResponse res = response;
        Option<ResponseServeActions.Validate> explicitValidate = this.noCacheFound(req, res);
        return (ResponseServeAction)explicitValidate.orElse(() -> this.serveResponse$$anonfun$1(currentAge, req, res)).orElse(() -> this.serveResponse$$anonfun$2(req, res)).orElse(() -> this.serveResponse$$anonfun$3(currentAge, req, res)).orElse(() -> this.serveResponse$$anonfun$4(currentAge, req, res)).getOrElse(() -> this.serveResponse$$anonfun$5(currentAge, req, res));
    }

    public ResponseServeActions.Validate allowStaleIfError(Seconds age, CacheRequest request, StoredResponse response) {
        ResponseServeActions.Validate v = ResponseServeActions$Validate$.MODULE$.apply("Response is stale, and stale response is not allowed", ResponseServeActions$Validate$.MODULE$.$lessinit$greater$default$2());
        Seconds freshnessLifetime = this.freshnessCalculator.calculateFreshnessLifetime(request, response);
        return (ResponseServeActions.Validate)CacheDirectives$.MODULE$.staleIfError(response.directives()).map((Function1 & Serializable)staleIfError -> {
            Seconds delta = staleIfError.delta();
            boolean serveStale = age.isLessThan(freshnessLifetime.plus(delta));
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("allowStaleIfError: delta = " + delta + ", staleIfError = " + serveStale);
            return v.copy(v.copy$default$1(), serveStale);
        }).getOrElse(() -> ResponseServingCalculator.allowStaleIfError$$anonfun$2(v));
    }

    public Option<ResponseServeActions.Validate> noCacheFound(CacheRequest request, StoredResponse response) {
        None$ none$;
        if (ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.isTraceEnabled()) {
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.trace("noCacheFound: request = " + request + ", response = " + response);
        }
        if (request.directives().exists((Function1 & Serializable)_$1 -> _$1 instanceof CacheDirectives.NoCache)) {
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.trace("noCacheFound: no-cache directive found!");
            String msg = "Request contains no-cache directive, validation required";
            none$ = Some$.MODULE$.apply((Object)ResponseServeActions$Validate$.MODULE$.apply(msg, ResponseServeActions$Validate$.MODULE$.$lessinit$greater$default$2()));
        } else if (request.directives().isEmpty()) {
            if (this.containsPragmaNoCache(request)) {
                String msg = "Request does not contain Cache-Control header found, but does contains no-cache Pragma header, validation required";
                none$ = Some$.MODULE$.apply((Object)ResponseServeActions$Validate$.MODULE$.apply(msg, ResponseServeActions$Validate$.MODULE$.$lessinit$greater$default$2()));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ requestContainsNoCache = none$;
        Option result = requestContainsNoCache.orElse(() -> ResponseServingCalculator.$anonfun$2(response));
        return result;
    }

    public boolean containsPragmaNoCache(CacheRequest request) {
        return request.headers().get((Object)HeaderNames$.MODULE$.Pragma()).exists((Function1 & Serializable)_$2 -> _$2.exists((Function1 & Serializable)_$3 -> _$3.contains("no-cache")));
    }

    public boolean headersFound(Seq<HeaderName> noCacheHeaders, StoredResponse response) {
        Set keySet = response.headers().keySet();
        return keySet.exists((Function1 & Serializable)elem -> noCacheHeaders.contains(elem));
    }

    public Option<ResponseServeActions.ServeFresh> isCachedResponseFresh(Seconds currentAge, CacheRequest request, StoredResponse response) {
        Seconds minFresh;
        Seconds maxAge;
        if (ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.isTraceEnabled()) {
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.trace("isCachedResponseFresh: request = " + request + ", response = " + response);
        }
        Seconds freshnessLifetime = this.freshnessCalculator.calculateFreshnessLifetime(request, response);
        ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isCachedResponseFresh: freshnessLifetime = " + freshnessLifetime + ", currentAge = " + currentAge);
        Option option = CacheDirectives$.MODULE$.maxAge(request.directives()).map((Function1 & Serializable)_$4 -> _$4.delta());
        if (option instanceof Some && currentAge.isGreaterThan(maxAge = (Seconds)((Some)option).value())) {
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isCachedResponseFresh: maxAge = " + maxAge + ", currentAge = " + currentAge + ", not fresh enough.");
            return None$.MODULE$;
        }
        Option other = option;
        Option option2 = CacheDirectives$.MODULE$.minFresh(request.directives()).map((Function1 & Serializable)_$5 -> _$5.delta());
        if (option2 instanceof Some && !freshnessLifetime.isLessThan(currentAge.plus(minFresh = (Seconds)((Some)option2).value()))) {
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isCachedResponseFresh: freshnessLifetime = " + freshnessLifetime + ", currentAge = " + currentAge + ", minFresh = " + minFresh);
            return Some$.MODULE$.apply((Object)ResponseServeActions$ServeFresh$.MODULE$.apply("Fresh response: minFresh = " + minFresh + ", freshnessLifetime = " + freshnessLifetime + ", currentAge = " + currentAge));
        }
        Option noMinFresh = option2;
        boolean responseIsFresh = freshnessLifetime.isGreaterThan(currentAge);
        ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isCachedResponseFresh: freshnessLifetime = " + freshnessLifetime + ", currentAge = " + currentAge);
        if (responseIsFresh) {
            Seconds secondsLeft = freshnessLifetime.minus(currentAge);
            String reason = "Fresh response: lifetime = " + freshnessLifetime + ", " + secondsLeft + " seconds left";
            return Some$.MODULE$.apply((Object)ResponseServeActions$ServeFresh$.MODULE$.apply(reason));
        }
        return None$.MODULE$;
    }

    public Option<ResponseServeActions.ServeStale> isStaleResponseAllowed(Seconds currentAge, CacheRequest request, StoredResponse response) {
        if (ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.isTraceEnabled()) {
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.trace("isStaleResponseAllowed: " + currentAge + ", request = " + request + ", response = " + response);
        }
        Option result = CacheDirectives$.MODULE$.maxStale(request.directives()).flatMap((Function1 & Serializable)maxStale -> {
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isStaleResponseAllowed: maxStale = " + maxStale);
            Option<Seconds> option = maxStale.delta();
            if (option instanceof Some) {
                Seconds maxStaleDelta = (Seconds)((Some)option).value();
                Seconds freshnessLifetime = this.freshnessCalculator.calculateFreshnessLifetime(request, response);
                Seconds totalLifetime = freshnessLifetime.plus(maxStaleDelta);
                ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isStaleResponseAllowed: freshnessLifetime = " + freshnessLifetime + ", maxAge = " + maxStaleDelta + ", totalLifetime = " + totalLifetime + ", currentAge = " + currentAge);
                if (totalLifetime.isGreaterThan(currentAge)) {
                    ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isStaleResponseAllowed: (" + freshnessLifetime + " + " + maxStaleDelta + ") > = " + currentAge + ", allowing serve stale");
                    String msg = "Request contains " + maxStale + ", current age = " + currentAge.seconds() + " which is inside range";
                    return Some$.MODULE$.apply((Object)ResponseServeActions$ServeStale$.MODULE$.apply(msg));
                }
                ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isStaleResponseAllowed: stale response outside of max-stale " + maxStale);
                return None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isStaleResponseAllowed: maxStale has no delta, stale response allowed");
                String msg = "Request contains no-args max-stale directive";
                return Some$.MODULE$.apply((Object)ResponseServeActions$ServeStale$.MODULE$.apply(msg));
            }
            throw new MatchError(option);
        }).orElse(ResponseServingCalculator::$anonfun$4);
        return result;
    }

    public Option<ResponseServeActions.ValidateOrTimeout> isStaleResponseExplicitlyProhibited(CacheRequest request, StoredResponse response) {
        if (ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.isTraceEnabled()) {
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.trace("isStaleResponseProhibited: request = " + request + ", response = " + response);
        }
        if (response.directives().contains((Object)CacheDirectives$MustRevalidate$.MODULE$)) {
            return Some$.MODULE$.apply((Object)ResponseServeActions$ValidateOrTimeout$.MODULE$.apply("Response is stale, response contains must-revalidate directive"));
        }
        if (this.cache.isShared()) {
            if (response.directives().contains((Object)CacheDirectives$ProxyRevalidate$.MODULE$)) {
                String msg = "Response is stale, response contains proxy-revalidate directive and cache is shared";
                return Some$.MODULE$.apply((Object)ResponseServeActions$ValidateOrTimeout$.MODULE$.apply(msg));
            }
            if (CacheDirectives$.MODULE$.sMaxAge(response.directives()).isDefined()) {
                String msg = "Response is stale, response contains s-maxage directive and cache is shared";
                return Some$.MODULE$.apply((Object)ResponseServeActions$ValidateOrTimeout$.MODULE$.apply(msg));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<ResponseServeActions.ServeStaleAndValidate> canServeStaleAndRevalidate(Seconds age, CacheRequest request, StoredResponse response) {
        if (ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.isTraceEnabled()) {
            ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.trace("canServeStaleAndRevalidate: response = " + response);
        }
        Seconds freshnessLifetime = this.freshnessCalculator.calculateFreshnessLifetime(request, response);
        return CacheDirectives$.MODULE$.staleWhileRevalidate(response.directives()).iterator().map((Function1 & Serializable)_$6 -> _$6.delta()).collectFirst((PartialFunction)new Serializable(age, freshnessLifetime){
            private final Seconds age$2;
            private final Seconds freshnessLifetime$2;
            {
                this.age$2 = age$3;
                this.freshnessLifetime$2 = freshnessLifetime$3;
            }

            public final boolean isDefinedAt(Seconds x) {
                Seconds seconds = x;
                Seconds delta = seconds;
                return this.age$2.isLessThan(this.freshnessLifetime$2.plus(delta));
            }

            public final Object applyOrElse(Seconds x, Function1 function1) {
                Seconds seconds = x;
                Seconds delta = seconds;
                if (this.age$2.isLessThan(this.freshnessLifetime$2.plus(delta))) {
                    ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("canServeStaleAndRevalidate: age = " + this.age$2 + ", delta = " + delta);
                    String reason = "Response contains stale-while-revalidate and is within delta range " + delta;
                    return ResponseServeActions$ServeStaleAndValidate$.MODULE$.apply(reason);
                }
                return function1.apply((Object)x);
            }
        });
    }

    private final Option serveResponse$$anonfun$1(Seconds currentAge$1, CacheRequest req$1, StoredResponse res$1) {
        Option<ResponseServeActions.ServeFresh> serveFresh = this.isCachedResponseFresh(currentAge$1, req$1, res$1);
        return serveFresh;
    }

    private final Option serveResponse$$anonfun$2(CacheRequest req$2, StoredResponse res$2) {
        Option<ResponseServeActions.ValidateOrTimeout> notAllowedStale = this.isStaleResponseExplicitlyProhibited(req$2, res$2);
        return notAllowedStale;
    }

    private final Option serveResponse$$anonfun$3(Seconds currentAge$2, CacheRequest req$3, StoredResponse res$3) {
        Option<ResponseServeActions.ServeStale> serveStale = this.isStaleResponseAllowed(currentAge$2, req$3, res$3);
        return serveStale;
    }

    private final Option serveResponse$$anonfun$4(Seconds currentAge$3, CacheRequest req$4, StoredResponse res$4) {
        Option<ResponseServeActions.ServeStaleAndValidate> serveStaleAndRevalidate = this.canServeStaleAndRevalidate(currentAge$3, req$4, res$4);
        return serveStaleAndRevalidate;
    }

    private final ResponseServeAction serveResponse$$anonfun$5(Seconds currentAge$4, CacheRequest req$5, StoredResponse res$5) {
        ResponseServeActions.Validate defaultValidation = this.allowStaleIfError(currentAge$4, req$5, res$5);
        return defaultValidation;
    }

    private static final ResponseServeActions.Validate allowStaleIfError$$anonfun$2(ResponseServeActions.Validate v$2) {
        return v$2;
    }

    private static final Option $anonfun$2(StoredResponse response$1) {
        return CacheDirectives$.MODULE$.noCache(response$1.directives()).flatMap((Function1 & Serializable)noCache -> {
            Option<Seq<String>> option = noCache.headerNames();
            if (option instanceof Some) {
                Seq headers = (Seq)((Some)option).value();
                ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("noCacheFound: no-cache response directive qualified with " + noCache.headerNames());
                return None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                String msg = "Response contains no-args no-cache directive";
                return Some$.MODULE$.apply((Object)ResponseServeActions$Validate$.MODULE$.apply(msg, ResponseServeActions$Validate$.MODULE$.$lessinit$greater$default$2()));
            }
            throw new MatchError(option);
        });
    }

    private static final Option $anonfun$4() {
        ResponseServingCalculator$.org$playframework$cachecontrol$ResponseServingCalculator$$$logger.debug("isStaleResponseAllowed: stale response not allowed");
        return None$.MODULE$;
    }
}

