/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Locale;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.Seconds$;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.PartialFunction;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class HttpDate$
implements Serializable {
    private static final ZoneId zone;
    private static final char EMPTY;
    private static final DateTimeFormatter imfFixDateFormat;
    private static final DateTimeFormatter asctimeFormat;
    public static final HttpDate$ MODULE$;

    private HttpDate$() {
    }

    static {
        MODULE$ = new HttpDate$();
        zone = ZoneId.of("GMT");
        EMPTY = (char)32;
        imfFixDateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.ENGLISH).withZone(MODULE$.zone());
        asctimeFormat = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy").withLocale(Locale.ENGLISH).withZone(MODULE$.zone());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpDate$.class);
    }

    public ZoneId zone() {
        return zone;
    }

    private DateTimeFormatter rfc850Format(String pattern) {
        return new DateTimeFormatterBuilder().appendPattern(pattern).appendLiteral(',').appendLiteral(EMPTY).appendPattern("dd-MMM-").appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, 1970).appendLiteral(EMPTY).appendPattern("HH:mm:ss").appendLiteral(EMPTY).appendLiteral("GMT").parseLenient().toFormatter(Locale.ENGLISH).withZone(this.zone()).withResolverStyle(ResolverStyle.LENIENT);
    }

    public String format(ZonedDateTime dateTime) {
        return imfFixDateFormat.format(dateTime);
    }

    public Seconds diff(ZonedDateTime start, ZonedDateTime end) {
        return Seconds$.MODULE$.between(start, end);
    }

    public ZonedDateTime now() {
        return ZonedDateTime.now(this.zone());
    }

    public ZonedDateTime parse(String dateString) {
        return (ZonedDateTime)Try$.MODULE$.apply(() -> HttpDate$.parse$$anonfun$1(dateString)).recover((PartialFunction)new Serializable(dateString){
            private final String dateString$2;
            {
                this.dateString$2 = dateString$4;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return HttpDate$.MODULE$.org$playframework$cachecontrol$HttpDate$$$parseRFC850(this.dateString$2);
            }
        }).recover((PartialFunction)new Serializable(dateString){
            private final String dateString$3;
            {
                this.dateString$3 = dateString$5;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return HttpDate$.MODULE$.org$playframework$cachecontrol$HttpDate$$$parseAscTime(this.dateString$3);
            }
        }).get();
    }

    private ZonedDateTime parseIMF(String dateString) {
        return ZonedDateTime.parse(dateString, imfFixDateFormat);
    }

    public ZonedDateTime org$playframework$cachecontrol$HttpDate$$$parseAscTime(String dateString) {
        return ZonedDateTime.parse(dateString, asctimeFormat);
    }

    public ZonedDateTime org$playframework$cachecontrol$HttpDate$$$parseRFC850(String dateString) {
        ZonedDateTime zonedDateTime;
        try {
            zonedDateTime = ZonedDateTime.parse(dateString, this.rfc850Format("EEE"));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                zonedDateTime = ZonedDateTime.parse(dateString, this.rfc850Format("EEEE"));
            }
            throw throwable;
        }
        return zonedDateTime;
    }

    public ZonedDateTime fromEpochSeconds(int timeSinceEpochInSeconds) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(Int$.MODULE$.int2long(timeSinceEpochInSeconds)), this.zone());
    }

    private static final ZonedDateTime parse$$anonfun$1(String dateString$1) {
        return MODULE$.parseIMF(dateString$1);
    }
}

