/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import java.time.ZonedDateTime;
import org.playframework.cachecontrol.CacheControlException;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.CurrentAgeCalculator$;
import org.playframework.cachecontrol.HeaderName;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.Seconds$;
import org.playframework.cachecontrol.StoredResponse;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;

public class CurrentAgeCalculator {
    public Seconds calculateCurrentAge(CacheRequest request, StoredResponse response, ZonedDateTime requestTime, ZonedDateTime responseTime) {
        return this.calculateCurrentAge(response.headers(), HttpDate$.MODULE$.now(), requestTime, responseTime);
    }

    public Seconds calculateCurrentAge(Map<HeaderName, Seq<String>> headers, ZonedDateTime now, ZonedDateTime requestTime, ZonedDateTime responseTime) {
        if (CurrentAgeCalculator$.org$playframework$cachecontrol$CurrentAgeCalculator$$$logger.isTraceEnabled()) {
            CurrentAgeCalculator$.org$playframework$cachecontrol$CurrentAgeCalculator$$$logger.trace("calculateCurrentAge(headers: " + headers + ", now: " + now + ", requestTime: " + requestTime + ", responseTime: " + responseTime + ")");
        }
        Seconds ageValue = this.calculateAgeValue(headers);
        ZonedDateTime dateValue = this.calculateDateValue(headers);
        Seconds apparentAge = responseTime.isAfter(dateValue) ? Seconds$.MODULE$.between(dateValue, responseTime) : Seconds$.MODULE$.ZERO();
        Seconds responseDelay = Seconds$.MODULE$.between(requestTime, responseTime);
        Seconds correctedAgeValue = ageValue.plus(responseDelay);
        long a = Math.max(apparentAge.seconds(), correctedAgeValue.seconds());
        Seconds correctedInitialAge = Seconds$.MODULE$.seconds(a);
        Seconds residentTime = Seconds$.MODULE$.between(responseTime, now);
        Seconds currentAge = correctedInitialAge.plus(residentTime);
        if (CurrentAgeCalculator$.org$playframework$cachecontrol$CurrentAgeCalculator$$$logger.isTraceEnabled()) {
            CurrentAgeCalculator$.org$playframework$cachecontrol$CurrentAgeCalculator$$$logger.trace("calculateCurrentAge: currentAge = " + currentAge);
        }
        return currentAge;
    }

    public Seconds calculateAgeValue(Map<HeaderName, Seq<String>> headers) {
        return (Seconds)headers.get((Object)HeaderNames$.MODULE$.Age()).flatMap((Function1 & Serializable)_$1 -> _$1.headOption()).map((Function1 & Serializable)age -> Seconds$.MODULE$.seconds(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(age)))).getOrElse(CurrentAgeCalculator::calculateAgeValue$$anonfun$3);
    }

    public ZonedDateTime calculateDateValue(Map<HeaderName, Seq<String>> headers) {
        Option result = headers.get((Object)HeaderNames$.MODULE$.Date()).flatMap((Function1 & Serializable)dateValues -> dateValues.headOption().map((Function1 & Serializable)firstDateValue -> HttpDate$.MODULE$.parse((String)firstDateValue)));
        return (ZonedDateTime)result.getOrElse(CurrentAgeCalculator::calculateDateValue$$anonfun$1);
    }

    private static final Seconds calculateAgeValue$$anonfun$3() {
        return Seconds$.MODULE$.ZERO();
    }

    private static final ZonedDateTime calculateDateValue$$anonfun$1() {
        String msg = "Date header is required for age calculation! (see RFC7231, 7.1.1.2)";
        throw new CacheControlException(msg);
    }
}

