/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import org.playframework.cachecontrol.Cache;
import org.playframework.cachecontrol.CacheDirectives;
import org.playframework.cachecontrol.CacheDirectives$;
import org.playframework.cachecontrol.CacheDirectives$MustRevalidate$;
import org.playframework.cachecontrol.CacheDirectives$NoStore$;
import org.playframework.cachecontrol.CacheDirectives$Public$;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.OriginResponse;
import org.playframework.cachecontrol.ResponseCachingAction;
import org.playframework.cachecontrol.ResponseCachingActions;
import org.playframework.cachecontrol.ResponseCachingCalculator$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\r\u001a\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006Y\u0001!\t!\f\u0005\u0006a\u0001!\t!\r\u0005\u0006\u007f\u0001!\t\u0002\u0011\u0005\u0006\u0007\u0002!\t\u0002\u0012\u0005\u0006#\u0002!\tB\u0015\u0005\u0006+\u0002!\tB\u0016\u0005\u00063\u0002!\tB\u0017\u0005\u0006;\u0002!\tB\u0018\u0005\u0006C\u0002!\tB\u0019\u0005\u0006_\u0002!\t\u0002\u001d\u0005\u0006e\u0002!\tb\u001d\u0005\u0006k\u0002!\tB\u001e\u0005\u0006q\u0002!\t\"\u001f\u0005\u0006w\u0002!\t\u0002 \u0005\u0006}\u0002!\tb \u0005\b\u0003\u0007\u0001A\u0011CA\u0003\u0011\u001d\tI\u0001\u0001C\t\u0003\u00179q!a\u0004\u001a\u0011\u0003\t\tB\u0002\u0004\u00193!\u0005\u00111\u0003\u0005\u0007YQ!\t!!\u0006\t\u0013\u0005]AC1A\u0005\n\u0005e\u0001\u0002CA\u0014)\u0001\u0006I!a\u0007\u00033I+7\u000f]8og\u0016\u001c\u0015m\u00195j]\u001e\u001c\u0015\r\\2vY\u0006$xN\u001d\u0006\u00035m\tAbY1dQ\u0016\u001cwN\u001c;s_2T!\u0001H\u000f\u0002\u001bAd\u0017-\u001f4sC6,wo\u001c:l\u0015\u0005q\u0012aA8sO\u000e\u00011C\u0001\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u0006)1-Y2iKB\u0011\u0011FK\u0007\u00023%\u00111&\u0007\u0002\u0006\u0007\u0006\u001c\u0007.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059z\u0003CA\u0015\u0001\u0011\u00159#\u00011\u0001)\u0003-I7oQ1dQ\u0016\f'\r\\3\u0015\u0007I*$\b\u0005\u0002*g%\u0011A'\u0007\u0002\u0016%\u0016\u001c\bo\u001c8tK\u000e\u000b7\r[5oO\u0006\u001bG/[8o\u0011\u001514\u00011\u00018\u0003\u001d\u0011X-];fgR\u0004\"!\u000b\u001d\n\u0005eJ\"\u0001D\"bG\",'+Z9vKN$\b\"B\u001e\u0004\u0001\u0004a\u0014\u0001\u0003:fgB|gn]3\u0011\u0005%j\u0014B\u0001 \u001a\u00059y%/[4j]J+7\u000f]8og\u0016\f1C]3ta>t7/Z%t\u0007\u0006\u001c\u0007.Z1cY\u0016$2AM!C\u0011\u00151D\u00011\u00018\u0011\u0015YD\u00011\u0001=\u0003Iqw\u000e^\"bG\",\u0017M\u00197f\u001b\u0016$\bn\u001c3\u0015\u0007\u0015{\u0005\u000bE\u0002#\r\"K!aR\u0012\u0003\r=\u0003H/[8o!\tIEJ\u0004\u0002*\u0015&\u00111*G\u0001\u0017%\u0016\u001c\bo\u001c8tK\u000e\u000b7\r[5oO\u0006\u001bG/[8og&\u0011QJ\u0014\u0002\u0013\t>tu\u000e^\"bG\",'+Z:q_:\u001cXM\u0003\u0002L3!)a'\u0002a\u0001o!)1(\u0002a\u0001y\u00051\u0012N\\3mS\u001eL'\r\\3SKN\u0004xN\\:f\u0007>$W\rF\u0002F'RCQA\u000e\u0004A\u0002]BQa\u000f\u0004A\u0002q\n\u0001dY8oi\u0006Lgn\u001d(p'R|'/\u001a#je\u0016\u001cG/\u001b<f)\r)u\u000b\u0017\u0005\u0006m\u001d\u0001\ra\u000e\u0005\u0006w\u001d\u0001\r\u0001P\u0001.G>tG/Y5ogB\u0013\u0018N^1uKJ+7\u000f]8og\u0016$\u0015N]3di&4X-\u00138TQ\u0006\u0014X\rZ\"bG\",GcA#\\9\")a\u0007\u0003a\u0001o!)1\b\u0003a\u0001y\u0005q3m\u001c8uC&t7/\u00138d_6\u0004\u0018\r^5cY\u0016\fU\u000f\u001e5pe&T\u0018\r^5p]&s7\u000b[1sK\u0012\u001c\u0015m\u00195f)\r)u\f\u0019\u0005\u0006m%\u0001\ra\u000e\u0005\u0006w%\u0001\r\u0001P\u0001\u0015SN\u001c\u0015m\u00195fC\ndW-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0005\r4\u0007C\u0001\u0012e\u0013\t)7EA\u0004C_>dW-\u00198\t\u000b\u001dT\u0001\u0019\u00015\u0002\u0013\u0015DH/\u001a8tS>t\u0007CA5m\u001d\tI#.\u0003\u0002l3\u0005y1)Y2iK\u0012K'/Z2uSZ,7/\u0003\u0002n]\n92)Y2iK\u0012K'/Z2uSZ,W\t\u001f;f]NLwN\u001c\u0006\u0003Wf\tA\u0004Z5sK\u000e$\u0018N^3BY2|wo]!vi\"|'/\u001b>bi&|g\u000e\u0006\u0002dc\")1h\u0003a\u0001y\u0005Y2m\u001c8uC&t7/Q;uQ>\u0014\u0018N_1uS>t\u0007*Z1eKJ$\"a\u0019;\t\u000bYb\u0001\u0019A\u001c\u0002+\r|g\u000e^1j]N,\u0005\u0010]5sKNDU-\u00193feR\u00111m\u001e\u0005\u0006w5\u0001\r\u0001P\u0001\u0018G>tG/Y5ogB+(\r\\5d\t&\u0014Xm\u0019;jm\u0016$\"a\u0019>\t\u000bmr\u0001\u0019\u0001\u001f\u0002/\r|g\u000e^1j]Nl\u0015\r_!hK\u0012K'/Z2uSZ,GCA2~\u0011\u0015Yt\u00021\u0001=\u0003a\u0019wN\u001c;bS:\u001c8+T1y\u0003\u001e,G)\u001b:fGRLg/\u001a\u000b\u0004G\u0006\u0005\u0001\"B\u001e\u0011\u0001\u0004a\u0014aH2p]R\f\u0017N\\:NkN$(+\u001a<bY&$\u0017\r^3ESJ,7\r^5wKR\u00191-a\u0002\t\u000bm\n\u0002\u0019\u0001\u001f\u00023\r|g\u000e^1j]N\u001c\u0015m\u00195bE2,W\t\u001f;f]NLwN\u001c\u000b\u0004G\u00065\u0001\"B\u001e\u0013\u0001\u0004a\u0014!\u0007*fgB|gn]3DC\u000eD\u0017N\\4DC2\u001cW\u000f\\1u_J\u0004\"!\u000b\u000b\u0014\u0005Q\tCCAA\t\u0003\u0019awnZ4feV\u0011\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\u000f\u0002\u000bMdg\r\u000e6\n\t\u0005\u0015\u0012q\u0004\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0001")
public class ResponseCachingCalculator {
    private final Cache cache;

    public ResponseCachingAction isCacheable(CacheRequest request, OriginResponse response) {
        if (ResponseCachingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseCachingCalculator$$logger().isTraceEnabled()) {
            ResponseCachingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseCachingCalculator$$logger().trace("isCacheable: request: " + request + ", response = " + response);
        }
        ResponseCachingAction result = (ResponseCachingAction)this.notCacheableMethod(request, response).orElse((Function0 & Serializable)() -> this.ineligibleResponseCode(request, response)).orElse((Function0 & Serializable)() -> this.containsNoStoreDirective(request, response)).orElse((Function0 & Serializable)() -> this.containsPrivateResponseDirectiveInSharedCache(request, response)).orElse((Function0 & Serializable)() -> this.containsIncompatibleAuthorizationInSharedCache(request, response)).getOrElse((Function0 & Serializable)() -> this.responseIsCacheable(request, response));
        ResponseCachingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseCachingCalculator$$logger().trace("isCacheable: result = " + result);
        return result;
    }

    public ResponseCachingAction responseIsCacheable(CacheRequest request, OriginResponse response) {
        if (ResponseCachingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseCachingCalculator$$logger().isTraceEnabled()) {
            ResponseCachingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseCachingCalculator$$logger().trace("responseIsCacheable: response = " + response);
        }
        if (this.containsExpiresHeader(response)) {
            return new ResponseCachingActions.DoCacheResponse("Response contains expires header");
        }
        if (this.containsMaxAgeDirective(response)) {
            return new ResponseCachingActions.DoCacheResponse("Response contains max-age response directive");
        }
        if (this.cache.isShared() && this.containsSMaxAgeDirective(response)) {
            return new ResponseCachingActions.DoCacheResponse("Response contains s-maxage and the cache is shared");
        }
        if (this.containsCachableExtension(response)) {
            return new ResponseCachingActions.DoCacheResponse("Response contains a cache control extension that allows it to be cached");
        }
        if (this.cache.isDefaultCacheable(response.status())) {
            return new ResponseCachingActions.DoCacheResponse("Response status code " + response.status() + " is cacheable by default");
        }
        if (this.containsPublicDirective(response)) {
            return new ResponseCachingActions.DoCacheResponse("Response contains public response directive");
        }
        return new ResponseCachingActions.DoNotCacheResponse("Response is not cacheable by default, and there are no explicit overrides");
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> notCacheableMethod(CacheRequest request, OriginResponse response) {
        if (this.cache.isCacheableMethod(request.method())) {
            return None$.MODULE$;
        }
        return new Some((Object)new ResponseCachingActions.DoNotCacheResponse("Request method " + request.method() + " is not cacheable"));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> ineligibleResponseCode(CacheRequest request, OriginResponse response) {
        int statusCode = response.status();
        if (this.cache.isUnderstoodStatusCode(statusCode)) {
            return None$.MODULE$;
        }
        return new Some((Object)new ResponseCachingActions.DoNotCacheResponse("Response code " + statusCode + " is not understood by the cache"));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsNoStoreDirective(CacheRequest request, OriginResponse response) {
        if (request.directives().contains((Object)CacheDirectives$NoStore$.MODULE$)) {
            return new Some((Object)new ResponseCachingActions.DoNotCacheResponse("Request Cache-Control header contains no-store cache directive"));
        }
        if (response.directives().contains((Object)CacheDirectives$NoStore$.MODULE$)) {
            return new Some((Object)new ResponseCachingActions.DoNotCacheResponse("Response Cache-Control header contains no-store cache directive"));
        }
        return None$.MODULE$;
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsPrivateResponseDirectiveInSharedCache(CacheRequest request, OriginResponse response) {
        if (this.cache.isShared()) {
            return CacheDirectives$.MODULE$.private(response.directives()).flatMap((Function1 & Serializable)privateDirective -> {
                if (privateDirective.headerNames().isDefined()) {
                    ResponseCachingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseCachingCalculator$$logger().debug("qualified private response directive found, returning None");
                    return None$.MODULE$;
                }
                return new Some((Object)new ResponseCachingActions.DoNotCacheResponse("Cache is shared, and private directive found in response"));
            });
        }
        return None$.MODULE$;
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsIncompatibleAuthorizationInSharedCache(CacheRequest request, OriginResponse response) {
        if (this.cache.isShared()) {
            if (this.containsAuthorizationHeader(request) && !this.directiveAllowsAuthorization(response)) {
                String msg = "Cache is shared, authorization header found, no cache directives allow authorization";
                return new Some((Object)new ResponseCachingActions.DoNotCacheResponse(msg));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public boolean isCacheableExtension(CacheDirectives.CacheDirectiveExtension extension) {
        return this.cache.isCacheableExtension(extension);
    }

    public boolean directiveAllowsAuthorization(OriginResponse response) {
        return this.containsMustRevalidateDirective(response) || this.containsPublicDirective(response) || this.containsSMaxAgeDirective(response);
    }

    public boolean containsAuthorizationHeader(CacheRequest request) {
        return request.headers().contains((Object)HeaderNames$.MODULE$.Authorization());
    }

    public boolean containsExpiresHeader(OriginResponse response) {
        return response.headers().contains((Object)HeaderNames$.MODULE$.Expires());
    }

    public boolean containsPublicDirective(OriginResponse response) {
        return response.directives().contains((Object)CacheDirectives$Public$.MODULE$);
    }

    public boolean containsMaxAgeDirective(OriginResponse response) {
        return CacheDirectives$.MODULE$.maxAge(response.directives()).isDefined();
    }

    public boolean containsSMaxAgeDirective(OriginResponse response) {
        return CacheDirectives$.MODULE$.sMaxAge(response.directives()).isDefined();
    }

    public boolean containsMustRevalidateDirective(OriginResponse response) {
        return response.directives().contains((Object)CacheDirectives$MustRevalidate$.MODULE$);
    }

    public boolean containsCachableExtension(OriginResponse response) {
        return CacheDirectives$.MODULE$.extensions(response.directives()).exists((Function1 & Serializable)extension -> BoxesRunTime.boxToBoolean((boolean)this.isCacheableExtension(extension)));
    }

    public ResponseCachingCalculator(Cache cache) {
        this.cache = cache;
    }
}

