/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Locale;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.Seconds$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class HttpDate$ {
    public static HttpDate$ MODULE$;
    private final ZoneId zone;
    private final char EMPTY;
    private final DateTimeFormatter imfFixDateFormat;
    private final DateTimeFormatter asctimeFormat;

    static {
        new HttpDate$();
    }

    public ZoneId zone() {
        return this.zone;
    }

    private char EMPTY() {
        return this.EMPTY;
    }

    private DateTimeFormatter imfFixDateFormat() {
        return this.imfFixDateFormat;
    }

    private DateTimeFormatter rfc850Format(String pattern) {
        return new DateTimeFormatterBuilder().appendPattern(pattern).appendLiteral(',').appendLiteral(this.EMPTY()).appendPattern("dd-MMM-").appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, 1970).appendLiteral(this.EMPTY()).appendPattern("HH:mm:ss").appendLiteral(this.EMPTY()).appendLiteral("GMT").parseLenient().toFormatter(Locale.ENGLISH).withZone(this.zone()).withResolverStyle(ResolverStyle.LENIENT);
    }

    private DateTimeFormatter asctimeFormat() {
        return this.asctimeFormat;
    }

    public String format(ZonedDateTime dateTime) {
        return this.imfFixDateFormat().format(dateTime);
    }

    public Seconds diff(ZonedDateTime start, ZonedDateTime end) {
        return Seconds$.MODULE$.between(start, end);
    }

    public ZonedDateTime now() {
        return ZonedDateTime.now(this.zone());
    }

    public ZonedDateTime parse(String dateString) {
        return (ZonedDateTime)Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> MODULE$.parseIMF(dateString)).recover((PartialFunction)new Serializable(dateString){
            public static final long serialVersionUID = 0L;
            private final String dateString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)HttpDate$.MODULE$.org$playframework$cachecontrol$HttpDate$$parseRFC850(this.dateString$1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.dateString$1 = dateString$1;
            }
        }).recover((PartialFunction)new Serializable(dateString){
            public static final long serialVersionUID = 0L;
            private final String dateString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                return (B1)HttpDate$.MODULE$.org$playframework$cachecontrol$HttpDate$$parseAscTime(this.dateString$1);
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                return true;
            }
            {
                this.dateString$1 = dateString$1;
            }
        }).get();
    }

    private ZonedDateTime parseIMF(String dateString) {
        return ZonedDateTime.parse(dateString, this.imfFixDateFormat());
    }

    public ZonedDateTime org$playframework$cachecontrol$HttpDate$$parseAscTime(String dateString) {
        return ZonedDateTime.parse(dateString, this.asctimeFormat());
    }

    public ZonedDateTime org$playframework$cachecontrol$HttpDate$$parseRFC850(String dateString) {
        ZonedDateTime zonedDateTime;
        try {
            zonedDateTime = ZonedDateTime.parse(dateString, this.rfc850Format("EEE"));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                zonedDateTime = ZonedDateTime.parse(dateString, this.rfc850Format("EEEE"));
            }
            throw throwable;
        }
        return zonedDateTime;
    }

    public ZonedDateTime fromEpochSeconds(int timeSinceEpochInSeconds) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timeSinceEpochInSeconds), this.zone());
    }

    private HttpDate$() {
        MODULE$ = this;
        this.zone = ZoneId.of("GMT");
        this.EMPTY = (char)32;
        this.imfFixDateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.ENGLISH).withZone(this.zone());
        this.asctimeFormat = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy").withLocale(Locale.ENGLISH).withZone(this.zone());
    }
}

