/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven.report.generator;

import java.util.Arrays;
import java.util.List;
import org.pitest.maven.report.ReportSourceLocator;
import org.pitest.maven.report.generator.HTMLReportGenerator;
import org.pitest.maven.report.generator.ReportGenerationContext;
import org.pitest.maven.report.generator.ReportGenerationResultEnum;
import org.pitest.maven.report.generator.ReportGenerationStrategy;
import org.pitest.maven.report.generator.XMLReportGenerator;
import org.pitest.util.PitError;

public class ReportGenerationManager {
    private final ReportSourceLocator reportLocator;
    private final List<ReportGenerationStrategy> reportGenerationStrategyList;

    public ReportGenerationManager() {
        this(new ReportSourceLocator(), Arrays.asList(new XMLReportGenerator(), new HTMLReportGenerator()));
    }

    public ReportGenerationManager(ReportSourceLocator reportLocator, List<ReportGenerationStrategy> reportGenerationStrategyList) {
        this.reportLocator = reportLocator;
        this.reportGenerationStrategyList = reportGenerationStrategyList;
    }

    public void generateSiteReport(ReportGenerationContext context) {
        boolean successfulExecution = false;
        context.setReportsDataDirectory(this.reportLocator.locate(context.getReportsDataDirectory(), context.getLogger()));
        context.getLogger().debug((CharSequence)"starting execution of report generators");
        context.getLogger().debug((CharSequence)("using report generation context: " + context));
        for (String dataFormat : context.getSourceDataFormats()) {
            context.getLogger().debug((CharSequence)("starting report generator for source data format [" + dataFormat + "]"));
            ReportGenerationResultEnum result = this.locateReportGenerationStrategy(dataFormat).generate(context);
            context.getLogger().debug((CharSequence)("result of report generator for source data format [" + dataFormat + "] was [" + result.toString() + "]"));
            if (result != ReportGenerationResultEnum.SUCCESS) continue;
            successfulExecution = true;
            break;
        }
        if (!successfulExecution) {
            throw new PitError("no report generators executed successfully");
        }
        context.getLogger().debug((CharSequence)"finished execution of report generators");
    }

    private ReportGenerationStrategy locateReportGenerationStrategy(String sourceDataFormat) {
        for (ReportGenerationStrategy strategy : this.reportGenerationStrategyList) {
            if (!sourceDataFormat.equalsIgnoreCase(strategy.getGeneratorDataFormat())) continue;
            return strategy;
        }
        throw new PitError("Could not locate report generator for data source [" + sourceDataFormat + "]");
    }
}

