/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.pitest.functional.FCollection;
import org.pitest.maven.AbstractPitMojo;
import org.pitest.maven.MojoToReportOptionsConverter;
import org.pitest.maven.PathToJavaClassConverter;
import org.pitest.maven.RunPitStrategy;
import org.pitest.maven.ScmStatus;
import org.pitest.maven.SurefireConfigConverter;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.tooling.CombinedStatistics;

@Mojo(name="scmMutationCoverage", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ScmMojo
extends AbstractPitMojo {
    private static final int NO_LIMIT = -1;
    @Component
    private ScmManager manager;
    @Parameter(property="include")
    private HashSet<String> include;
    @Parameter(property="analyseLastCommit", defaultValue="false")
    private boolean analyseLastCommit;
    @Parameter(property="originBranch")
    private String originBranch;
    @Parameter(property="destinationBranch", defaultValue="master")
    private String destinationBranch;
    @Parameter(property="connectionType", defaultValue="connection")
    private String connectionType;
    @Parameter(property="basedir", required=true)
    private File basedir;
    @Parameter(property="scmRootDir", defaultValue="${project.parent.basedir}")
    private File scmRootDir;

    public ScmMojo(RunPitStrategy executionStrategy, ScmManager manager, Predicate<Artifact> filter, PluginServices plugins, boolean analyseLastCommit, Predicate<MavenProject> nonEmptyProjectCheck, RepositorySystem repositorySystem) {
        super(executionStrategy, filter, plugins, nonEmptyProjectCheck, repositorySystem);
        this.manager = manager;
        this.analyseLastCommit = analyseLastCommit;
    }

    @Inject
    public ScmMojo(RepositorySystem repositorySystem) {
        super(repositorySystem);
    }

    @Override
    protected Optional<CombinedStatistics> analyse() throws MojoExecutionException {
        if (this.scmRootDir == null) {
            this.scmRootDir = this.findScmRootDir();
        }
        this.setTargetClasses(ScmMojo.makeConcreteList(this.findModifiedClassNames()));
        if (this.getTargetClasses().isEmpty()) {
            this.getLog().info((CharSequence)("No modified files found - nothing to mutation test, analyseLastCommit=" + this.analyseLastCommit));
            return Optional.empty();
        }
        this.logClassNames();
        this.defaultTargetTestsIfNoValueSet();
        ReportOptions data = new MojoToReportOptionsConverter(this, new SurefireConfigConverter(), this.getFilter()).convert();
        data.setFailWhenNoMutations(false);
        return Optional.ofNullable(this.getGoalStrategy().execute(this.detectBaseDir(), data, this.getPlugins(), new HashMap<String, String>()));
    }

    private void defaultTargetTestsIfNoValueSet() {
        if (this.getTargetTests() == null || this.getTargetTests().isEmpty()) {
            File tests = new File(this.getProject().getBuild().getTestOutputDirectory());
            this.setTargetTests(new ArrayList<String>(MojoToReportOptionsConverter.findOccupiedPackagesIn(tests)));
        }
    }

    private void logClassNames() {
        for (String each : this.getTargetClasses()) {
            this.getLog().info((CharSequence)("Will mutate changed class " + each));
        }
    }

    private List<String> findModifiedClassNames() throws MojoExecutionException {
        File sourceRoot = new File(this.getProject().getBuild().getSourceDirectory());
        Stream<String> modifiedPaths = this.findModifiedPaths().stream().map(this.pathByScmDir());
        return modifiedPaths.flatMap(new PathToJavaClassConverter(sourceRoot.getAbsolutePath())).collect(Collectors.toList());
    }

    private Function<String, String> pathByScmDir() {
        return a -> this.scmRoot().getAbsolutePath() + "/" + a;
    }

    private File findScmRootDir() {
        MavenProject rootProject = this.getProject();
        while (rootProject.hasParent() && rootProject.getParent().getBasedir() != null) {
            rootProject = rootProject.getParent();
        }
        return rootProject.getBasedir();
    }

    private Set<String> findModifiedPaths() throws MojoExecutionException {
        try {
            ScmRepository repository = this.manager.makeScmRepository(this.getSCMConnection());
            File scmRoot = this.scmRoot();
            this.getLog().info((CharSequence)("Scm root dir is " + scmRoot));
            Set<ScmFileStatus> statusToInclude = this.makeStatusSet();
            Set<String> modifiedPaths = this.analyseLastCommit ? this.lastCommitChanges(statusToInclude, repository, scmRoot) : (this.originBranch != null && this.destinationBranch != null ? this.changesBetweenBranchs(this.originBranch, this.destinationBranch, statusToInclude, repository, scmRoot) : this.localChanges(statusToInclude, repository, scmRoot));
            return modifiedPaths;
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Error while querying scm", (Exception)((Object)e));
        }
    }

    private Set<String> lastCommitChanges(Set<ScmFileStatus> statusToInclude, ScmRepository repository, File scmRoot) throws ScmException {
        ChangeLogScmRequest scmRequest = new ChangeLogScmRequest(repository, new ScmFileSet(scmRoot));
        scmRequest.setLimit(Integer.valueOf(1));
        return this.pathsAffectedByChange(scmRequest, statusToInclude, 1);
    }

    private Set<String> changesBetweenBranchs(String origine, String destination, Set<ScmFileStatus> statusToInclude, ScmRepository repository, File scmRoot) throws ScmException {
        ChangeLogScmRequest scmRequest = new ChangeLogScmRequest(repository, new ScmFileSet(scmRoot));
        scmRequest.setScmBranch(new ScmBranch(destination + ".." + origine));
        return this.pathsAffectedByChange(scmRequest, statusToInclude, -1);
    }

    private Set<String> pathsAffectedByChange(ChangeLogScmRequest scmRequest, Set<ScmFileStatus> statusToInclude, int limit) throws ScmException {
        LinkedHashSet<String> affected = new LinkedHashSet<String>();
        ChangeLogScmResult changeLogScmResult = this.manager.changeLog(scmRequest);
        if (changeLogScmResult.isSuccess()) {
            List<ChangeSet> changeSets = this.limit(changeLogScmResult.getChangeLog().getChangeSets(), limit);
            for (ChangeSet change : changeSets) {
                List files = change.getFiles();
                for (ChangeFile changeFile : files) {
                    if (!statusToInclude.contains(changeFile.getAction())) continue;
                    affected.add(changeFile.getName());
                }
            }
        }
        return affected;
    }

    private Set<String> localChanges(Set<ScmFileStatus> statusToInclude, ScmRepository repository, File scmRoot) throws ScmException {
        StatusScmResult status = this.manager.status(repository, new ScmFileSet(scmRoot));
        LinkedHashSet<String> affected = new LinkedHashSet<String>();
        for (ScmFile file : status.getChangedFiles()) {
            if (!statusToInclude.contains(file.getStatus())) continue;
            affected.add(file.getPath());
        }
        return affected;
    }

    private List<ChangeSet> limit(List<ChangeSet> changeSets, int limit) {
        if (limit < 0) {
            return changeSets;
        }
        return changeSets.subList(0, limit);
    }

    private Set<ScmFileStatus> makeStatusSet() {
        if (this.include == null || this.include.isEmpty()) {
            return new HashSet<ScmFileStatus>(Arrays.asList(ScmStatus.ADDED.getStatus(), ScmStatus.MODIFIED.getStatus()));
        }
        HashSet<ScmFileStatus> s = new HashSet<ScmFileStatus>();
        FCollection.mapTo(this.include, ScmMojo.stringToMavenScmStatus(), s);
        return s;
    }

    private static Function<String, ScmFileStatus> stringToMavenScmStatus() {
        return a -> ScmStatus.valueOf(a.toUpperCase()).getStatus();
    }

    private File scmRoot() {
        if (this.scmRootDir != null) {
            return this.scmRootDir;
        }
        return this.basedir;
    }

    private String getSCMConnection() throws MojoExecutionException {
        if (this.getProject().getScm() == null) {
            throw new MojoExecutionException("No SCM Connection configured.");
        }
        String scmConnection = this.getProject().getScm().getConnection();
        if ("connection".equalsIgnoreCase(this.connectionType) && StringUtils.isNotEmpty((String)scmConnection)) {
            return scmConnection;
        }
        String scmDeveloper = this.getProject().getScm().getDeveloperConnection();
        if ("developerconnection".equalsIgnoreCase(this.connectionType) && StringUtils.isNotEmpty((String)scmDeveloper)) {
            return scmDeveloper;
        }
        throw new MojoExecutionException("SCM Connection is not set.");
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public void setScmRootDir(File scmRootDir) {
        this.scmRootDir = scmRootDir;
    }

    private static ArrayList<String> makeConcreteList(List<String> list) {
        return new ArrayList<String>(list);
    }
}

