/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.build.TestInfoPriorisationComparator;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.engine.MutationDetails;

public class DefaultTestPrioritiser
implements TestPrioritiser {
    private static final int TIME_WEIGHTING_FOR_DIRECT_UNIT_TESTS = 1000;
    private final CoverageDatabase coverage;

    public DefaultTestPrioritiser(CoverageDatabase coverage) {
        this.coverage = coverage;
    }

    @Override
    public List<TestInfo> assignTests(MutationDetails mutation) {
        return this.prioritizeTests(mutation.getClassName(), this.pickTests(mutation));
    }

    private Collection<TestInfo> pickTests(MutationDetails mutation) {
        return mutation.getBlocks().stream().map(block -> new BlockLocation(mutation.getId().getLocation(), block.intValue())).flatMap(loc -> this.coverage.getTestsForBlockLocation((BlockLocation)loc).stream()).collect(Collectors.toCollection(() -> new HashSet()));
    }

    private List<TestInfo> prioritizeTests(ClassName clazz, Collection<TestInfo> testsForMutant) {
        ArrayList<TestInfo> sortedTis = new ArrayList<TestInfo>(testsForMutant);
        sortedTis.sort(new TestInfoPriorisationComparator(clazz, 1000));
        return sortedTis;
    }
}

