/*
 * Decompiled with CFR 0.152.
 */
package pitest.fasterxml.jackson.dataformat.xml;

import java.io.IOException;
import java.util.Collection;
import pitest.fasterxml.jackson.annotation.JsonTypeInfo;
import pitest.fasterxml.jackson.databind.DatabindContext;
import pitest.fasterxml.jackson.databind.JavaType;
import pitest.fasterxml.jackson.databind.cfg.MapperConfig;
import pitest.fasterxml.jackson.databind.jsontype.NamedType;
import pitest.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import pitest.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import pitest.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import pitest.fasterxml.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import pitest.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import pitest.fasterxml.jackson.databind.type.TypeFactory;
import pitest.fasterxml.jackson.dataformat.xml.util.StaxUtil;

public class XmlTypeResolverBuilder
extends StdTypeResolverBuilder {
    public XmlTypeResolverBuilder() {
    }

    public XmlTypeResolverBuilder(JsonTypeInfo.Value settings) {
        super(settings);
    }

    @Override
    protected String _propName(String propName, JsonTypeInfo.Id idType) {
        if (propName == null || propName.isEmpty()) {
            propName = StaxUtil.sanitizeXmlTypeName(idType.getDefaultPropertyName());
        } else if (propName.equals(idType.getDefaultPropertyName())) {
            propName = StaxUtil.sanitizeXmlTypeName(propName);
        }
        return propName;
    }

    @Override
    protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        switch (this._idType) {
            case CLASS: {
                return new XmlClassNameIdResolver(baseType, config.getTypeFactory(), this.subTypeValidator(config));
            }
            case MINIMAL_CLASS: {
                return new XmlMinimalClassNameIdResolver(baseType, config.getTypeFactory(), this.subTypeValidator(config));
            }
        }
        return super.idResolver(config, baseType, subtypeValidator, subtypes, forSer, forDeser);
    }

    protected static String encodeXmlClassName(String className) {
        int ix = className.lastIndexOf(36);
        if (ix >= 0) {
            StringBuilder sb = new StringBuilder(className);
            do {
                sb.replace(ix, ix + 1, "..");
            } while ((ix = className.lastIndexOf(36, ix - 1)) >= 0);
            className = sb.toString();
        }
        return className;
    }

    protected static String decodeXmlClassName(String className) {
        int ix = className.lastIndexOf("..");
        if (ix >= 0) {
            StringBuilder sb = new StringBuilder(className);
            do {
                sb.replace(ix, ix + 2, "$");
            } while ((ix = className.lastIndexOf("..", ix - 1)) >= 0);
            className = sb.toString();
        }
        return className;
    }

    protected static class XmlMinimalClassNameIdResolver
    extends MinimalClassNameIdResolver {
        private static final long serialVersionUID = 2L;

        public XmlMinimalClassNameIdResolver(JavaType baseType, TypeFactory typeFactory, PolymorphicTypeValidator ptv) {
            super(baseType, typeFactory, ptv);
        }

        @Override
        public String idFromValue(Object value) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(value));
        }

        @Override
        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            return super.typeFromId(context, XmlTypeResolverBuilder.decodeXmlClassName(id));
        }
    }

    protected static class XmlClassNameIdResolver
    extends ClassNameIdResolver {
        private static final long serialVersionUID = 2L;

        public XmlClassNameIdResolver(JavaType baseType, TypeFactory typeFactory, PolymorphicTypeValidator ptv) {
            super(baseType, typeFactory, ptv);
        }

        @Override
        public String idFromValue(Object value) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(value));
        }

        @Override
        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            return super.typeFromId(context, XmlTypeResolverBuilder.decodeXmlClassName(id));
        }
    }
}

