/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.webwork2;

import com.opensymphony.xwork.ObjectFactory;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.web.PicoServletContainerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoObjectFactory
extends ObjectFactory {
    private final Map<String, Class<?>> classCache = new HashMap();

    public boolean isNoArgConstructorRequired() {
        return false;
    }

    public Object buildBean(Class clazz, Map extraContext) throws Exception {
        return this.buildBean(clazz);
    }

    public Object buildBean(String className, Map extraContext) throws Exception {
        return this.buildBean(className);
    }

    public Class getClassInstance(String className) {
        return this.getActionClass(className);
    }

    public Object buildBean(Class<?> actionClass) throws Exception {
        MutablePicoContainer actionsContainer = ServletFilter.getRequestContainerForThread();
        Object action = actionsContainer.getComponent(actionClass);
        if (action == null) {
            DefaultPicoContainer child = new DefaultPicoContainer((PicoContainer)actionsContainer);
            child.addComponent(actionClass);
            action = child.getComponent(actionClass);
        }
        return action;
    }

    public Object buildBean(String className) throws Exception {
        return this.buildBean(this.getActionClass(className));
    }

    public Class<?> getActionClass(String className) throws PicoCompositionException {
        try {
            return this.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new PicoCompositionException("Action class '" + className + "' not found", (Throwable)e);
        }
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.classCache.containsKey(className)) {
            return this.classCache.get(className);
        }
        Class<?> result = Thread.currentThread().getContextClassLoader().loadClass(className);
        this.classCache.put(className, result);
        return result;
    }

    public static class ServletFilter
    extends PicoServletContainerFilter {
        private static ThreadLocal<MutablePicoContainer> currentRequestContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentSessionContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentAppContainer = new ThreadLocal();

        protected void setAppContainer(MutablePicoContainer container) {
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            currentSessionContainer.set(container);
        }

        protected static MutablePicoContainer getRequestContainerForThread() {
            return currentRequestContainer.get();
        }

        protected static MutablePicoContainer getSessionContainerForThread() {
            return currentSessionContainer.get();
        }

        protected static MutablePicoContainer getApplicationContainerForThread() {
            return currentAppContainer.get();
        }
    }
}

