/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.remoting;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.ISO8601DateConverter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.InjectionFactory;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.MethodInjection;
import org.picocontainer.injectors.ProviderAdapter;
import org.picocontainer.injectors.Reinjector;
import org.picocontainer.injectors.SingleMemberInjector;
import org.picocontainer.web.DELETE;
import org.picocontainer.web.GET;
import org.picocontainer.web.NONE;
import org.picocontainer.web.POST;
import org.picocontainer.web.PUT;
import org.picocontainer.web.PicoContainerWebException;
import org.picocontainer.web.remoting.MethodVisitor;
import org.picocontainer.web.remoting.PicoWebRemotingMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoWebRemoting {
    private final XStream xStream;
    private PicoWebRemotingMonitor monitor;
    private final String toStripFromUrls;
    private final String suffixToStrip;
    private final String scopesToPublish;
    private final boolean lowerCasePath;
    private final boolean useMethodNamePrefixesForVerbs;
    private Map<String, Object> paths = new HashMap<String, Object>();
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static final String POST = "POST";
    private static final String FALLBACK = "FALLBACK";

    public PicoWebRemoting(XStream xStream, String prefixToStripFromUrls, String suffixToStrip, String scopesToPublish, boolean lowerCasePath, boolean useMethodNamePrefixesForVerbs) {
        this.xStream = xStream;
        this.toStripFromUrls = prefixToStripFromUrls;
        this.suffixToStrip = suffixToStrip;
        this.scopesToPublish = scopesToPublish;
        this.lowerCasePath = lowerCasePath;
        this.useMethodNamePrefixesForVerbs = useMethodNamePrefixesForVerbs;
        this.xStream.registerConverter((SingleValueConverter)new ISO8601DateConverter());
    }

    public Map<String, Object> getPaths() {
        return this.paths;
    }

    public void setMonitor(PicoWebRemotingMonitor monitor) {
        this.monitor = monitor;
    }

    protected String processRequest(String pathInfo, PicoContainer reqContainer, String httpMethod) throws IOException {
        try {
            Object node;
            String path = pathInfo.substring(1);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            path = this.toStripFromUrls + path;
            if (this.suffixToStrip != null && path.endsWith(this.suffixToStrip)) {
                path = path.substring(0, path.indexOf(this.suffixToStrip));
            }
            if ((node = this.getNode(reqContainer, httpMethod, path)) instanceof Directories) {
                Directories directories = (Directories)node;
                return this.xStream.toXML((Object)directories.toArray()) + "\n";
            }
            if (node instanceof WebMethods) {
                WebMethods methods = (WebMethods)node;
                return this.xStream.toXML((Object)methods.keySet().toArray()) + "\n";
            }
            if (node != null && this.isComposite(node)) {
                return this.xStream.toXML(node) + "\n";
            }
            if (node != null) {
                return node != null ? this.xStream.toXML(node) + "\n" : null;
            }
            throw this.makeNothingMatchingException();
        }
        catch (SingleMemberInjector.ParameterCannotBeNullException e) {
            return this.errorResult(this.monitor.nullParameterForMethodInvocation(e.getParameterName()));
        }
        catch (PicoCompositionException e) {
            return this.errorResult(this.monitor.picoCompositionExceptionForMethodInvocation(e));
        }
        catch (RuntimeException e) {
            Object o = this.monitor.runtimeExceptionForMethodInvocation(e);
            return this.errorResult(o);
        }
    }

    private RuntimeException makeNothingMatchingException() {
        return new PicoContainerWebException("Nothing matches the path requested");
    }

    private Object getNode(PicoContainer reqContainer, String httpMethod, String path) throws IOException {
        Object node = this.paths.get(path);
        if (node == null) {
            int ix = path.lastIndexOf(47);
            if (ix > 0) {
                String methodName = path.substring(ix + 1);
                Object node2 = this.paths.get(path = path.substring(0, ix));
                if (node2 instanceof WebMethods) {
                    node = this.processWebMethodRequest(reqContainer, httpMethod, methodName, node2);
                }
            } else {
                node = null;
            }
        }
        return node;
    }

    private Object processWebMethodRequest(PicoContainer reqContainer, String verb, String methodName, Object node2) throws IOException {
        WebMethods methods = (WebMethods)node2;
        if (!methods.containsKey(methodName)) {
            throw this.makeNothingMatchingException();
        }
        HashMap methodz = (HashMap)methods.get(methodName);
        Method method = null;
        if (this.useMethodNamePrefixesForVerbs) {
            method = (Method)methodz.get(verb);
        }
        if (method == null) {
            method = (Method)methodz.get(FALLBACK);
        }
        if (method == null) {
            throw new PicoContainerWebException("method not allowed for " + verb);
        }
        return this.reinject(methodName, method, methods.getComponent(), reqContainer);
    }

    private boolean delete(Method method) {
        return method.getAnnotation(DELETE.class) != null;
    }

    private boolean put(Method method) {
        return method.getAnnotation(PUT.class) != null;
    }

    private boolean get(Method method) {
        return method.getAnnotation(GET.class) != null;
    }

    private boolean post(Method method) {
        return method.getAnnotation(POST.class) != null;
    }

    protected void publishAdapters(Collection<ComponentAdapter<?>> adapters, String scope) {
        if (this.scopesToPublish == null || this.scopesToPublish.contains(scope)) {
            for (ComponentAdapter<?> ca : adapters) {
                Object key = ca.getComponentKey();
                if (!this.notAProvider(ca) || !this.notServletMechanics(key) || !this.keyIsAType(key)) continue;
                this.publishAdapter((Class)key);
            }
        }
    }

    private boolean notAProvider(ComponentAdapter<?> ca) {
        return ca.findAdapterOfType(ProviderAdapter.class) == null;
    }

    private boolean keyIsAType(Object key) {
        return key instanceof Class;
    }

    protected boolean notServletMechanics(Object key) {
        return key != HttpSession.class && key != HttpServletRequest.class && key != HttpServletResponse.class;
    }

    private void determineEligibleMethods(Class<?> component, WebMethods webMethods) {
        Method[] methods;
        for (Method method : methods = component.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getAnnotation(NONE.class) != null) continue;
            String webMethodName = this.getMethodName(method);
            String webVerb = this.getVerbName(method);
            HashMap<String, Method> methodz = (HashMap<String, Method>)webMethods.get(webMethodName);
            if (methodz == null) {
                methodz = new HashMap<String, Method>();
                webMethods.put(webMethodName, methodz);
            }
            if (this.post(method)) {
                methodz.put(POST, method);
            }
            if (this.get(method)) {
                methodz.put(GET, method);
            }
            if (this.delete(method)) {
                methodz.put(DELETE, method);
            }
            if (this.put(method)) {
                methodz.put(PUT, method);
            }
            methodz.put(webVerb, method);
        }
        Class<?> superClass = component.getSuperclass();
        if (superClass != Object.class) {
            this.determineEligibleMethods(superClass, webMethods);
        }
    }

    private String getMethodName(Method method) {
        String name = method.getName();
        if (!this.useMethodNamePrefixesForVerbs) {
            return name;
        }
        if (this.prefixFolledByUpperChar(name, "get")) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        if (this.prefixFolledByUpperChar(name, "put")) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        if (this.prefixFolledByUpperChar(name, "delete")) {
            return name.substring(6, 7).toLowerCase() + name.substring(7);
        }
        if (this.prefixFolledByUpperChar(name, "post")) {
            return name.substring(4, 5).toLowerCase() + name.substring(5);
        }
        return name;
    }

    private String getVerbName(Method method) {
        if (!this.useMethodNamePrefixesForVerbs) {
            return FALLBACK;
        }
        String name = method.getName();
        if (this.prefixFolledByUpperChar(name, "get")) {
            return GET;
        }
        if (this.prefixFolledByUpperChar(name, "put")) {
            return PUT;
        }
        if (this.prefixFolledByUpperChar(name, "delete")) {
            return DELETE;
        }
        if (this.prefixFolledByUpperChar(name, "post")) {
            return POST;
        }
        return FALLBACK;
    }

    private boolean prefixFolledByUpperChar(String name, String prefix) {
        return name.startsWith(prefix) && name.length() > prefix.length() && Character.isUpperCase(name.charAt(prefix.length()));
    }

    private void publishAdapter(Class<?> key) {
        String path = this.getClassName(key).replace('.', '/');
        if (this.toStripFromUrls != "" || path.startsWith(this.toStripFromUrls)) {
            this.paths.put(path, key);
            this.directorize(path, key);
            this.directorize(path);
        }
    }

    private String getClassName(Class<?> key) {
        String name = key.getName();
        if (this.lowerCasePath) {
            return name.toLowerCase();
        }
        return name;
    }

    protected void directorize(String path, Class<?> comp) {
        WebMethods webMethods = new WebMethods(comp);
        this.paths.put(path, webMethods);
        this.determineEligibleMethods(comp, webMethods);
    }

    private String errorResult(Object errorResult) {
        return this.xStream.toXML(errorResult) + "\n";
    }

    private boolean isComposite(Object node) {
        return !node.getClass().isPrimitive() && !(node instanceof Boolean) && !(node instanceof Long) && !(node instanceof Double) && !(node instanceof Short) && !(node instanceof Byte) && !(node instanceof Integer) && !(node instanceof String) && !(node instanceof Float) && !(node instanceof Character);
    }

    private Object reinject(String methodName, Method method, Class<?> component, PicoContainer reqContainer) throws IOException {
        MethodInjection methodInjection = new MethodInjection(method);
        Reinjector reinjector = new Reinjector(reqContainer);
        Properties props = (Properties)Characteristics.USE_NAMES.clone();
        Object inst = reqContainer.getComponent(component);
        Object rv = reinjector.reinject(component, component, inst, props, (InjectionFactory)methodInjection);
        if (method.getReturnType() == Void.TYPE) {
            return "OK";
        }
        return rv;
    }

    protected void directorize(String path) {
        int lastSlashIx = path.lastIndexOf("/");
        if (lastSlashIx != -1) {
            String dir = path.substring(0, lastSlashIx);
            String file = path.substring(lastSlashIx + 1);
            Set dirs = (Set)this.paths.get(dir);
            if (dirs == null) {
                dirs = new Directories();
                this.paths.put(dir, dirs);
            }
            dirs.add(file);
            this.directorize(dir);
        } else {
            Set dirs = (Set)this.paths.get("/");
            if (dirs == null) {
                dirs = new Directories();
                this.paths.put("", dirs);
            }
            dirs.add(path);
        }
    }

    public void visitClass(String clazz, MutablePicoContainer mutablePicoContainer, MethodVisitor mapv) throws IOException {
        String s = this.toStripFromUrls + clazz;
        Object node = this.paths.get(s);
        if (node instanceof WebMethods) {
            WebMethods wm = (WebMethods)node;
            Class<?> x = wm.getComponent();
            Class<?> y = x.getSuperclass();
            if (y != null) {
                String s1 = y.getName().replace(".", "/");
                if (s1.startsWith(this.toStripFromUrls)) {
                    mapv.superClass(s1.substring(this.toStripFromUrls.length()));
                } else {
                    mapv.superClass(s1);
                }
            }
            Set keys = wm.keySet();
            for (Object o : keys) {
                String methodName = o.toString();
                HashMap foo = (HashMap)wm.get(methodName);
                Method m = (Method)foo.get(GET);
                if (m == null) {
                    m = (Method)foo.get(FALLBACK);
                }
                mapv.method(methodName, m);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WebMethods
    extends HashMap<String, HashMap<String, Method>> {
        private final Class<?> component;

        public WebMethods(Class<?> component) {
            this.component = component;
        }

        public Class<?> getComponent() {
            return this.component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Directories
    extends HashSet<String> {
        protected Directories() {
        }
    }
}

