/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.remoting;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.web.PicoServletContainerFilter;
import org.picocontainer.web.remoting.MethodVisitor;
import org.picocontainer.web.remoting.NullPicoWebRemotingMonitor;
import org.picocontainer.web.remoting.PicoWebRemoting;
import org.picocontainer.web.remoting.PicoWebRemotingMonitor;
import org.picocontainer.web.struts.PicoActionFactory;
import org.picocontainer.web.struts2.PicoObjectFactory;
import org.picocontainer.web.webwork.PicoActionFactory;
import org.picocontainer.web.webwork2.PicoObjectFactory;

public abstract class AbstractPicoWebRemotingServlet
extends HttpServlet {
    private XStream xstream;
    private PicoWebRemoting pwr;
    private String mimeType = "text/plain";
    private PicoWebRemotingMonitor monitor;
    private static final String APPLICATION_SCOPE = "application";
    private static final String SESSION_SCOPE = "session";
    private static final String REQUEST_SCOPE = "request";
    private static final String SCOPES_TO_PUBLISH = "scopes_to_publish";
    private static final String PACKAGE_PREFIX_TO_STRIP = "package_prefix_to_strip";
    private static final String SUFFIX_TO_STRIP = "suffix_to_strip";
    private static final String MIME_TYPE = "mime_type";
    private static final String LOWER_CASE_PATH = "lower_case_path";
    private static final String USE_METHOD_NAME_PREFIXES_FOR_VERBS = "use_method_name_prefixes_for_verbs";
    private static ThreadLocal<MutablePicoContainer> currentRequestContainer = new ThreadLocal();
    private static ThreadLocal<MutablePicoContainer> currentSessionContainer = new ThreadLocal();
    private static ThreadLocal<MutablePicoContainer> currentAppContainer = new ThreadLocal();
    private boolean initialized;

    protected abstract XStream createXStream();

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.initialized) {
            this.publishAdapters();
            this.initialized = true;
        }
        this.respond(req, resp, req.getPathInfo());
    }

    protected void respond(HttpServletRequest req, HttpServletResponse resp, String pathInfo) throws IOException {
        resp.setContentType(this.mimeType);
        String result = this.pwr.processRequest(pathInfo, (PicoContainer)currentRequestContainer.get(), req.getMethod());
        ServletOutputStream outputStream = resp.getOutputStream();
        if (result != null) {
            outputStream.print(result);
        } else {
            resp.sendError(400, "Nothing is mapped to this URL, try removing the last term for directory list.");
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        String lowerCasePathStr;
        String mimeTypeFromConfig;
        this.xstream = this.createXStream();
        String packagePrefixToStrip = servletConfig.getInitParameter(PACKAGE_PREFIX_TO_STRIP);
        String prefixToStripFromUrls = packagePrefixToStrip == null ? "" : packagePrefixToStrip.replace('.', '/') + "/";
        String suffixToStrip = servletConfig.getInitParameter(SUFFIX_TO_STRIP);
        String scopesToPublish = servletConfig.getInitParameter(SCOPES_TO_PUBLISH);
        if (scopesToPublish == null) {
            scopesToPublish = "";
        }
        if ((mimeTypeFromConfig = servletConfig.getInitParameter(MIME_TYPE)) != null) {
            this.mimeType = mimeTypeFromConfig;
        }
        boolean lowerCasePath = (lowerCasePathStr = servletConfig.getInitParameter(LOWER_CASE_PATH)) == null ? false : lowerCasePathStr.toLowerCase().equals(Boolean.TRUE.toString());
        String useMethodNamePrefixesForVerbsStr = servletConfig.getInitParameter(USE_METHOD_NAME_PREFIXES_FOR_VERBS);
        boolean useMethodNamePrefixesForVerbs = useMethodNamePrefixesForVerbsStr == null ? true : lowerCasePathStr.toLowerCase().equals(Boolean.TRUE.toString());
        super.init(servletConfig);
        this.pwr = new PicoWebRemoting(this.xstream, prefixToStripFromUrls, suffixToStrip, scopesToPublish, lowerCasePath, useMethodNamePrefixesForVerbs);
    }

    private void publishAdapters() {
        this.pwr.publishAdapters(currentRequestContainer.get().getComponentAdapters(), REQUEST_SCOPE);
        this.pwr.publishAdapters(currentSessionContainer.get().getComponentAdapters(), SESSION_SCOPE);
        this.pwr.publishAdapters(currentAppContainer.get().getComponentAdapters(), APPLICATION_SCOPE);
        this.monitor = (PicoWebRemotingMonitor)currentAppContainer.get().getComponent(PicoWebRemotingMonitor.class);
        if (this.monitor == null) {
            this.monitor = new NullPicoWebRemotingMonitor();
        }
        this.pwr.setMonitor(this.monitor);
    }

    protected void visitClass(String clazz, MethodVisitor mapv) throws IOException {
        this.pwr.visitClass(clazz, currentRequestContainer.get(), mapv);
    }

    public static class WebWork2ServletFilter
    extends PicoObjectFactory.ServletFilter {
        protected void setAppContainer(MutablePicoContainer container) {
            super.setAppContainer(container);
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            super.setRequestContainer(container);
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            super.setSessionContainer(container);
            currentSessionContainer.set(container);
        }
    }

    public static class WebWork1ServletFilter
    extends PicoActionFactory.ServletFilter {
        protected void setAppContainer(MutablePicoContainer container) {
            super.setAppContainer(container);
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            super.setRequestContainer(container);
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            super.setSessionContainer(container);
            currentSessionContainer.set(container);
        }
    }

    public static class Struts2ServletFilter
    extends PicoObjectFactory.ServletFilter {
        protected void setAppContainer(MutablePicoContainer container) {
            super.setAppContainer(container);
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            super.setRequestContainer(container);
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            super.setSessionContainer(container);
            currentSessionContainer.set(container);
        }
    }

    public static class Struts1ServletFilter
    extends PicoActionFactory.ServletFilter {
        protected void setAppContainer(MutablePicoContainer container) {
            super.setAppContainer(container);
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            super.setRequestContainer(container);
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            super.setSessionContainer(container);
            currentSessionContainer.set(container);
        }
    }

    public static class ServletFilter
    extends PicoServletContainerFilter {
        protected void setAppContainer(MutablePicoContainer container) {
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            currentSessionContainer.set(container);
        }
    }
}

