/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.remoting;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.ISO8601DateConverter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.InjectionFactory;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.MethodInjection;
import org.picocontainer.injectors.ProviderAdapter;
import org.picocontainer.injectors.Reinjector;
import org.picocontainer.injectors.SingleMemberInjector;
import org.picocontainer.web.DELETE;
import org.picocontainer.web.GET;
import org.picocontainer.web.NONE;
import org.picocontainer.web.POST;
import org.picocontainer.web.PUT;
import org.picocontainer.web.PicoContainerWebException;
import org.picocontainer.web.remoting.PicoWebRemotingMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoWebRemoting {
    private final XStream xStream;
    private PicoWebRemotingMonitor monitor;
    private final String toStripFromUrls;
    private final String suffixToStrip;
    private final String scopesToPublish;
    private final boolean lowerCasePath;
    private Map<String, Object> paths = new HashMap<String, Object>();

    public PicoWebRemoting(XStream xStream, String prefixToStripFromUrls, String suffixToStrip, String scopesToPublish, boolean lowerCasePath) {
        this.xStream = xStream;
        this.toStripFromUrls = prefixToStripFromUrls;
        this.suffixToStrip = suffixToStrip;
        this.scopesToPublish = scopesToPublish;
        this.lowerCasePath = lowerCasePath;
        this.xStream.registerConverter((SingleValueConverter)new ISO8601DateConverter());
    }

    public Map<String, Object> getPaths() {
        return this.paths;
    }

    public void setMonitor(PicoWebRemotingMonitor monitor) {
        this.monitor = monitor;
    }

    protected String processRequest(String pathInfo, PicoContainer reqContainer, String httpMethod) throws IOException {
        try {
            Object node;
            String path = pathInfo.substring(1);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            path = this.toStripFromUrls + path;
            if (this.suffixToStrip != null && path.endsWith(this.suffixToStrip)) {
                path = path.substring(0, path.indexOf(this.suffixToStrip));
            }
            if ((node = this.getNode(reqContainer, httpMethod, path)) instanceof Directories) {
                Directories directories = (Directories)node;
                return this.xStream.toXML((Object)directories.toArray()) + "\n";
            }
            if (node instanceof WebMethods) {
                WebMethods methods = (WebMethods)node;
                return this.xStream.toXML((Object)methods.keySet().toArray()) + "\n";
            }
            if (node != null && this.isComposite(node)) {
                return this.xStream.toXML(node) + "\n";
            }
            if (node != null) {
                return node != null ? this.xStream.toXML(node) + "\n" : null;
            }
            throw this.makeNothingMatchingException();
        }
        catch (SingleMemberInjector.ParameterCannotBeNullException e) {
            return this.errorResult(this.monitor.nullParameterForMethodInvocation(e.getParameterName()));
        }
        catch (PicoCompositionException e) {
            return this.errorResult(this.monitor.picoCompositionExceptionForMethodInvocation(e));
        }
        catch (RuntimeException e) {
            return this.errorResult(this.monitor.runtimeExceptionForMethodInvocation(e));
        }
    }

    private RuntimeException makeNothingMatchingException() {
        return new PicoContainerWebException("Nothing matches the path requested");
    }

    private Object getNode(PicoContainer reqContainer, String httpMethod, String path) throws IOException {
        Object node = this.paths.get(path);
        if (node == null) {
            int ix = path.lastIndexOf(47);
            if (ix > 0) {
                String methodName = path.substring(ix + 1);
                Object node2 = this.paths.get(path = path.substring(0, ix));
                if (node2 instanceof WebMethods) {
                    node = this.processWebMethodRequest(reqContainer, httpMethod, methodName, node2);
                }
            } else {
                node = null;
            }
        }
        return node;
    }

    private Object processWebMethodRequest(PicoContainer reqContainer, String verb, String methodName, Object node2) throws IOException {
        WebMethods methods = (WebMethods)node2;
        if (!methods.containsKey(methodName)) {
            throw this.makeNothingMatchingException();
        }
        Method method = (Method)methods.get(methodName);
        String verbs = this.post(method) + this.get(method) + this.put(method) + this.delete(method);
        if (!verbs.equals("") && !verbs.contains(verb)) {
            throw new PicoContainerWebException("method not allowed for " + verb);
        }
        return this.reinject(methodName, method, methods.getComponent(), reqContainer);
    }

    private String delete(Method method) {
        return method.getAnnotation(DELETE.class) != null ? "DELETE," : "";
    }

    private String put(Method method) {
        return method.getAnnotation(PUT.class) != null ? "PUT," : "";
    }

    private String get(Method method) {
        return method.getAnnotation(GET.class) != null ? "GET," : "";
    }

    private String post(Method method) {
        return method.getAnnotation(POST.class) != null ? "POST," : "";
    }

    protected void publishAdapters(Collection<ComponentAdapter<?>> adapters, String scope) {
        if (this.scopesToPublish == null || this.scopesToPublish.contains(scope)) {
            for (ComponentAdapter<?> ca : adapters) {
                Object key = ca.getComponentKey();
                if (!this.notAProvider(ca) || !this.notServletMechanics(key) || !this.keyIsAType(key)) continue;
                this.publishAdapter((Class)key);
            }
        }
    }

    private boolean notAProvider(ComponentAdapter<?> ca) {
        return ca.findAdapterOfType(ProviderAdapter.class) == null;
    }

    private boolean keyIsAType(Object key) {
        return key instanceof Class;
    }

    protected boolean notServletMechanics(Object key) {
        return key != HttpSession.class && key != HttpServletRequest.class && key != HttpServletResponse.class;
    }

    private void determineEligibleMethods(Class<?> component, WebMethods webMethods) {
        Method[] methods;
        for (Method method : methods = component.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getAnnotation(NONE.class) != null) continue;
            webMethods.put(method.getName(), method);
        }
        Class<?> superClass = component.getSuperclass();
        if (superClass != Object.class) {
            this.determineEligibleMethods(superClass, webMethods);
        }
    }

    private void publishAdapter(Class<?> key) {
        String path = this.getClassName(key).replace('.', '/');
        if (this.toStripFromUrls != "" || path.startsWith(this.toStripFromUrls)) {
            this.paths.put(path, key);
            this.directorize(path, key);
            this.directorize(path);
        }
    }

    private String getClassName(Class<?> key) {
        String name = key.getName();
        if (this.lowerCasePath) {
            return name.toLowerCase();
        }
        return name;
    }

    protected void directorize(String path, Class<?> comp) {
        WebMethods webMethods = new WebMethods(comp);
        this.paths.put(path, webMethods);
        this.determineEligibleMethods(comp, webMethods);
    }

    private String errorResult(Object errorResult) {
        return this.xStream.toXML(errorResult) + "\n";
    }

    private boolean isComposite(Object node) {
        return !node.getClass().isPrimitive() && !(node instanceof Boolean) && !(node instanceof Long) && !(node instanceof Double) && !(node instanceof Short) && !(node instanceof Byte) && !(node instanceof Integer) && !(node instanceof String) && !(node instanceof Float) && !(node instanceof Character);
    }

    private Object reinject(String methodName, Method method, Class<?> component, PicoContainer reqContainer) throws IOException {
        MethodInjection methodInjection = new MethodInjection(method);
        Reinjector reinjector = new Reinjector(reqContainer);
        Properties props = (Properties)Characteristics.USE_NAMES.clone();
        Object inst = reqContainer.getComponent(component);
        Object rv = reinjector.reinject(component, component, inst, props, (InjectionFactory)methodInjection);
        if (method.getReturnType() == Void.TYPE) {
            return "OK";
        }
        return rv;
    }

    protected void directorize(String path) {
        int lastSlashIx = path.lastIndexOf("/");
        if (lastSlashIx != -1) {
            String dir = path.substring(0, lastSlashIx);
            String file = path.substring(lastSlashIx + 1);
            Set dirs = (Set)this.paths.get(dir);
            if (dirs == null) {
                dirs = new Directories();
                this.paths.put(dir, dirs);
            }
            dirs.add(file);
            this.directorize(dir);
        } else {
            Set dirs = (Set)this.paths.get("/");
            if (dirs == null) {
                dirs = new Directories();
                this.paths.put("", dirs);
            }
            dirs.add(path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WebMethods
    extends HashMap<String, Method> {
        private final Class<?> component;

        public WebMethods(Class<?> component) {
            this.component = component;
        }

        public Class<?> getComponent() {
            return this.component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Directories
    extends HashSet<String> {
        protected Directories() {
        }
    }
}

