/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.rhino;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DefiningClassLoader;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.picocontainer.PicoContainer;
import org.picocontainer.script.LifecycleMode;
import org.picocontainer.script.ScriptedContainerBuilder;
import org.picocontainer.script.ScriptedPicoContainerMarkupException;

public class JavascriptContainerBuilder
extends ScriptedContainerBuilder {
    public JavascriptContainerBuilder(Reader script, ClassLoader classLoader) {
        this(script, classLoader, LifecycleMode.AUTO_LIFECYCLE);
    }

    public JavascriptContainerBuilder(Reader script, ClassLoader classLoader, LifecycleMode lifecycleMode) {
        super(script, classLoader, lifecycleMode);
    }

    public JavascriptContainerBuilder(URL script, ClassLoader classLoader) {
        this(script, classLoader, LifecycleMode.AUTO_LIFECYCLE);
    }

    public JavascriptContainerBuilder(URL script, ClassLoader classLoader, LifecycleMode lifecycleMode) {
        super(script, classLoader, lifecycleMode);
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        final ClassLoader loader = this.getClassLoader();
        Context cx = new Context(){

            public GeneratedClassLoader createClassLoader(ClassLoader parent) {
                return new DefiningClassLoader(loader);
            }
        };
        cx = Context.enter((Context)cx);
        try {
            ImporterTopLevel scope = new ImporterTopLevel(cx);
            scope.put("parent", (Scriptable)scope, (Object)parentContainer);
            scope.put("assemblyScope", (Scriptable)scope, assemblyScope);
            cx.evaluateReader((Scriptable)scope, this.getScriptReader(), "picocontainer.js", 1, null);
            Object pico = scope.get("pico", (Scriptable)scope);
            if (pico == null) {
                throw new ScriptedPicoContainerMarkupException("The script must define a variable named 'pico'");
            }
            if (!(pico instanceof NativeJavaObject)) {
                throw new ScriptedPicoContainerMarkupException("The 'pico' variable must be of type " + NativeJavaObject.class.getName());
            }
            Object javaObject = ((NativeJavaObject)pico).unwrap();
            if (!(javaObject instanceof PicoContainer)) {
                throw new ScriptedPicoContainerMarkupException("The 'pico' variable must be of type " + PicoContainer.class.getName());
            }
            PicoContainer picoContainer = (PicoContainer)javaObject;
            return picoContainer;
        }
        catch (ScriptedPicoContainerMarkupException e) {
            throw e;
        }
        catch (RhinoException e) {
            StringBuilder message = new StringBuilder();
            message.append("There was an error in script '");
            message.append(e.sourceName());
            message.append("'.  Line number: ");
            message.append(e.lineNumber());
            message.append(" and Column number: ");
            message.append(e.columnNumber());
            message.append(" .");
            throw new ScriptedPicoContainerMarkupException(message.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ScriptedPicoContainerMarkupException("IOException encountered, message -'" + e.getMessage() + "'", (Throwable)e);
        }
        finally {
            Context.exit();
        }
    }
}

