/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.groovy.nodes;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.ComponentMonitorStrategy;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.classname.ClassLoadingPicoContainer;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;
import org.picocontainer.monitors.AbstractComponentMonitor;
import org.picocontainer.script.NodeBuilderDecorator;
import org.picocontainer.script.ScriptedPicoContainerMarkupException;
import org.picocontainer.script.groovy.nodes.AbstractBuilderNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildContainerNode
extends AbstractBuilderNode {
    public static final String NODE_NAME = "container";
    private static final String CLASS = "class";
    private final NodeBuilderDecorator decorator;
    private static final String COMPONENT_ADAPTER_FACTORY = "componentFactory";
    private static final String COMPONENT_MONITOR = "componentMonitor";
    private static final String SCOPE = "scope";
    private static final String PARENT = "parent";

    public ChildContainerNode(NodeBuilderDecorator decorator) {
        super(NODE_NAME);
        this.decorator = decorator;
        this.addAttribute(CLASS).addAttribute(COMPONENT_ADAPTER_FACTORY).addAttribute(COMPONENT_MONITOR).addAttribute(PARENT).addAttribute(SCOPE);
    }

    public Object createNewNode(Object current, Map attributes) throws ScriptedPicoContainerMarkupException {
        return this.createChildContainer(attributes, (ClassLoadingPicoContainer)current);
    }

    private NodeBuilderDecorator getDecorator() {
        return this.decorator;
    }

    protected ClassLoadingPicoContainer createChildContainer(Map<String, Object> attributes, ClassLoadingPicoContainer parent) {
        MutablePicoContainer childContainer;
        ComponentFactory componentFactory;
        ClassLoader parentClassLoader;
        if (parent != null) {
            parentClassLoader = parent.getComponentClassLoader();
            if (this.isAttribute(attributes, COMPONENT_ADAPTER_FACTORY)) {
                componentFactory = this.createComponentFactory(attributes);
                childContainer = new DefaultPicoContainer(this.getDecorator().decorate(componentFactory, attributes), (PicoContainer)parent);
                if (this.isAttribute(attributes, COMPONENT_MONITOR)) {
                    this.changeComponentMonitor(childContainer, this.createComponentMonitor(attributes));
                }
                parent.addChildContainer((PicoContainer)childContainer);
            } else if (this.isAttribute(attributes, COMPONENT_MONITOR)) {
                componentFactory = new Caching();
                childContainer = new DefaultPicoContainer(this.getDecorator().decorate(componentFactory, attributes), (PicoContainer)parent);
                this.changeComponentMonitor(childContainer, this.createComponentMonitor(attributes));
            } else {
                childContainer = parent.makeChildContainer();
            }
        } else {
            parentClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PicoContainer.class.getClassLoader();
                }
            });
            componentFactory = this.createComponentFactory(attributes);
            childContainer = new DefaultPicoContainer(this.getDecorator().decorate(componentFactory, attributes));
            if (this.isAttribute(attributes, COMPONENT_MONITOR)) {
                this.changeComponentMonitor(childContainer, this.createComponentMonitor(attributes));
            }
        }
        MutablePicoContainer decoratedPico = this.getDecorator().decorate(childContainer);
        if (this.isAttribute(attributes, CLASS)) {
            Class clazz = (Class)attributes.get(CLASS);
            return this.createPicoContainer(clazz, decoratedPico, parentClassLoader);
        }
        return new DefaultClassLoadingPicoContainer(parentClassLoader, decoratedPico);
    }

    private void changeComponentMonitor(MutablePicoContainer childContainer, ComponentMonitor monitor) {
        if (childContainer instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)childContainer).changeMonitor(monitor);
        }
    }

    private ClassLoadingPicoContainer createPicoContainer(Class<?> clazz, MutablePicoContainer decoratedPico, ClassLoader parentClassLoader) {
        DefaultPicoContainer instantiatingContainer = new DefaultPicoContainer();
        instantiatingContainer.addComponent(ClassLoader.class, (Object)parentClassLoader, new Parameter[0]);
        instantiatingContainer.addComponent(MutablePicoContainer.class, (Object)decoratedPico, new Parameter[0]);
        instantiatingContainer.addComponent(ClassLoadingPicoContainer.class, clazz, new Parameter[0]);
        Object componentInstance = instantiatingContainer.getComponent(ClassLoadingPicoContainer.class);
        return (ClassLoadingPicoContainer)componentInstance;
    }

    private ComponentFactory createComponentFactory(Map<String, Object> attributes) {
        ComponentFactory factory = (ComponentFactory)attributes.remove(COMPONENT_ADAPTER_FACTORY);
        if (factory == null) {
            return new Caching();
        }
        return factory;
    }

    private ComponentMonitor createComponentMonitor(Map<String, Object> attributes) {
        ComponentMonitor monitor = (ComponentMonitor)attributes.remove(COMPONENT_MONITOR);
        if (monitor == null) {
            return new AbstractComponentMonitor();
        }
        return monitor;
    }
}

