/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.picocontainer.ComponentFactory;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.classname.ClassLoadingPicoContainer;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;
import org.picocontainer.containers.EmptyPicoContainer;
import org.picocontainer.script.LifecycleMode;
import org.picocontainer.script.ScriptedContainerBuilder;
import org.picocontainer.script.ScriptedPicoContainerMarkupException;
import org.picocontainer.script.groovy.GroovyCompilationException;
import org.picocontainer.script.groovy.GroovyNodeBuilder;

public class GroovyContainerBuilder
extends ScriptedContainerBuilder {
    private Class<?> scriptClass;

    public GroovyContainerBuilder(Reader script, ClassLoader classLoader) {
        this(script, classLoader, LifecycleMode.AUTO_LIFECYCLE);
    }

    public GroovyContainerBuilder(Reader script, ClassLoader classLoader, LifecycleMode lifecycleMode) {
        super(script, classLoader, lifecycleMode);
        this.createGroovyClass();
    }

    public GroovyContainerBuilder(URL script, ClassLoader classLoader) {
        this(script, classLoader, LifecycleMode.AUTO_LIFECYCLE);
    }

    public GroovyContainerBuilder(URL script, ClassLoader classLoader, LifecycleMode lifecycleMode) {
        super(script, classLoader, lifecycleMode);
        this.createGroovyClass();
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        Binding binding = new Binding();
        if (parentContainer == null) {
            parentContainer = new DefaultClassLoadingPicoContainer(this.getClassLoader(), (MutablePicoContainer)new DefaultPicoContainer((ComponentFactory)new Caching(), (PicoContainer)new EmptyPicoContainer()));
        }
        binding.setVariable("parent", (Object)parentContainer);
        binding.setVariable("builder", (Object)this.createNodeBuilder());
        binding.setVariable("assemblyScope", assemblyScope);
        this.handleBinding(binding);
        return this.runGroovyScript(binding);
    }

    protected GroovyObject createNodeBuilder() {
        return new GroovyNodeBuilder();
    }

    protected void handleBinding(Binding binding) {
    }

    private void createGroovyClass() {
        try {
            GroovyClassLoader loader = new GroovyClassLoader(this.getClassLoader());
            InputStream scriptIs = this.getScriptInputStream();
            GroovyCodeSource groovyCodeSource = new GroovyCodeSource(scriptIs, "picocontainer.groovy", "groovyGeneratedForPicoContainer");
            this.scriptClass = loader.parseClass(groovyCodeSource);
        }
        catch (CompilationFailedException e) {
            throw new GroovyCompilationException("Compilation Failed '" + e.getMessage() + "'", e);
        }
        catch (IOException e) {
            throw new ScriptedPicoContainerMarkupException((Throwable)e);
        }
    }

    private PicoContainer runGroovyScript(Binding binding) {
        Object picoVariable;
        Script script = this.createGroovyScript(binding);
        Object result = script.run();
        try {
            picoVariable = binding.getVariable("pico");
        }
        catch (MissingPropertyException e) {
            picoVariable = result;
        }
        if (picoVariable == null) {
            throw new NullPointerException("Groovy Script Variable: pico");
        }
        if (picoVariable instanceof PicoContainer) {
            return (PicoContainer)picoVariable;
        }
        if (picoVariable instanceof ClassLoadingPicoContainer) {
            return (ClassLoadingPicoContainer)picoVariable;
        }
        throw new ScriptedPicoContainerMarkupException("Bad type for pico:" + picoVariable.getClass().getName());
    }

    private Script createGroovyScript(Binding binding) {
        return InvokerHelper.createScript(this.scriptClass, (Binding)binding);
    }
}

