/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.jmock.MockObjectTestCase;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Disposable;
import org.picocontainer.LifecycleManager;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.Startable;
import org.picocontainer.defaults.AbstractPicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.BasicComponentParameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;
import org.picocontainer.defaults.VerifyingVisitor;
import org.picocontainer.testmodel.DependsOnTouchable;
import org.picocontainer.testmodel.SimpleTouchable;
import org.picocontainer.testmodel.Touchable;
import org.picocontainer.testmodel.Washable;

public abstract class AbstractPicoContainerTestCase
extends MockObjectTestCase {
    static /* synthetic */ Class class$org$picocontainer$testmodel$DependsOnTouchable;
    static /* synthetic */ Class class$org$picocontainer$testmodel$Touchable;
    static /* synthetic */ Class class$org$picocontainer$testmodel$SimpleTouchable;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB;
    static /* synthetic */ Class class$org$picocontainer$testmodel$WashableTouchable;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsWashable;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsTouchable;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$JMSService;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentA;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$TestLifecycleComponent;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable;

    protected abstract MutablePicoContainer createPicoContainer(PicoContainer var1);

    protected final MutablePicoContainer createPicoContainerWithDependsOnTouchableOnly() throws PicoRegistrationException, PicoIntrospectionException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.registerComponentImplementation(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable);
        return pico;
    }

    protected final MutablePicoContainer createPicoContainerWithTouchableAndDependsOnTouchable() throws PicoRegistrationException, PicoIntrospectionException {
        MutablePicoContainer pico = this.createPicoContainerWithDependsOnTouchableOnly();
        pico.registerComponentImplementation((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable), class$org$picocontainer$testmodel$SimpleTouchable == null ? (class$org$picocontainer$testmodel$SimpleTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.SimpleTouchable")) : class$org$picocontainer$testmodel$SimpleTouchable);
        return pico;
    }

    public void testBasicInstantiationAndContainment() throws PicoException, PicoRegistrationException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependsOnTouchable();
        AbstractPicoContainerTestCase.assertTrue((String)"Component should be instance of Touchable", (boolean)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable).isAssignableFrom(pico.getComponentAdapterOfType(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable).getComponentImplementation()));
    }

    public void testRegisteredComponentsExistAndAreTheCorrectTypes() throws PicoException, PicoRegistrationException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependsOnTouchable();
        AbstractPicoContainerTestCase.assertNotNull((String)"Container should have Touchable component", (Object)pico.getComponentAdapter((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable)));
        AbstractPicoContainerTestCase.assertNotNull((String)"Container should have DependsOnTouchable component", (Object)pico.getComponentAdapter((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable)));
        AbstractPicoContainerTestCase.assertTrue((String)"Component should be instance of Touchable", (boolean)(pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable)) instanceof Touchable));
        AbstractPicoContainerTestCase.assertTrue((String)"Component should be instance of DependsOnTouchable", (boolean)(pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable)) instanceof DependsOnTouchable));
        AbstractPicoContainerTestCase.assertNull((String)"should not have non existent component", (Object)pico.getComponentAdapter((Object)(class$java$util$Map == null ? (class$java$util$Map = AbstractPicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map)));
    }

    public void testRegistersSingleInstance() throws PicoException, PicoInitializationException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        StringBuffer sb = new StringBuffer();
        pico.registerComponentInstance((Object)sb);
        AbstractPicoContainerTestCase.assertSame((Object)sb, (Object)pico.getComponentInstance((Object)(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = AbstractPicoContainerTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer)));
    }

    public void testContainerIsSerializable() throws PicoException, PicoInitializationException, IOException, ClassNotFoundException {
        this.getTouchableFromSerializedContainer();
    }

    private Touchable getTouchableFromSerializedContainer() throws IOException, ClassNotFoundException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependsOnTouchable();
        pico.registerComponentImplementation((Object)"list", class$java$util$ArrayList == null ? (class$java$util$ArrayList = AbstractPicoContainerTestCase.class$("java.util.ArrayList")) : class$java$util$ArrayList, new Parameter[]{new ConstantParameter((Object)new Integer(10))});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(pico);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        pico = (MutablePicoContainer)ois.readObject();
        DependsOnTouchable dependsOnTouchable = (DependsOnTouchable)pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable));
        AbstractPicoContainerTestCase.assertNotNull((Object)dependsOnTouchable);
        return (Touchable)pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable));
    }

    public void testSerializedContainerCanRetrieveImplementation() throws PicoException, PicoInitializationException, IOException, ClassNotFoundException {
        Touchable touchable = this.getTouchableFromSerializedContainer();
        SimpleTouchable simpleTouchable = (SimpleTouchable)touchable;
        AbstractPicoContainerTestCase.assertTrue((boolean)simpleTouchable.wasTouched);
    }

    public void testGettingComponentWithMissingDependencyFails() throws PicoException, PicoRegistrationException {
        MutablePicoContainer picoContainer = this.createPicoContainerWithDependsOnTouchableOnly();
        try {
            picoContainer.getComponentInstance((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable));
            AbstractPicoContainerTestCase.fail((String)"should need a Touchable");
        }
        catch (UnsatisfiableDependenciesException e) {
            AbstractPicoContainerTestCase.assertSame((Object)picoContainer.getComponentAdapterOfType(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable).getComponentImplementation(), (Object)e.getUnsatisfiableComponentAdapter().getComponentImplementation());
            Set unsatisfiableDependencies = e.getUnsatisfiableDependencies();
            AbstractPicoContainerTestCase.assertEquals((int)1, (int)unsatisfiableDependencies.size());
            List unsatisfied = (List)unsatisfiableDependencies.iterator().next();
            AbstractPicoContainerTestCase.assertEquals((int)1, (int)unsatisfied.size());
            AbstractPicoContainerTestCase.assertEquals((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable), unsatisfied.get(0));
        }
    }

    public void testDuplicateRegistration() throws Exception {
        try {
            MutablePicoContainer pico = this.createPicoContainer(null);
            pico.registerComponentImplementation(class$java$lang$Object == null ? (class$java$lang$Object = AbstractPicoContainerTestCase.class$("java.lang.Object")) : class$java$lang$Object);
            pico.registerComponentImplementation(class$java$lang$Object == null ? (class$java$lang$Object = AbstractPicoContainerTestCase.class$("java.lang.Object")) : class$java$lang$Object);
            AbstractPicoContainerTestCase.fail((String)"Should have failed with duplicate registration");
        }
        catch (DuplicateComponentKeyRegistrationException e) {
            AbstractPicoContainerTestCase.assertTrue((String)"Wrong key", (e.getDuplicateKey() == (class$java$lang$Object == null ? (class$java$lang$Object = AbstractPicoContainerTestCase.class$("java.lang.Object")) : class$java$lang$Object) ? 1 : 0) != 0);
        }
    }

    public void testExternallyInstantiatedObjectsCanBeRegistgeredAndLookedUp() throws PicoException, PicoInitializationException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        HashMap map = new HashMap();
        pico.registerComponentInstance((Object)(class$java$util$Map == null ? (class$java$util$Map = AbstractPicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), map);
        AbstractPicoContainerTestCase.assertSame(map, (Object)pico.getComponentInstance((Object)(class$java$util$Map == null ? (class$java$util$Map = AbstractPicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map)));
    }

    public void testAmbiguousResolution() throws PicoRegistrationException, PicoInitializationException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.registerComponentImplementation((Object)"ping", class$java$lang$String == null ? (class$java$lang$String = AbstractPicoContainerTestCase.class$("java.lang.String")) : class$java$lang$String);
        pico.registerComponentInstance((Object)"pong", (Object)"pang");
        try {
            pico.getComponentInstance((Object)(class$java$lang$String == null ? (class$java$lang$String = AbstractPicoContainerTestCase.class$("java.lang.String")) : class$java$lang$String));
        }
        catch (AmbiguousComponentResolutionException e) {
            AbstractPicoContainerTestCase.assertTrue((e.getMessage().indexOf("java.lang.String") != -1 ? 1 : 0) != 0);
        }
    }

    public void testLookupWithUnregisteredKeyReturnsNull() throws PicoIntrospectionException, PicoInitializationException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        AbstractPicoContainerTestCase.assertNull((Object)pico.getComponentInstance((Object)(class$java$lang$String == null ? (class$java$lang$String = AbstractPicoContainerTestCase.class$("java.lang.String")) : class$java$lang$String)));
    }

    public void testLookupWithUnregisteredTypeReturnsNull() throws PicoIntrospectionException, PicoInitializationException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        AbstractPicoContainerTestCase.assertNull((Object)pico.getComponentInstanceOfType(class$java$lang$String == null ? (class$java$lang$String = AbstractPicoContainerTestCase.class$("java.lang.String")) : class$java$lang$String));
    }

    public void testUnsatisfiableDependenciesExceptionGivesVerboseEnoughErrorMessage() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentD")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD);
        try {
            pico.getComponentInstance((Object)(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentD")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD));
        }
        catch (UnsatisfiableDependenciesException e) {
            Set unsatisfiableDependencies = e.getUnsatisfiableDependencies();
            AbstractPicoContainerTestCase.assertEquals((int)1, (int)unsatisfiableDependencies.size());
            List list = (List)unsatisfiableDependencies.iterator().next();
            ArrayList<Class> expectedList = new ArrayList<Class>(2);
            expectedList.add(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentE")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE);
            expectedList.add(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentB")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB);
            AbstractPicoContainerTestCase.assertEquals(expectedList, (Object)list);
        }
    }

    public void testUnsatisfiableDependenciesExceptionGivesUnsatisfiedDependencyTypes() {
        Class unsatisfiedDependencyType;
        ArrayList<Class> expectedList;
        List list;
        Set unsatisfiableDependencies;
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentD")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD);
        try {
            pico.getComponentInstance((Object)(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentD")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD));
        }
        catch (UnsatisfiableDependenciesException e) {
            unsatisfiableDependencies = e.getUnsatisfiableDependencies();
            AbstractPicoContainerTestCase.assertEquals((int)1, (int)unsatisfiableDependencies.size());
            list = (List)unsatisfiableDependencies.iterator().next();
            expectedList = new ArrayList<Class>(2);
            expectedList.add(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentE")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE);
            expectedList.add(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentB")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB);
            AbstractPicoContainerTestCase.assertEquals(expectedList, (Object)list);
            unsatisfiedDependencyType = e.getUnsatisfiedDependencyType();
            AbstractPicoContainerTestCase.assertNotNull((Object)unsatisfiedDependencyType);
            AbstractPicoContainerTestCase.assertEquals((Object)(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentE")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE), (Object)unsatisfiedDependencyType);
        }
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentE")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE);
        try {
            pico.getComponentInstance((Object)(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentD")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD));
        }
        catch (UnsatisfiableDependenciesException e) {
            unsatisfiableDependencies = e.getUnsatisfiableDependencies();
            AbstractPicoContainerTestCase.assertEquals((int)1, (int)unsatisfiableDependencies.size());
            list = (List)unsatisfiableDependencies.iterator().next();
            expectedList = new ArrayList(2);
            expectedList.add(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentE")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE);
            expectedList.add(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentB")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB);
            AbstractPicoContainerTestCase.assertEquals(expectedList, (Object)list);
            unsatisfiedDependencyType = e.getUnsatisfiedDependencyType();
            AbstractPicoContainerTestCase.assertNotNull((Object)unsatisfiedDependencyType);
            AbstractPicoContainerTestCase.assertEquals((Object)(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentB")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB), (Object)unsatisfiedDependencyType);
        }
    }

    public void testCyclicDependencyThrowsCyclicDependencyException() {
        AbstractPicoContainerTestCase.assertCyclicDependencyThrowsCyclicDependencyException(this.createPicoContainer(null));
    }

    private static void assertCyclicDependencyThrowsCyclicDependencyException(MutablePicoContainer pico) {
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentB")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentB);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentD")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentE")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE);
        try {
            pico.getComponentInstance((Object)(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentD")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD));
            AbstractPicoContainerTestCase.fail((String)"CyclicDependencyException expected");
        }
        catch (CyclicDependencyException e) {
            List<Class> dependencies = Arrays.asList(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentD")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD, class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentE")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE, class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentD")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentD);
            List<Class> reportedDependencies = Arrays.asList(e.getDependencies());
            AbstractPicoContainerTestCase.assertEquals(dependencies, reportedDependencies);
        }
        catch (StackOverflowError e) {
            AbstractPicoContainerTestCase.fail();
        }
    }

    public void testCyclicDependencyThrowsCyclicDependencyExceptionWithParentContainer() {
        MutablePicoContainer pico = this.createPicoContainer((PicoContainer)this.createPicoContainer(null));
        AbstractPicoContainerTestCase.assertCyclicDependencyThrowsCyclicDependencyException(pico);
    }

    public void testRemovalNonRegisteredComponentAdapterWorksAndReturnsNull() {
        MutablePicoContainer picoContainer = this.createPicoContainer(null);
        AbstractPicoContainerTestCase.assertNull((Object)picoContainer.unregisterComponent((Object)"COMPONENT DOES NOT EXIST"));
    }

    public void testComponentAdapterRegistrationOrderIsMaintained() {
        ConstructorInjectionComponentAdapter c1 = new ConstructorInjectionComponentAdapter((Object)"1", class$java$lang$Object == null ? (class$java$lang$Object = AbstractPicoContainerTestCase.class$("java.lang.Object")) : class$java$lang$Object);
        ConstructorInjectionComponentAdapter c2 = new ConstructorInjectionComponentAdapter((Object)"2", class$java$lang$String == null ? (class$java$lang$String = AbstractPicoContainerTestCase.class$("java.lang.String")) : class$java$lang$String);
        MutablePicoContainer picoContainer = this.createPicoContainer(null);
        picoContainer.registerComponent((ComponentAdapter)c1);
        picoContainer.registerComponent((ComponentAdapter)c2);
        AbstractPicoContainerTestCase.assertEquals((String)"registration order should be maintained", Arrays.asList(c1, c2), (Object)picoContainer.getComponentAdapters());
        picoContainer.getComponentInstances();
        AbstractPicoContainerTestCase.assertFalse((String)"instances should be created in same order as adapters are created", (boolean)(picoContainer.getComponentInstances().get(0) instanceof String));
        AbstractPicoContainerTestCase.assertTrue((String)"instances should be created in same order as adapters are created", (boolean)(picoContainer.getComponentInstances().get(1) instanceof String));
        MutablePicoContainer reversedPicoContainer = this.createPicoContainer(null);
        reversedPicoContainer.registerComponent((ComponentAdapter)c2);
        reversedPicoContainer.registerComponent((ComponentAdapter)c1);
        AbstractPicoContainerTestCase.assertEquals((String)"registration order should be maintained", Arrays.asList(c2, c1), (Object)reversedPicoContainer.getComponentAdapters());
        reversedPicoContainer.getComponentInstances();
        AbstractPicoContainerTestCase.assertTrue((String)"instances should be created in same order as adapters are created", (boolean)(reversedPicoContainer.getComponentInstances().get(0) instanceof String));
        AbstractPicoContainerTestCase.assertFalse((String)"instances should be created in same order as adapters are created", (boolean)(reversedPicoContainer.getComponentInstances().get(1) instanceof String));
    }

    public void testSameInstanceCanBeUsedAsDifferentTypeWhenCaching() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.registerComponentImplementation((Object)"wt", class$org$picocontainer$testmodel$WashableTouchable == null ? (class$org$picocontainer$testmodel$WashableTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.WashableTouchable")) : class$org$picocontainer$testmodel$WashableTouchable);
        pico.registerComponentImplementation((Object)"nw", class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsWashable == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsWashable = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$NeedsWashable")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsWashable);
        pico.registerComponentImplementation((Object)"nt", class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsTouchable == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$NeedsTouchable")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsTouchable);
        NeedsWashable nw = (NeedsWashable)pico.getComponentInstance((Object)"nw");
        NeedsTouchable nt = (NeedsTouchable)pico.getComponentInstance((Object)"nt");
        AbstractPicoContainerTestCase.assertSame((Object)nw.washable, (Object)nt.touchable);
    }

    public void testRegisterComponentWithObjectBadType() throws PicoIntrospectionException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        try {
            pico.registerComponentInstance((Object)(class$java$io$Serializable == null ? (class$java$io$Serializable = AbstractPicoContainerTestCase.class$("java.io.Serializable")) : class$java$io$Serializable), new Object());
            AbstractPicoContainerTestCase.fail((String)"Shouldn't be able to register an Object.class as Serializable because it is not, it does not implement it, Object.class does not implement much.");
        }
        catch (AssignabilityRegistrationException assignabilityRegistrationException) {
            // empty catch block
        }
    }

    public void testPico52() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.registerComponentImplementation((Object)"foo", class$org$picocontainer$tck$AbstractPicoContainerTestCase$JMSService == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$JMSService = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$JMSService")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$JMSService, new Parameter[]{new ConstantParameter((Object)"0"), new ConstantParameter((Object)"something")});
        JMSService jms = (JMSService)pico.getComponentInstance((Object)"foo");
        AbstractPicoContainerTestCase.assertEquals((String)"0", (String)jms.serverid);
        AbstractPicoContainerTestCase.assertEquals((String)"something", (String)jms.path);
    }

    public void testAggregatedVerificationException() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentA == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentA = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentA")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentA);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentE")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE);
        try {
            new VerifyingVisitor().traverse((Object)pico);
            AbstractPicoContainerTestCase.fail((String)"we expect a PicoVerificationException");
        }
        catch (PicoVerificationException e) {
            List nested = e.getNestedExceptions();
            AbstractPicoContainerTestCase.assertEquals((int)2, (int)nested.size());
            AbstractPicoContainerTestCase.assertTrue((-1 != e.getMessage().indexOf((class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentA == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentA = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentA")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentA).getName()) ? 1 : 0) != 0);
            AbstractPicoContainerTestCase.assertTrue((-1 != e.getMessage().indexOf((class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ComponentE")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ComponentE).getName()) ? 1 : 0) != 0);
        }
    }

    public void testShouldReturnNullWhenUnregistereingUnmanagedComponent() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        AbstractPicoContainerTestCase.assertNull((Object)pico.unregisterComponentByInstance((Object)"yo"));
    }

    public void testShouldReturnNullForComponentAdapterOfUnregisteredType() {
        MutablePicoContainer pico = this.createPicoContainer(null);
        AbstractPicoContainerTestCase.assertNull((Object)pico.getComponentInstanceOfType(class$java$util$List == null ? (class$java$util$List = AbstractPicoContainerTestCase.class$("java.util.List")) : class$java$util$List));
    }

    public void testShouldReturnNonMutableParent() {
        DefaultPicoContainer parent = new DefaultPicoContainer();
        MutablePicoContainer picoContainer = this.createPicoContainer((PicoContainer)parent);
        AbstractPicoContainerTestCase.assertNotSame((Object)parent, (Object)picoContainer.getParent());
        AbstractPicoContainerTestCase.assertFalse((boolean)(picoContainer.getParent() instanceof MutablePicoContainer));
    }

    public void testContainerCascadesDefaultLifecycle() {
        MutablePicoContainer picoContainer = this.createPicoContainer(null);
        Foo foo = new Foo();
        picoContainer.registerComponentInstance((Object)foo);
        picoContainer.start();
        AbstractPicoContainerTestCase.assertEquals((boolean)true, (boolean)foo.started);
        picoContainer.stop();
        AbstractPicoContainerTestCase.assertEquals((boolean)true, (boolean)foo.stopped);
        picoContainer.dispose();
        AbstractPicoContainerTestCase.assertEquals((boolean)true, (boolean)foo.disposed);
    }

    public void testComponentInstancesFromParentsAreNotDirectlyAccessible2() {
        MutablePicoContainer a = this.createPicoContainer(null);
        MutablePicoContainer b = this.createPicoContainer((PicoContainer)a);
        MutablePicoContainer c = this.createPicoContainer((PicoContainer)b);
        Object ao = new Object();
        Object bo = new Object();
        Object co = new Object();
        a.registerComponentInstance((Object)"a", ao);
        b.registerComponentInstance((Object)"b", bo);
        c.registerComponentInstance((Object)"c", co);
        AbstractPicoContainerTestCase.assertEquals((int)1, (int)a.getComponentInstances().size());
        AbstractPicoContainerTestCase.assertEquals((int)1, (int)b.getComponentInstances().size());
        AbstractPicoContainerTestCase.assertEquals((int)1, (int)c.getComponentInstances().size());
    }

    public void testStartStopAndDisposeCascadedtoChildren() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        parent.registerComponentInstance((Object)new StringBuffer());
        MutablePicoContainer child = this.createPicoContainer((PicoContainer)parent);
        parent.addChildContainer((PicoContainer)child);
        child.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$LifeCycleMonitoring")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring);
        parent.start();
        try {
            child.start();
            AbstractPicoContainerTestCase.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            AbstractPicoContainerTestCase.assertEquals((String)"child already started", (String)"Already started", (String)e.getMessage());
        }
        parent.stop();
        try {
            child.stop();
            AbstractPicoContainerTestCase.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            AbstractPicoContainerTestCase.assertEquals((String)"child not started", (String)"Not started", (String)e.getMessage());
        }
        parent.dispose();
        try {
            child.dispose();
            AbstractPicoContainerTestCase.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            AbstractPicoContainerTestCase.assertEquals((String)"child already disposed", (String)"Already disposed", (String)e.getMessage());
        }
    }

    public void testMakingOfChildContainer() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        MutablePicoContainer child = parent.makeChildContainer();
        AbstractPicoContainerTestCase.assertNotNull((Object)child);
    }

    public void testMakingOfChildContainerPercolatesLifecycleManager() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        parent.registerComponentImplementation((Object)"one", class$org$picocontainer$tck$AbstractPicoContainerTestCase$TestLifecycleComponent == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$TestLifecycleComponent = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$TestLifecycleComponent")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$TestLifecycleComponent);
        MutablePicoContainer child = parent.makeChildContainer();
        AbstractPicoContainerTestCase.assertNotNull((Object)child);
        child.registerComponentImplementation((Object)"two", class$org$picocontainer$tck$AbstractPicoContainerTestCase$TestLifecycleComponent == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$TestLifecycleComponent = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$TestLifecycleComponent")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$TestLifecycleComponent);
        parent.start();
        try {
            child.start();
        }
        catch (IllegalStateException e) {
            AbstractPicoContainerTestCase.assertEquals((String)"child already started", (String)"Already started", (String)e.getMessage());
        }
    }

    public void testStartStopAndDisposeNotCascadedtoRemovedChildren() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        parent.registerComponentInstance((Object)new StringBuffer());
        StringBuffer sb = (StringBuffer)parent.getComponentInstancesOfType(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = AbstractPicoContainerTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer).get(0);
        MutablePicoContainer child = this.createPicoContainer((PicoContainer)parent);
        AbstractPicoContainerTestCase.assertTrue((boolean)parent.addChildContainer((PicoContainer)child));
        child.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$LifeCycleMonitoring")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring);
        AbstractPicoContainerTestCase.assertTrue((boolean)parent.removeChildContainer((PicoContainer)child));
        parent.start();
        AbstractPicoContainerTestCase.assertTrue((sb.toString().indexOf("-started") == -1 ? 1 : 0) != 0);
        parent.stop();
        AbstractPicoContainerTestCase.assertTrue((sb.toString().indexOf("-stopped") == -1 ? 1 : 0) != 0);
        parent.dispose();
        AbstractPicoContainerTestCase.assertTrue((sb.toString().indexOf("-disposed") == -1 ? 1 : 0) != 0);
    }

    public void testShouldCascadeStartStopAndDisposeToChild() {
        StringBuffer sb = new StringBuffer();
        MutablePicoContainer parent = this.createPicoContainer(null);
        parent.registerComponentInstance((Object)sb);
        parent.registerComponentImplementation((Object)(class$java$util$Map == null ? (class$java$util$Map = AbstractPicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), class$java$util$HashMap == null ? (class$java$util$HashMap = AbstractPicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap);
        MutablePicoContainer child = parent.makeChildContainer();
        child.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$LifeCycleMonitoring")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$LifeCycleMonitoring);
        Map map = (Map)parent.getComponentInstance((Object)(class$java$util$Map == null ? (class$java$util$Map = AbstractPicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map));
        AbstractPicoContainerTestCase.assertNotNull((Object)map);
        parent.start();
        try {
            child.start();
            AbstractPicoContainerTestCase.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            AbstractPicoContainerTestCase.assertEquals((String)"child already started", (String)"Already started", (String)e.getMessage());
        }
        parent.stop();
        try {
            child.stop();
            AbstractPicoContainerTestCase.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            AbstractPicoContainerTestCase.assertEquals((String)"child not started", (String)"Not started", (String)e.getMessage());
        }
        parent.dispose();
        try {
            child.dispose();
            AbstractPicoContainerTestCase.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            AbstractPicoContainerTestCase.assertEquals((String)"child already disposed", (String)"Already disposed", (String)e.getMessage());
        }
    }

    public void testAcceptImplementsBreadthFirstStrategy() {
        MutablePicoContainer parent = this.createPicoContainer(null);
        MutablePicoContainer child = parent.makeChildContainer();
        ComponentAdapter hashMapAdapter = parent.registerComponent((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)(class$java$util$HashMap == null ? (class$java$util$HashMap = AbstractPicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap), class$java$util$HashMap == null ? (class$java$util$HashMap = AbstractPicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap));
        ComponentAdapter hashSetAdapter = parent.registerComponent((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)(class$java$util$HashSet == null ? (class$java$util$HashSet = AbstractPicoContainerTestCase.class$("java.util.HashSet")) : class$java$util$HashSet), class$java$util$HashSet == null ? (class$java$util$HashSet = AbstractPicoContainerTestCase.class$("java.util.HashSet")) : class$java$util$HashSet));
        ComponentAdapter stringAdapter = parent.registerComponent((ComponentAdapter)new InstanceComponentAdapter((Object)(class$java$lang$String == null ? (class$java$lang$String = AbstractPicoContainerTestCase.class$("java.lang.String")) : class$java$lang$String), (Object)"foo"));
        ComponentAdapter arrayListAdapter = child.registerComponent((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)(class$java$util$ArrayList == null ? (class$java$util$ArrayList = AbstractPicoContainerTestCase.class$("java.util.ArrayList")) : class$java$util$ArrayList), class$java$util$ArrayList == null ? (class$java$util$ArrayList = AbstractPicoContainerTestCase.class$("java.util.ArrayList")) : class$java$util$ArrayList));
        BasicComponentParameter componentParameter = BasicComponentParameter.BASIC_DEFAULT;
        ConstantParameter throwableParameter = new ConstantParameter((Object)new Throwable("bar"));
        ComponentAdapter exceptionAdapter = child.registerComponent((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)(class$java$lang$Exception == null ? (class$java$lang$Exception = AbstractPicoContainerTestCase.class$("java.lang.Exception")) : class$java$lang$Exception), class$java$lang$Exception == null ? (class$java$lang$Exception = AbstractPicoContainerTestCase.class$("java.lang.Exception")) : class$java$lang$Exception, new Parameter[]{componentParameter, throwableParameter}));
        List<Object> expectedList = Arrays.asList(parent, hashMapAdapter, hashSetAdapter, stringAdapter, child, arrayListAdapter, exceptionAdapter, componentParameter, throwableParameter);
        LinkedList visitedList = new LinkedList();
        RecordingStrategyVisitor visitor = new RecordingStrategyVisitor(visitedList);
        visitor.traverse(parent);
        AbstractPicoContainerTestCase.assertEquals(expectedList, visitedList);
    }

    public void testAmbiguousDependencies() throws PicoRegistrationException, PicoInitializationException {
        MutablePicoContainer pico = this.createPicoContainer(null);
        pico.registerComponentImplementation(class$org$picocontainer$testmodel$SimpleTouchable == null ? (class$org$picocontainer$testmodel$SimpleTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.SimpleTouchable")) : class$org$picocontainer$testmodel$SimpleTouchable);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$DerivedTouchable")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable);
        pico.registerComponentImplementation(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable);
        try {
            pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable));
            AbstractPicoContainerTestCase.fail((String)"DependsOnTouchable should have been confused about the two Touchables");
        }
        catch (AmbiguousComponentResolutionException e) {
            List<Object> componentImplementations = Arrays.asList(e.getAmbiguousComponentKeys());
            AbstractPicoContainerTestCase.assertTrue((boolean)componentImplementations.contains(class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$DerivedTouchable")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable));
            AbstractPicoContainerTestCase.assertTrue((boolean)componentImplementations.contains(class$org$picocontainer$testmodel$SimpleTouchable == null ? (class$org$picocontainer$testmodel$SimpleTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.SimpleTouchable")) : class$org$picocontainer$testmodel$SimpleTouchable));
            AbstractPicoContainerTestCase.assertTrue((e.getMessage().indexOf((class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$DerivedTouchable")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$DerivedTouchable).getName()) != -1 ? 1 : 0) != 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DerivedTouchable
    extends SimpleTouchable {
    }

    public static class RecordingStrategyVisitor
    extends AbstractPicoVisitor {
        private final List list;

        public RecordingStrategyVisitor(List list) {
            this.list = list;
        }

        public void visitContainer(PicoContainer pico) {
            this.list.add(pico);
        }

        public void visitComponentAdapter(ComponentAdapter componentAdapter) {
            this.list.add(componentAdapter);
        }

        public void visitParameter(Parameter parameter) {
            this.list.add(parameter);
        }
    }

    public static class LifeCycleMonitoring
    implements Startable,
    Disposable {
        StringBuffer sb;

        public LifeCycleMonitoring(StringBuffer sb) {
            this.sb = sb;
            sb.append("-instantiated");
        }

        public void start() {
            this.sb.append("-started");
        }

        public void stop() {
            this.sb.append("-stopped");
        }

        public void dispose() {
            this.sb.append("-disposed");
        }
    }

    public static class TestLifecycleComponent
    implements Startable {
        public boolean started;

        public void start() {
            this.started = true;
        }

        public void stop() {
        }
    }

    public static class TestLifecycleManager
    implements LifecycleManager {
        public ArrayList started = new ArrayList();

        public void start(PicoContainer node) {
            this.started.add(node);
        }

        public void stop(PicoContainer node) {
        }

        public void dispose(PicoContainer node) {
        }

        public boolean hasLifecycle() {
            return true;
        }
    }

    class Foo
    implements Startable,
    Disposable {
        public boolean started;
        public boolean stopped;
        public boolean disposed;

        Foo() {
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    public static class ContainerDependency {
        public ContainerDependency(PicoContainer container) {
            Assert.assertNotNull((Object)container);
        }
    }

    public static class ComponentF {
        public ComponentF(ComponentA a) {
            Assert.assertNotNull((Object)a);
        }
    }

    public static class ComponentE {
        public ComponentE(ComponentD d) {
            Assert.assertNotNull((Object)d);
        }
    }

    public static class ComponentD {
        public ComponentD(ComponentE e, ComponentB b) {
            Assert.assertNotNull((Object)e);
            Assert.assertNotNull((Object)b);
        }
    }

    public static class ComponentC {
    }

    public static class ComponentB {
    }

    public static class ComponentA {
        public ComponentA(ComponentB b, ComponentC c) {
            Assert.assertNotNull((Object)b);
            Assert.assertNotNull((Object)c);
        }
    }

    public static class JMSService {
        public final String serverid;
        public final String path;

        public JMSService(String serverid, String path) {
            this.serverid = serverid;
            this.path = path;
        }
    }

    public static class NeedsWashable {
        public Washable washable;

        public NeedsWashable(Washable washable) {
            this.washable = washable;
        }
    }

    public static class NeedsTouchable {
        public Touchable touchable;

        public NeedsTouchable(Touchable touchable) {
            this.touchable = touchable;
        }
    }

    public static class ListAdder {
        public ListAdder(Collection list) {
            list.add("something");
        }
    }
}

