/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.logging.store.factories;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.picocontainer.logging.store.LoggerStore;
import org.picocontainer.logging.store.LoggerStoreCreationException;
import org.picocontainer.logging.store.factories.AbstractLoggerStoreFactory;
import org.picocontainer.logging.store.stores.JdkLoggerStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkLoggerStoreFactory
extends AbstractLoggerStoreFactory {
    @Override
    protected LoggerStore doCreateLoggerStore(Map<String, Object> config) {
        try {
            Properties properties = (Properties)config.get(Properties.class.getName());
            if (null != properties) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                properties.store(output, "");
                ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
                return new JdkLoggerStore(input);
            }
            InputStream resource = this.getInputStream(config);
            if (null != resource) {
                return new JdkLoggerStore(resource);
            }
            return this.missingConfiguration();
        }
        catch (Exception e) {
            String message = "Failed to create logger store for configuration " + config;
            throw new LoggerStoreCreationException(message, e);
        }
    }
}

