/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.logging.store.factories;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.picocontainer.logging.store.LoggerStore;
import org.picocontainer.logging.store.LoggerStoreCreationException;
import org.picocontainer.logging.store.LoggerStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialLoggerStoreFactory
implements LoggerStoreFactory {
    public static final String INITIAL_FACTORY = "org.picocontainer.logging.store.factory";
    public static final String DEFAULT_PROPERTIES = "META-INF/picocontainer/loggerstore.properties";

    @Override
    public LoggerStore createLoggerStore(Map<String, Object> config) {
        ClassLoader classLoader = this.getClassLoader(config);
        String type = (String)config.get(INITIAL_FACTORY);
        Map<String, Object> data = config;
        if (null == type) {
            data = this.loadDefaultConfig(data, classLoader);
            type = (String)data.get(INITIAL_FACTORY);
        }
        LoggerStoreFactory factory = this.createLoggerStoreFactory(type, classLoader);
        return factory.createLoggerStore(data);
    }

    private ClassLoader getClassLoader(Map<String, Object> data) {
        ClassLoader loader = (ClassLoader)data.get(ClassLoader.class.getName());
        if (null == loader && null == (loader = Thread.currentThread().getContextClassLoader())) {
            loader = InitialLoggerStoreFactory.class.getClassLoader();
        }
        return loader;
    }

    private Map<String, Object> loadDefaultConfig(Map<String, Object> initial, ClassLoader classLoader) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration<URL> resources = classLoader.getResources(DEFAULT_PROPERTIES);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream stream = url.openStream();
                Properties properties = new Properties();
                properties.load(stream);
                Enumeration<Object> e = properties.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement().toString();
                    map.put(key, properties.getProperty(key));
                }
            }
            map.putAll(initial);
            return map;
        }
        catch (Exception e) {
            String message = "Failed to load initial configuration " + initial;
            throw new LoggerStoreCreationException(message, e);
        }
    }

    private LoggerStoreFactory createLoggerStoreFactory(String type, ClassLoader classLoader) {
        if (null == type) {
            String message = "No LoggerStoreFactory type specified.";
            throw new LoggerStoreCreationException("No LoggerStoreFactory type specified.");
        }
        try {
            return (LoggerStoreFactory)classLoader.loadClass(type).newInstance();
        }
        catch (Exception e) {
            String message = "Failed to created LoggerStoreFactory " + type;
            throw new LoggerStoreCreationException(message);
        }
    }
}

