/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.logging.store.stores;

import java.io.InputStream;
import java.util.logging.LogManager;
import org.picocontainer.logging.Logger;
import org.picocontainer.logging.loggers.JdkLogger;
import org.picocontainer.logging.store.LoggerStoreCreationException;
import org.picocontainer.logging.store.stores.AbstractLoggerStore;

public class JdkLoggerStore
extends AbstractLoggerStore {
    private final LogManager manager;

    public JdkLoggerStore(InputStream resource) {
        try {
            this.manager = LogManager.getLogManager();
            this.manager.readConfiguration(resource);
            this.setRootLogger(new JdkLogger(java.util.logging.Logger.getLogger("global")));
        }
        catch (Exception e) {
            String message = "Failed to create logger store for resource " + resource;
            throw new LoggerStoreCreationException(message, e);
        }
    }

    protected Logger createLogger(String name) {
        return new JdkLogger(java.util.logging.Logger.getLogger(name));
    }

    public void close() {
        this.manager.reset();
    }
}

