/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.logging.store.factories;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.picocontainer.logging.store.LoggerStore;
import org.picocontainer.logging.store.LoggerStoreCreationException;
import org.picocontainer.logging.store.LoggerStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoggerStoreFactory
implements LoggerStoreFactory {
    @Override
    public LoggerStore createLoggerStore(Map<String, Object> config) {
        LoggerStore loggerStore = this.doCreateLoggerStore(config);
        return loggerStore;
    }

    protected abstract LoggerStore doCreateLoggerStore(Map<String, Object> var1);

    protected LoggerStore missingConfiguration() {
        throw new LoggerStoreCreationException("Invalid configuration");
    }

    protected InputStream getInputStream(Map<String, Object> config) {
        try {
            String urlLocation = (String)config.get("org.picocontainer.logging.store.url");
            URL url = null;
            if (null != urlLocation) {
                url = new URL(urlLocation);
            }
            if (null == url) {
                url = (URL)config.get(URL.class.getName());
            }
            if (null != url) {
                return url.openStream();
            }
            String fileLocation = (String)config.get("org.picocontainer.logging.store.file");
            File file = null;
            if (null != fileLocation) {
                file = new File(fileLocation);
            }
            if (null == file) {
                file = (File)config.get(File.class.getName());
            }
            if (null != file) {
                return new FileInputStream(file);
            }
            return (InputStream)config.get(InputStream.class.getName());
        }
        catch (Exception e) {
            String message = "Failed to get input stream for configuration " + config;
            throw new LoggerStoreCreationException(message, e);
        }
    }
}

