/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.jmx;

import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;
import org.picocontainer.behaviors.Cached;
import org.picocontainer.gems.jmx.DynamicMBeanComponentProvider;
import org.picocontainer.gems.jmx.DynamicMBeanProvider;
import org.picocontainer.gems.jmx.JMXRegistrationException;
import org.picocontainer.gems.jmx.JMXRegistrationInfo;

public class JMXExposed
extends AbstractBehavior {
    private final MBeanServer mBeanServer;
    private final DynamicMBeanProvider[] providers;
    private List registeredObjectNames;

    public JMXExposed(ComponentAdapter delegate, MBeanServer mBeanServer, DynamicMBeanProvider[] providers) throws NullPointerException {
        super(delegate);
        if (mBeanServer == null || providers == null) {
            throw new NullPointerException();
        }
        this.mBeanServer = mBeanServer;
        this.providers = providers;
    }

    public JMXExposed(ComponentAdapter delegate, MBeanServer mBeanServer) throws NullPointerException {
        this(delegate, mBeanServer, new DynamicMBeanProvider[]{new DynamicMBeanComponentProvider()});
    }

    public Object getComponentInstance(PicoContainer container) throws PicoCompositionException {
        Cached componentAdapter = new Cached(this.getDelegate());
        Object componentInstance = componentAdapter.getComponentInstance(container);
        for (DynamicMBeanProvider provider : this.providers) {
            JMXRegistrationInfo info = provider.provide(container, (ComponentAdapter)componentAdapter);
            if (info == null) continue;
            JMException exception = null;
            try {
                this.mBeanServer.registerMBean(info.getMBean(), info.getObjectName());
            }
            catch (InstanceAlreadyExistsException e) {
                exception = e;
            }
            catch (MBeanRegistrationException e) {
                exception = e;
            }
            catch (NotCompliantMBeanException e) {
                exception = e;
            }
            if (null == this.registeredObjectNames) {
                this.registeredObjectNames = new ArrayList();
            }
            this.registeredObjectNames.add(info.getObjectName());
            if (exception == null) continue;
            throw new PicoCompositionException("Registering MBean failed", (Throwable)exception);
        }
        return componentInstance;
    }

    public String getDescriptor() {
        return "ExposedJMX";
    }

    public void dispose(Object component) {
        if (null != this.registeredObjectNames) {
            for (Object registeredObjectName : this.registeredObjectNames) {
                try {
                    this.mBeanServer.unregisterMBean((ObjectName)registeredObjectName);
                }
                catch (InstanceNotFoundException e) {
                    throw new JMXRegistrationException(e);
                }
                catch (MBeanRegistrationException e) {
                    throw new JMXRegistrationException(e);
                }
            }
        }
        if (super.hasLifecycle(this.getComponentImplementation())) {
            super.dispose(component);
        }
    }

    public boolean hasLifecycle(Class type) {
        return true;
    }
}

