/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.behaviors;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.gems.behaviors.HiddenImplementation;

public class HotSwappable
extends HiddenImplementation {
    private final Swappable swappable = new Swappable();
    private Object instance;

    public HotSwappable(ComponentAdapter delegate) {
        super(delegate);
    }

    protected Swappable getSwappable() {
        return this.swappable;
    }

    public Object swapRealInstance(Object instance) {
        return this.swappable.swap(instance);
    }

    public Object getRealInstance() {
        return this.swappable.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentInstance(PicoContainer container) {
        Swappable swappable = this.swappable;
        synchronized (swappable) {
            if (this.instance == null) {
                this.instance = super.getComponentInstance(container);
            }
        }
        return this.instance;
    }

    public String getDescriptor() {
        return "HotSwappable";
    }

    public static class Swappable {
        private transient Object delegate;

        public Object getInstance() {
            return this.delegate;
        }

        public Object swap(Object delegate) {
            Object old = this.delegate;
            this.delegate = delegate;
            return old;
        }
    }
}

