/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.InstanceComponentAdapter;

public class PicoMap
implements Map {
    private final MutablePicoContainer mutablePicoContainer;

    public PicoMap(MutablePicoContainer mutablePicoContainer) {
        this.mutablePicoContainer = mutablePicoContainer;
    }

    public PicoMap() {
        this.mutablePicoContainer = new DefaultPicoContainer();
    }

    public int size() {
        return this.mutablePicoContainer.getComponentAdapters().size();
    }

    public boolean isEmpty() {
        return this.mutablePicoContainer.getComponentAdapters().size() == 0;
    }

    public boolean containsKey(Object o) {
        if (o instanceof Class) {
            return this.mutablePicoContainer.getComponentInstanceOfType((Class)o) != null;
        }
        return this.mutablePicoContainer.getComponentInstance(o) != null;
    }

    public boolean containsValue(Object o) {
        return false;
    }

    public Object get(Object o) {
        if (o instanceof Class) {
            return this.mutablePicoContainer.getComponentInstanceOfType((Class)o);
        }
        return this.mutablePicoContainer.getComponentInstance(o);
    }

    public Object put(Object o, Object o1) {
        Object object = this.remove(o);
        if (o1 instanceof Class) {
            this.mutablePicoContainer.registerComponentImplementation(o, (Class)o1);
        } else {
            this.mutablePicoContainer.registerComponentInstance(o, o1);
        }
        return object;
    }

    public Object remove(Object o) {
        ComponentAdapter adapter = this.mutablePicoContainer.unregisterComponent(o);
        if (adapter != null) {
            return adapter instanceof InstanceComponentAdapter ? adapter.getComponentInstance((PicoContainer)this.mutablePicoContainer) : adapter.getComponentImplementation();
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        Set adapters = this.keySet();
        Iterator iter = adapters.iterator();
        while (iter.hasNext()) {
            this.mutablePicoContainer.unregisterComponent(iter.next());
        }
    }

    public Set keySet() {
        HashSet<Object> set = new HashSet<Object>();
        Collection adapters = this.mutablePicoContainer.getComponentAdapters();
        Iterator iter = adapters.iterator();
        while (iter.hasNext()) {
            ComponentAdapter adapter = (ComponentAdapter)iter.next();
            set.add(adapter.getComponentKey());
        }
        return Collections.unmodifiableSet(set);
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.mutablePicoContainer.getComponentInstances());
    }

    public Set entrySet() {
        HashSet<1> set = new HashSet<1>();
        Collection adapters = this.mutablePicoContainer.getComponentAdapters();
        Iterator iter = adapters.iterator();
        while (iter.hasNext()) {
            final Object key = ((ComponentAdapter)iter.next()).getComponentKey();
            final Object component = this.mutablePicoContainer.getComponentInstance(key);
            set.add(new Map.Entry(){

                public Object getKey() {
                    return key;
                }

                public Object getValue() {
                    return component;
                }

                public Object setValue(Object value) {
                    throw new UnsupportedOperationException("Cannot set component");
                }
            });
        }
        return Collections.unmodifiableSet(set);
    }
}

