/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.defaults.DelegatingComponentMonitor;

public class DotDependencyGraphComponentMonitor
extends DelegatingComponentMonitor
implements ComponentMonitor {
    ArrayList allInstantiated = new ArrayList();

    public DotDependencyGraphComponentMonitor(ComponentMonitor delegate) {
        super(delegate);
    }

    public DotDependencyGraphComponentMonitor() {
    }

    public void instantiated(Constructor constructor, Object instantiated, Object[] injected, long duration) {
        this.allInstantiated.add(new Instantiation(constructor, instantiated, injected, duration));
        super.instantiated(constructor, instantiated, injected, duration);
    }

    public String getClassDependencyGraph() {
        HashSet<String> lines = new HashSet<String>();
        for (int i = 0; i < this.allInstantiated.size(); ++i) {
            Instantiation instantiation = (Instantiation)this.allInstantiated.get(i);
            for (int j = 0; j < instantiation.getInjected().length; ++j) {
                Object instantiated = instantiation.getInstantiated();
                Object injected = instantiation.getInjected()[j];
                lines.add("  '" + instantiated.getClass().getName() + "' -> '" + injected.getClass().getName() + "';\n");
            }
        }
        return this.sortLines(lines);
    }

    private String sortLines(HashSet lines) {
        ArrayList list = new ArrayList(lines);
        Collections.sort(list);
        String dependencies = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String dep = (String)iterator.next();
            dependencies = dependencies + dep;
        }
        return dependencies.replaceAll("'", "\"");
    }

    public String getInterfaceDependencyGraph() {
        HashSet<String> lines = new HashSet<String>();
        for (int i = 0; i < this.allInstantiated.size(); ++i) {
            Instantiation instantiation = (Instantiation)this.allInstantiated.get(i);
            for (int j = 0; j < instantiation.getInjected().length; ++j) {
                Object injected = instantiation.getInjected()[j];
                Class<?> injectedType = instantiation.getConstructor().getParameterTypes()[j];
                Object instantiated = instantiation.getInstantiated();
                if (injected.getClass() != injectedType) {
                    lines.add("  '" + instantiated.getClass().getName() + "' -> '" + injectedType.getName() + "' [style=dotted,label='needs'];\n");
                    lines.add("  '" + injected.getClass().getName() + "' -> '" + injectedType.getName() + "' [style=dotted, color=red,label='isA'];\n");
                    lines.add("  '" + injectedType.getName() + "' [shape=box, label=" + this.printClassName(injectedType) + "];\n");
                } else {
                    lines.add("  '" + instantiated.getClass().getName() + "' -> '" + injected.getClass().getName() + "' [label='needs'];\n");
                }
                lines.add("  '" + instantiated.getClass().getName() + "' [label=" + this.printClassName(instantiated.getClass()) + "];\n");
            }
        }
        return this.sortLines(lines);
    }

    private String printClassName(Class clazz) {
        String className = clazz.getName();
        return "'" + className.substring(className.lastIndexOf(".") + 1) + "\\n" + clazz.getPackage().getName() + "'";
    }

    private static class Instantiation {
        Constructor constructor;
        Object instantiated;
        Object[] injected;
        long duration;

        public Instantiation(Constructor constructor, Object instantiated, Object[] injected, long duration) {
            this.constructor = constructor;
            this.instantiated = instantiated;
            this.injected = injected;
            this.duration = duration;
        }

        public Constructor getConstructor() {
            return this.constructor;
        }

        public Object getInstantiated() {
            return this.instantiated;
        }

        public Object[] getInjected() {
            return this.injected;
        }
    }
}

