/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.adapters;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.kit.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.gems.adapters.ThreadLocalReference;

public class ThreadLocalComponentAdapter
extends DecoratingComponentAdapter {
    private transient Class[] interfaces;
    private ProxyFactory proxyFactory;

    public ThreadLocalComponentAdapter(ComponentAdapter delegate, ProxyFactory proxyFactory) throws PicoIntrospectionException {
        super((ComponentAdapter)new CachingComponentAdapter(delegate, (ObjectReference)new ThreadLocalReference()));
        this.proxyFactory = proxyFactory;
        this.interfaces = this.getInterfaces();
    }

    public ThreadLocalComponentAdapter(ComponentAdapter delegate) throws PicoIntrospectionException {
        this((ComponentAdapter)new CachingComponentAdapter(delegate, (ObjectReference)new ThreadLocalReference()), (ProxyFactory)new StandardProxyFactory());
    }

    public Object getComponentInstance(PicoContainer pico) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces();
        }
        ComponentAdapter delegate = this.getDelegate();
        ThreadLocalInvoker invoker = new ThreadLocalInvoker(pico, delegate);
        return this.proxyFactory.createProxy(this.interfaces, (Invoker)invoker);
    }

    private final Class[] getInterfaces() {
        Class[] interfaces;
        Object componentKey = this.getComponentKey();
        if (componentKey instanceof Class && ((Class)componentKey).isInterface()) {
            interfaces = new Class[]{(Class)componentKey};
        } else {
            Set allInterfaces = ReflectionUtils.getAllInterfaces((Class)this.getComponentImplementation());
            interfaces = allInterfaces.toArray(new Class[allInterfaces.size()]);
        }
        if (interfaces.length == 0) {
            throw new PicoIntrospectionException("Can't proxy implementation for " + this.getComponentImplementation().getName() + ". It does not implement any interfaces.");
        }
        return interfaces;
    }

    private static final class ThreadLocalInvoker
    implements Invoker {
        private final PicoContainer pico;
        private final ComponentAdapter delegate;

        private ThreadLocalInvoker(PicoContainer pico, ComponentAdapter delegate) {
            this.pico = pico;
            this.delegate = delegate;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object delegatedInstance = this.delegate.getComponentInstance(this.pico);
            if (method.equals(ReflectionUtils.equals)) {
                return new Boolean(args[0] != null && args[0].equals(delegatedInstance));
            }
            try {
                return method.invoke(delegatedInstance, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

