/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.adapters;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.toys.delegate.Delegating;
import java.lang.reflect.Method;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.DecoratingComponentAdapter;

public class AssimilatingComponentAdapter
extends DecoratingComponentAdapter {
    private Class type;
    private ProxyFactory proxyFactory;
    private boolean isCompatible;

    public AssimilatingComponentAdapter(Class type, ComponentAdapter delegate, ProxyFactory proxyFactory) throws PicoIntrospectionException {
        super(delegate);
        this.type = type;
        this.proxyFactory = proxyFactory;
        Class delegationType = delegate.getComponentImplementation();
        this.isCompatible = type.isAssignableFrom(delegationType);
        if (!this.isCompatible) {
            if (!proxyFactory.canProxy(type)) {
                throw new PicoIntrospectionException("Cannot create proxy for type " + type.getName());
            }
            Method[] methods = type.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                try {
                    delegationType.getMethod(method.getName(), method.getParameterTypes());
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new PicoIntrospectionException("Cannot create proxy for type " + type.getName() + ", because of incompatible method " + method.toString());
                }
            }
        }
    }

    public AssimilatingComponentAdapter(Class type, ComponentAdapter delegate) {
        this(type, delegate, (ProxyFactory)new StandardProxyFactory());
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
        return this.isCompatible ? super.getComponentInstance(container) : Delegating.object((Class)this.type, (Object)super.getComponentInstance(container), (ProxyFactory)this.proxyFactory);
    }

    public Class getComponentImplementation() {
        return this.isCompatible ? super.getComponentImplementation() : this.type;
    }

    public Object getComponentKey() {
        Object key = super.getComponentKey();
        if (!(!(key instanceof Class) || this.isCompatible && this.type.isAssignableFrom((Class)key))) {
            return this.type;
        }
        return key;
    }
}

