/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.lifecycle;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.lifecycle.StartableLifecycleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeLifecycleStrategy
implements LifecycleStrategy {
    private final StartableLifecycleStrategy[] alternateStrategies;

    public CompositeLifecycleStrategy(StartableLifecycleStrategy ... alternateStrategies) {
        this.alternateStrategies = alternateStrategies;
    }

    @Override
    public void start(Object component) {
        for (StartableLifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            lifecycleStrategy.start(component);
        }
    }

    @Override
    public void stop(Object component) {
        for (StartableLifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            lifecycleStrategy.stop(component);
        }
    }

    @Override
    public void dispose(Object component) {
        for (StartableLifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            lifecycleStrategy.dispose(component);
        }
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        for (StartableLifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            if (!lifecycleStrategy.hasLifecycle(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLazy(ComponentAdapter<?> adapter) {
        for (StartableLifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            if (!lifecycleStrategy.isLazy(adapter)) continue;
            return true;
        }
        return false;
    }
}

