/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.ldap.internal.LDAPCustomAttributes;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;

public abstract class LDAPEntry
implements DirContext,
IdentityType {
    private static final long serialVersionUID = 1L;
    private Attributes attributes = new BasicAttributes(true);
    private LDAPCustomAttributes customAttributes = new LDAPCustomAttributes();
    private String dnSuffix;
    private boolean enabled = true;
    private Date expirationDate;
    private Date createDate = new Date();

    public LDAPEntry(String dnSuffix) {
        this.dnSuffix = dnSuffix;
    }

    public String getDN() {
        try {
            return this.getDN(this.getLDAPAttributes().get(this.doGetAttributeForBinding()).get().toString());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String doGetAttributeForBinding() {
        return "cn";
    }

    public String getDN(String name) {
        return this.doGetAttributeForBinding() + "=" + name + "," + this.dnSuffix;
    }

    protected void addAllLDAPAttributes(Attributes theAttributes) {
        if (theAttributes != null) {
            NamingEnumeration<? extends javax.naming.directory.Attribute> ne = theAttributes.getAll();
            try {
                while (ne.hasMore()) {
                    javax.naming.directory.Attribute att = ne.next();
                    this.attributes.put(att);
                }
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Attributes getLDAPAttributes() {
        return this.attributes;
    }

    protected void setLDAPAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public Attributes getAttributes(Name name, String[] ids) throws NamingException {
        return this.getAttributes(name.toString(), ids);
    }

    @Override
    public Attributes getAttributes(String name, String[] ids) throws NamingException {
        if (!name.equals("")) {
            throw new NameNotFoundException();
        }
        BasicAttributes answer = new BasicAttributes(true);
        for (int i = 0; i < ids.length; ++i) {
            javax.naming.directory.Attribute target = this.attributes.get(ids[i]);
            if (target == null) continue;
            answer.put(target);
        }
        return answer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Date getCreatedDate() {
        return this.createDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createDate = createdDate;
    }

    public void setAttribute(Attribute<? extends Serializable> attribute) {
        Serializable value = attribute.getValue();
        this.getLDAPAttributes().put(attribute.getName(), value);
        this.getCustomAttributes().addAttribute(attribute.getName(), value);
    }

    public void removeAttribute(String name) {
        this.getLDAPAttributes().remove(name);
        this.getCustomAttributes().removeAttribute(name);
    }

    public LDAPCustomAttributes getCustomAttributes() {
        if (this.customAttributes == null) {
            this.customAttributes = new LDAPCustomAttributes();
        }
        this.customAttributes.addAttribute("enabled", String.valueOf(this.isEnabled()));
        this.customAttributes.addAttribute("createDate", String.valueOf(this.getCreatedDate().getTime()));
        if (this.expirationDate != null) {
            this.customAttributes.addAttribute("expiryDate", String.valueOf(this.getExpirationDate().getTime()));
        }
        return this.customAttributes;
    }

    public void setCustomAttributes(LDAPCustomAttributes customAttributes) {
        this.customAttributes = customAttributes;
        if (this.customAttributes != null) {
            Object enabledAttribute = this.customAttributes.getAttribute("enabled");
            Object createDateAttribute = this.customAttributes.getAttribute("createDate");
            Object expiryDateAttribute = this.customAttributes.getAttribute("expiryDate");
            if (enabledAttribute != null) {
                this.enabled = Boolean.valueOf(enabledAttribute.toString());
            }
            if (createDateAttribute != null) {
                this.createDate = new Date(Long.valueOf(createDateAttribute.toString()));
            }
            if (expiryDateAttribute != null) {
                this.expirationDate = new Date(Long.valueOf(expiryDateAttribute.toString()));
            }
        }
    }

    public <T extends Serializable> Attribute<T> getAttribute(String name) {
        try {
            javax.naming.directory.Attribute theAttribute = this.attributes.get(name);
            Object value = null;
            if (theAttribute != null) {
                value = theAttribute.get();
            } else if (this.customAttributes.getAttributes().containsKey(name)) {
                value = this.customAttributes.getAttribute(name);
            } else {
                return null;
            }
            return new Attribute(name, (Serializable)value);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<Attribute<? extends Serializable>> getAttributes() {
        try {
            ArrayList<Attribute<? extends Serializable>> attribs = new ArrayList<Attribute<? extends Serializable>>();
            NamingEnumeration<? extends javax.naming.directory.Attribute> theAttributes = this.getLDAPAttributes().getAll();
            while (theAttributes.hasMore()) {
                javax.naming.directory.Attribute anAttribute = theAttributes.next();
                NamingEnumeration<?> ne = anAttribute.getAll();
                ArrayList<String> theList = new ArrayList<String>();
                while (ne.hasMoreElements()) {
                    String val = null;
                    Object obj = ne.next();
                    val = obj instanceof byte[] ? new String(Base64.encodeBytes((byte[])obj)) : (String)obj;
                    theList.add(val);
                }
                String[] valuesArr = new String[theList.size()];
                theList.toArray(valuesArr);
                attribs.add((Attribute<? extends Serializable>)new Attribute(anAttribute.getID(), (Serializable)valuesArr));
            }
            Map<String, Object> customAttributes = this.getCustomAttributes().getAttributes();
            Set<Map.Entry<String, Object>> entrySet = customAttributes.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                attribs.add((Attribute<? extends Serializable>)new Attribute(entry.getKey(), (Serializable)entry.getValue()));
            }
            return attribs;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void addMember(LDAPEntry childEntry) {
        javax.naming.directory.Attribute memberAttribute = this.getLDAPAttributes().get("member");
        if (memberAttribute != null) {
            if (memberAttribute.contains(" ")) {
                memberAttribute.remove(" ");
            }
        } else {
            memberAttribute = new BasicAttribute("member");
        }
        memberAttribute.add(childEntry.getDN());
        this.getLDAPAttributes().put(memberAttribute);
    }

    public boolean isMember(LDAPEntry member) {
        javax.naming.directory.Attribute memberAttribute = this.getLDAPAttributes().get("member");
        return memberAttribute != null && memberAttribute.contains(member.getDN());
    }

    public void removeMember(LDAPEntry childEntry) {
        javax.naming.directory.Attribute memberAttribute = this.getLDAPAttributes().get("member");
        if (memberAttribute != null) {
            memberAttribute.remove(childEntry.getDN());
        }
        try {
            if (!memberAttribute.getAll().hasMoreElements()) {
                memberAttribute.add(" ");
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public Partition getPartition() {
        return null;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return null;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return null;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
    }

    @Override
    public void unbind(Name name) throws NamingException {
    }

    @Override
    public void unbind(String name) throws NamingException {
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return null;
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return null;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return null;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return null;
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.attributes;
    }

    public void setDnSuffix(String dnSuffix) {
        this.dnSuffix = dnSuffix;
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return null;
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return null;
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return null;
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return null;
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return null;
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return null;
    }

    public String getDnSuffix() {
        return this.dnSuffix;
    }

    public void setPartition(Partition partition) {
    }
}

