/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.query.QueryParameter;

public class RoleHandler
extends IdentityTypeHandler<Role> {
    @Override
    protected void doPopulateIdentityInstance(Object toIdentity, Role fromRole, JPAIdentityStore store) {
        store.setModelProperty(toIdentity, "IDENTITY_NAME", fromRole.getName(), true);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Role fromIdentityType, JPAIdentityStore store) {
        return new RoleCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Role fromIdentityType, JPAIdentityStore store) {
        return new RoleUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Role fromIdentityType, JPAIdentityStore store) {
        return new RoleDeletedEvent(fromIdentityType);
    }

    @Override
    protected Role doCreateIdentityType(Object identity, JPAIdentityStore store) {
        String name = store.getModelProperty(String.class, identity, "IDENTITY_NAME");
        SimpleRole role = new SimpleRole(name);
        return role;
    }

    @Override
    public List<Predicate> getPredicate(QueryParameter queryParameter, Object[] parameterValues, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(queryParameter, parameterValues, criteria, store);
        if (queryParameter.equals(Role.NAME)) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty("IDENTITY_NAME").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.ROLE_OF)) {
            for (Object object : parameterValues) {
                Property<Object> memberModelProperty = store.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
                Property<Object> roleModelProperty = store.getConfig().getModelProperty("MEMBERSHIP_ROLE");
                Subquery subquery = criteria.getCriteria().subquery(store.getConfig().getMembershipClass());
                Root fromProject = subquery.from(store.getConfig().getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(roleModelProperty.getName()));
                Predicate conjunction = criteria.getBuilder().conjunction();
                conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(roleModelProperty.getName()), criteria.getRoot()));
                conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(memberModelProperty.getName()), store.lookupIdentityObjectById((IdentityType)object)));
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
            }
        }
        return predicates;
    }
}

