/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.query.QueryParameter;

public abstract class IdentityTypeHandler<T extends IdentityType> {
    public T createIdentityType(Realm realm, Object identity, JPAIdentityStore store) {
        T identityType = this.doCreateIdentityType(identity, store);
        identityType.setEnabled(store.getModelProperty(Boolean.class, identity, "IDENTITY_ENABLED").booleanValue());
        identityType.setExpirationDate(store.getModelProperty(Date.class, identity, "IDENTITY_EXPIRES"));
        identityType.setCreatedDate(store.getModelProperty(Date.class, identity, "IDENTITY_CREATED"));
        return identityType;
    }

    public Object createIdentityInstance(Realm realm, T fromIdentityType, JPAIdentityStore store) {
        Object identity = null;
        try {
            identity = store.getConfig().getIdentityClass().newInstance();
            this.populateIdentityInstance(realm, identity, fromIdentityType, store);
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating/populating Identity instance from IdentityType.", (Throwable)e);
        }
        return identity;
    }

    protected void populateIdentityInstance(Realm realm, Object toIdentity, T fromIdentityType, JPAIdentityStore store) {
        String identityDiscriminator = store.getConfig().getIdentityDiscriminator(fromIdentityType.getClass());
        store.setModelProperty(toIdentity, "IDENTITY_DISCRIMINATOR", identityDiscriminator, true);
        store.setModelProperty(toIdentity, "IDENTITY_KEY", fromIdentityType.getKey(), true);
        store.setModelProperty(toIdentity, "IDENTITY_ENABLED", fromIdentityType.isEnabled(), true);
        store.setModelProperty(toIdentity, "IDENTITY_CREATED", fromIdentityType.getCreatedDate(), true);
        store.setModelProperty(toIdentity, "IDENTITY_EXPIRES", fromIdentityType.getExpirationDate());
        if (realm != null) {
            store.setModelProperty(toIdentity, "IDENTITY_PARTITION", store.lookupPartitionObject((Partition)realm));
        }
        this.doPopulateIdentityInstance(toIdentity, fromIdentityType, store);
    }

    void remove(Object identity, T identityType, JPAIdentityStore store) {
    }

    public List<Predicate> getPredicate(QueryParameter queryParameter, Object[] parameterValues, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        JPAIdentityStoreConfiguration storeConfig = store.getConfig();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (queryParameter.equals(IdentityType.ENABLED)) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(storeConfig.getModelProperty("IDENTITY_ENABLED").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.CREATED_DATE)) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(storeConfig.getModelProperty("IDENTITY_CREATED").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.EXPIRY_DATE)) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(storeConfig.getModelProperty("IDENTITY_EXPIRES").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.CREATED_AFTER)) {
            predicates.add(criteria.getBuilder().greaterThanOrEqualTo((Expression)criteria.getRoot().get(storeConfig.getModelProperty("IDENTITY_CREATED").getName()), (Comparable)((Date)parameterValues[0])));
        }
        if (queryParameter.equals(IdentityType.EXPIRY_AFTER)) {
            predicates.add(criteria.getBuilder().greaterThanOrEqualTo((Expression)criteria.getRoot().get(storeConfig.getModelProperty("IDENTITY_EXPIRES").getName()), (Comparable)((Date)parameterValues[0])));
        }
        if (queryParameter.equals(IdentityType.CREATED_BEFORE)) {
            predicates.add(criteria.getBuilder().lessThanOrEqualTo((Expression)criteria.getRoot().get(storeConfig.getModelProperty("IDENTITY_CREATED").getName()), (Comparable)((Date)parameterValues[0])));
        }
        if (queryParameter.equals(IdentityType.EXPIRY_BEFORE)) {
            predicates.add(criteria.getBuilder().lessThanOrEqualTo((Expression)criteria.getRoot().get(storeConfig.getModelProperty("IDENTITY_EXPIRES").getName()), (Comparable)((Date)parameterValues[0])));
        }
        if (queryParameter instanceof IdentityType.AttributeParameter) {
            IdentityType.AttributeParameter customParameter = (IdentityType.AttributeParameter)queryParameter;
            Subquery subquery = criteria.getCriteria().subquery(storeConfig.getAttributeClass());
            Root fromProject = subquery.from(storeConfig.getAttributeClass());
            Subquery select = subquery.select((Expression)fromProject.get(storeConfig.getModelProperty("ATTRIBUTE_IDENTITY").getName()));
            Predicate conjunction = criteria.getBuilder().conjunction();
            conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(storeConfig.getModelProperty("ATTRIBUTE_NAME").getName()), (Object)customParameter.getName()));
            conjunction.getExpressions().add(fromProject.get(storeConfig.getModelProperty("ATTRIBUTE_VALUE").getName()).in(parameterValues));
            subquery.where((Expression)conjunction);
            subquery.groupBy(new Expression[]{subquery.getSelection()}).having((Expression)criteria.getBuilder().equal(criteria.getBuilder().count(subquery.getSelection()), (Object)parameterValues.length));
            predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
        }
        return predicates;
    }

    protected abstract T doCreateIdentityType(Object var1, JPAIdentityStore var2);

    protected abstract void doPopulateIdentityInstance(Object var1, T var2, JPAIdentityStore var3);

    protected abstract AbstractBaseEvent raiseCreatedEvent(T var1, JPAIdentityStore var2);

    protected abstract AbstractBaseEvent raiseUpdatedEvent(T var1, JPAIdentityStore var2);

    protected abstract AbstractBaseEvent raiseDeletedEvent(T var1, JPAIdentityStore var2);
}

