/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.AgentCreatedEvent;
import org.picketlink.idm.event.AgentDeletedEvent;
import org.picketlink.idm.event.AgentUpdatedEvent;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.query.QueryParameter;

public class AgentHandler
extends IdentityTypeHandler<Agent> {
    @Override
    protected void doPopulateIdentityInstance(Object toIdentity, Agent fromUser, JPAIdentityStore store) {
        store.setModelProperty(toIdentity, "IDENTITY_ID", fromUser.getId(), true);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Agent fromIdentityType, JPAIdentityStore store) {
        return new AgentCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Agent fromIdentityType, JPAIdentityStore store) {
        return new AgentUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Agent fromIdentityType, JPAIdentityStore store) {
        return new AgentDeletedEvent(fromIdentityType);
    }

    @Override
    protected Agent doCreateIdentityType(Object identity, JPAIdentityStore store) {
        String idValue = store.getConfig().getModelProperty("IDENTITY_ID").getValue(identity).toString();
        SimpleAgent agent = new SimpleAgent(idValue);
        return agent;
    }

    @Override
    public List<Predicate> getPredicate(QueryParameter queryParameter, Object[] parameterValues, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        Property<Object> roleModelProperty;
        Property<Object> memberModelProperty;
        JPAIdentityStoreConfiguration storeConfig = store.getConfig();
        List<Predicate> predicates = super.getPredicate(queryParameter, parameterValues, criteria, store);
        CriteriaBuilder builder = criteria.getBuilder();
        Root<?> root = criteria.getRoot();
        if (queryParameter.equals(Agent.ID)) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(storeConfig.getModelProperty("IDENTITY_ID").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.HAS_GROUP_ROLE)) {
            for (Object object : parameterValues) {
                GroupRole groupRole = (GroupRole)object;
                memberModelProperty = storeConfig.getModelProperty("MEMBERSHIP_MEMBER");
                roleModelProperty = storeConfig.getModelProperty("MEMBERSHIP_ROLE");
                Property<Object> groupModelProperty = storeConfig.getModelProperty("MEMBERSHIP_GROUP");
                Subquery subquery = criteria.getCriteria().subquery(storeConfig.getMembershipClass());
                Root fromProject = subquery.from(storeConfig.getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(memberModelProperty.getName()));
                Predicate conjunction = builder.conjunction();
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(memberModelProperty.getName()), root));
                if (groupRole.getMember() != null) {
                    conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(memberModelProperty.getName()), store.lookupIdentityObjectById(groupRole.getMember())));
                }
                if (groupRole.getRole() != null) {
                    conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(roleModelProperty.getName()), store.lookupIdentityObjectById((IdentityType)groupRole.getRole())));
                }
                if (groupRole.getGroup() != null) {
                    conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(groupModelProperty.getName()), store.lookupIdentityObjectById((IdentityType)groupRole.getGroup())));
                }
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)builder.in(root).value((Expression)subquery));
            }
        }
        if (queryParameter.equals(IdentityType.MEMBER_OF)) {
            for (Object object : parameterValues) {
                Property<Object> memberModelProperty2 = storeConfig.getModelProperty("MEMBERSHIP_MEMBER");
                Property<Object> groupModelProperty = storeConfig.getModelProperty("MEMBERSHIP_GROUP");
                Subquery subquery = criteria.getCriteria().subquery(storeConfig.getMembershipClass());
                Root fromProject = subquery.from(storeConfig.getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(memberModelProperty2.getName()));
                Predicate conjunction = builder.conjunction();
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(memberModelProperty2.getName()), root));
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(groupModelProperty.getName()), store.lookupIdentityObjectById((IdentityType)new SimpleGroup(object.toString()))));
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)builder.in(root).value((Expression)subquery));
            }
        }
        if (queryParameter.equals(IdentityType.HAS_ROLE)) {
            for (Object object : parameterValues) {
                String roleName = (String)parameterValues[0];
                memberModelProperty = storeConfig.getModelProperty("MEMBERSHIP_MEMBER");
                roleModelProperty = storeConfig.getModelProperty("MEMBERSHIP_ROLE");
                Subquery subquery = criteria.getCriteria().subquery(storeConfig.getMembershipClass());
                Root fromProject = subquery.from(storeConfig.getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(memberModelProperty.getName()));
                Predicate conjunction = builder.conjunction();
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(memberModelProperty.getName()), root));
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(roleModelProperty.getName()), store.lookupIdentityObjectById((IdentityType)new SimpleRole(object.toString()))));
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)builder.in(root).value((Expression)subquery));
            }
        }
        return predicates;
    }
}

