/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;

public class AbstractJDBCRegistry {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected DataSource dataSource;

    public AbstractJDBCRegistry() {
        this("java:comp/env", "jdbc/picketlink-sts");
    }

    public AbstractJDBCRegistry(String jndiName) {
        this("java:comp/env", jndiName);
    }

    public AbstractJDBCRegistry(String envName, String jndiName) {
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup(envName);
            this.dataSource = (DataSource)envContext.lookup(jndiName);
            if (this.dataSource == null) {
                throw logger.datasourceIsNull();
            }
        }
        catch (NamingException e) {
            throw logger.jbdcInitializationError((Throwable)e);
        }
    }

    protected void safeClose(AutoCloseable auto) {
        if (auto != null) {
            try {
                auto.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

