/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.util.SAMLParserUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.w3c.dom.Element;

public class SAMLSubjectParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
        SubjectType subject = new SubjectType();
        while (xmlEventReader.hasNext()) {
            SubjectType.STSubType subType;
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xmlEvent;
                if (StaxParserUtil.matches((EndElement)endElement, (String)JBossSAMLConstants.SUBJECT.get())) {
                    endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName((EndElement)endElement));
            }
            StartElement peekedElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (peekedElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)peekedElement);
            if (JBossSAMLConstants.NAMEID.get().equalsIgnoreCase(tag)) {
                NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                subType = new SubjectType.STSubType();
                subType.addBaseID(nameID);
                subject.setSubType(subType);
                continue;
            }
            if (JBossSAMLConstants.BASEID.get().equalsIgnoreCase(tag)) {
                throw new ParsingException("PL00069: Parser: Type not supported:" + JBossSAMLConstants.BASEID.get());
            }
            if (JBossSAMLConstants.ENCRYPTED_ID.get().equals(tag)) {
                Element domElement = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                subType = new SubjectType.STSubType();
                subType.setEncryptedID(new EncryptedElementType(domElement));
                subject.setSubType(subType);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT_CONFIRMATION.get().equalsIgnoreCase(tag)) {
                StartElement subjectConfirmationElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                Attribute method = subjectConfirmationElement.getAttributeByName(new QName(JBossSAMLConstants.METHOD.get()));
                SubjectConfirmationType subjectConfirmationType = new SubjectConfirmationType();
                if (method != null) {
                    subjectConfirmationType.setMethod(StaxParserUtil.getAttributeValue((Attribute)method));
                }
                xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
                while (xmlEventReader.hasNext()) {
                    xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
                    if (xmlEvent instanceof EndElement) {
                        EndElement endElement = (EndElement)xmlEvent;
                        if (StaxParserUtil.matches((EndElement)endElement, (String)JBossSAMLConstants.SUBJECT_CONFIRMATION.get())) {
                            StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                            break;
                        }
                        throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName((EndElement)endElement));
                    }
                    peekedElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
                    if (peekedElement == null) break;
                    String startTag = StaxParserUtil.getStartElementName((StartElement)peekedElement);
                    if (startTag.equals(JBossSAMLConstants.NAMEID.get())) {
                        NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                        subjectConfirmationType.setNameID(nameID);
                        continue;
                    }
                    if (JBossSAMLConstants.BASEID.get().equalsIgnoreCase(tag)) {
                        throw logger.unsupportedType(JBossSAMLConstants.BASEID.get());
                    }
                    if (JBossSAMLConstants.ENCRYPTED_ID.get().equals(tag)) {
                        Element domElement = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                        subjectConfirmationType.setEncryptedID(new EncryptedElementType(domElement));
                        continue;
                    }
                    if (!startTag.equals(JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get())) continue;
                    SubjectConfirmationDataType subjectConfirmationData = this.parseSubjectConfirmationData(xmlEventReader);
                    subjectConfirmationType.setSubjectConfirmationData(subjectConfirmationData);
                }
                subject.addConfirmation(subjectConfirmationType);
                continue;
            }
            throw logger.parserUnknownTag(tag, peekedElement.getLocation());
        }
        return subject;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.SUBJECT.get());
    }

    private SubjectConfirmationDataType parseSubjectConfirmationData(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        Attribute address;
        Attribute recipient;
        Attribute notOnOrAfter;
        Attribute notBefore;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        Attribute inResponseTo = startElement.getAttributeByName(new QName(JBossSAMLConstants.IN_RESPONSE_TO.get()));
        if (inResponseTo != null) {
            subjectConfirmationData.setInResponseTo(StaxParserUtil.getAttributeValue((Attribute)inResponseTo));
        }
        if ((notBefore = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_BEFORE.get()))) != null) {
            subjectConfirmationData.setNotBefore(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)notBefore)));
        }
        if ((notOnOrAfter = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_ON_OR_AFTER.get()))) != null) {
            subjectConfirmationData.setNotOnOrAfter(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)notOnOrAfter)));
        }
        if ((recipient = startElement.getAttributeByName(new QName(JBossSAMLConstants.RECIPIENT.get()))) != null) {
            subjectConfirmationData.setRecipient(StaxParserUtil.getAttributeValue((Attribute)recipient));
        }
        if ((address = startElement.getAttributeByName(new QName(JBossSAMLConstants.ADDRESS.get()))) != null) {
            subjectConfirmationData.setAddress(StaxParserUtil.getAttributeValue((Attribute)address));
        }
        if (!((xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) instanceof EndElement)) {
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("KeyInfo")) {
                KeyInfoType keyInfo = SAMLParserUtil.parseKeyInfo(xmlEventReader);
                subjectConfirmationData.setAnyType(keyInfo);
            } else if (tag.equals("EncryptedKey")) {
                subjectConfirmationData.setAnyType(StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader));
            } else {
                throw logger.parserUnknownTag(tag, startElement.getLocation());
            }
        }
        EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
        StaxParserUtil.matches((EndElement)endElement, (String)JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        return subjectConfirmationData;
    }
}

