/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.client;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.client.SecurityClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityClientFactory {
    private static String defaultClient = "org.jboss.security.client.JBossSecurityClient";

    public static SecurityClient getSecurityClient() throws Exception {
        return SecurityClientFactory.getSC(defaultClient);
    }

    public static SecurityClient getSecurityClient(String client) throws Exception {
        return SecurityClientFactory.getSC(client);
    }

    public static SecurityClient getSecurityClient(Class<?> clazz) throws Exception {
        if (!SecurityClient.class.isAssignableFrom(clazz)) {
            throw PicketBoxMessages.MESSAGES.invalidType(SecurityClient.class.getName());
        }
        Constructor<?> ctr = clazz.getConstructor(new Class[0]);
        return (SecurityClient)ctr.newInstance(new Object[0]);
    }

    private static SecurityClient getSC(final String client) throws PrivilegedActionException {
        return (SecurityClient)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(client);
                return clazz.newInstance();
            }
        });
    }
}

