/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.plugins;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

            @Override
            public ClassLoader run() throws Exception {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    static void setSystemProperty(final String key, final String value) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty(key, value);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static SecurityContext createSecurityContext(final String name) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)name);
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static void register(final SecurityContext sc, final Principal principal, final Object credential, final Subject subject) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.getUtil().createSubjectInfo(principal, credential, subject);
                return null;
            }
        });
    }
}

