/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.jboss.crypto.digest.DigestCallback;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.callback.MapCallback;

public class RFC2617Digest
implements DigestCallback {
    public static final String REALM = "realm";
    public static final String USERNAME = "username";
    public static final String DIGEST_URI = "digest-uri";
    public static final String NONCE = "nonce";
    public static final String CNONCE = "cnonce";
    public static final String NONCE_COUNT = "nc";
    public static final String QOP = "qop";
    public static final String ALGORITHM = "algorithm";
    public static final String AUTH_PARAM = "auth-param";
    public static final String METHOD = "method";
    public static final String A2HASH = "a2hash";
    private static char[] MD5_HEX = "0123456789abcdef".toCharArray();
    private MapCallback info;
    private String username;
    private String password;
    private boolean passwordIsA1Hash;
    String rfc2617;

    public void init(Map options) {
        this.username = (String)options.get("javax.security.auth.login.name");
        this.password = (String)options.get("javax.security.auth.login.password");
        String flag = (String)options.get("passwordIsA1Hash");
        if (flag != null) {
            this.passwordIsA1Hash = Boolean.valueOf(flag);
        }
        this.info = new MapCallback();
        Callback[] callbacks = new Callback[]{this.info};
        options.put("callbacks", callbacks);
    }

    @Override
    public void preDigest(MessageDigest digest) {
    }

    @Override
    public void postDigest(MessageDigest digest) {
        String extra;
        String A1;
        String qop = (String)this.info.getInfo(QOP);
        String realm = (String)this.info.getInfo(REALM);
        String algorithm = (String)this.info.getInfo(ALGORITHM);
        String nonce = (String)this.info.getInfo(NONCE);
        String cnonce = (String)this.info.getInfo(CNONCE);
        String method = (String)this.info.getInfo(METHOD);
        String nc = (String)this.info.getInfo(NONCE_COUNT);
        String digestURI = (String)this.info.getInfo(DIGEST_URI);
        if (algorithm == null) {
            algorithm = digest.getAlgorithm();
        }
        digest.reset();
        String hA1 = null;
        if (algorithm == null || algorithm.equals("MD5")) {
            if (this.passwordIsA1Hash) {
                hA1 = this.password;
            } else {
                A1 = this.username + ":" + realm + ":" + this.password;
                hA1 = RFC2617Digest.H(A1, digest);
            }
        } else if (algorithm.equals("MD5-sess")) {
            if (this.passwordIsA1Hash) {
                hA1 = this.password + ":" + nonce + ":" + cnonce;
            } else {
                A1 = this.username + ":" + realm + ":" + this.password;
                hA1 = RFC2617Digest.H(A1, digest) + ":" + nonce + ":" + cnonce;
            }
        } else {
            throw PicketBoxMessages.MESSAGES.unsupportedAlgorithm(algorithm);
        }
        String hA2 = (String)this.info.getInfo(A2HASH);
        if (hA2 == null) {
            String A2 = null;
            if (qop != null && !qop.equals("auth")) {
                throw PicketBoxMessages.MESSAGES.unsupportedQOP(qop);
            }
            A2 = method + ":" + digestURI;
            hA2 = RFC2617Digest.H(A2, digest);
        }
        if (qop == null) {
            extra = nonce + ":" + hA2;
            RFC2617Digest.KD(hA1, extra, digest);
        } else if (qop.equals("auth")) {
            extra = nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + hA2;
            RFC2617Digest.KD(hA1, extra, digest);
        }
    }

    public String getInfoDigest(MessageDigest digest) {
        if (this.rfc2617 == null) {
            byte[] data = digest.digest();
            this.rfc2617 = RFC2617Digest.cvtHex(data);
        }
        return this.rfc2617;
    }

    private static String H(String data, MessageDigest digest) {
        digest.reset();
        byte[] x = digest.digest(data.getBytes());
        return RFC2617Digest.cvtHex(x);
    }

    private static void KD(String secret, String data, MessageDigest digest) {
        String x = secret + ":" + data;
        digest.reset();
        digest.update(x.getBytes());
    }

    static String cvtHex(byte[] data) {
        char[] hash = new char[32];
        for (int i = 0; i < 16; ++i) {
            int j = data[i] >> 4 & 0xF;
            hash[i * 2] = MD5_HEX[j];
            j = data[i] & 0xF;
            hash[i * 2 + 1] = MD5_HEX[j];
        }
        return new String(hash);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        if (args.length != 3) {
            System.err.println("Usage: RFC2617Digest username realm password");
            System.err.println(" - username : the username");
            System.err.println(" - realm : the web app realm name");
            System.err.println(" - password : the plain text password");
            System.exit(1);
        }
        String username = args[0];
        String realm = args[1];
        String password = args[2];
        String A1 = username + ":" + realm + ":" + password;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String hA1 = RFC2617Digest.H(A1, digest);
        System.out.println("RFC2617 A1 hash: " + hA1);
    }
}

