/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.auth.spi.Users;
import org.jboss.security.config.parser.ParserNamespaceSupport;
import org.jboss.security.config.parser.StaxParserUtil;

public class UsersConfigParser
implements ParserNamespaceSupport {
    private static final String NAMESPACE_URI = "urn:jboss:user-roles";

    @Override
    public Users parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        Users users = new Users();
        XMLEvent xmlEvent = null;
        while (xmlEventReader.hasNext()) {
            StartElement roleElement;
            StartElement se;
            xmlEvent = xmlEventReader.peek();
            if (xmlEvent instanceof StartElement && "module-option".equals(StaxParserUtil.getStartElementName(se = (StartElement)xmlEvent))) {
                return users;
            }
            if (xmlEvent instanceof EndElement) {
                xmlEvent = xmlEventReader.nextEvent();
                continue;
            }
            xmlEvent = xmlEventReader.nextEvent();
            Users.User user = new Users.User();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            Iterator<Attribute> attribs = peekedStartElement.getAttributes();
            while (attribs.hasNext()) {
                Attribute attrib = attribs.next();
                if ("name".equals(attrib.getName().getLocalPart())) {
                    user.setName(attrib.getValue());
                    continue;
                }
                if ("password".equals(attrib.getName().getLocalPart())) {
                    user.setPassword(attrib.getValue());
                    continue;
                }
                if (!"encoding".equals(attrib.getName().getLocalPart())) continue;
                user.setEncoding(attrib.getValue());
            }
            xmlEvent = xmlEventReader.peek();
            while (xmlEvent != null && xmlEvent.getEventType() == 1 && "role".equals((roleElement = (StartElement)xmlEvent).getName().getLocalPart())) {
                xmlEvent = xmlEventReader.nextEvent();
                Iterator<Attribute> roleAttribs = roleElement.getAttributes();
                String roleName = null;
                String groupName = "Roles";
                while (roleAttribs.hasNext()) {
                    Attribute roleAttribute = roleAttribs.next();
                    String attributeValue = StaxParserUtil.getAttributeValue(roleAttribute);
                    if ("name".equals(roleAttribute.getName().getLocalPart())) {
                        roleName = attributeValue;
                        continue;
                    }
                    if (!"group".equals(roleAttribute.getName().getLocalPart())) continue;
                    groupName = attributeValue;
                }
                if (roleName != null) {
                    user.addRole(roleName, groupName);
                }
                xmlEvent = xmlEventReader.peek();
            }
            users.addUser(user);
        }
        return users;
    }

    @Override
    public boolean supports(String namespaceURI) {
        return NAMESPACE_URI.equals(namespaceURI);
    }
}

